/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.dependency.AbstractInstructionAnalyzer;
import com.antgroup.antchain.myjava.dependency.DataFlowGraphBuilder;
import com.antgroup.antchain.myjava.dependency.DefaultCallGraphNode;
import com.antgroup.antchain.myjava.dependency.DependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.DependencyConsumer;
import com.antgroup.antchain.myjava.dependency.DependencyNode;
import com.antgroup.antchain.myjava.dependency.DependencyType;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.dependency.VirtualCallConsumer;
import com.antgroup.antchain.myjava.interop.NativeInNoJvm;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.BasicBlockReader;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.IncomingReader;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.PhiReader;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TryCatchBlockReader;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.VariableReader;
import com.antgroup.antchain.myjava.model.instructions.ArrayElementType;
import com.antgroup.antchain.myjava.model.text.ListingBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DependencyGraphBuilder {
    private static final Logger log = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private static final MethodDescriptor GET_CLASS = new MethodDescriptor("getClass", Class.class);
    private DependencyAnalyzer dependencyAnalyzer;
    private DependencyNode[] nodes;
    private DependencyNode resultNode;
    private Program program;
    private DefaultCallGraphNode caller;
    private ExceptionConsumer currentExceptionConsumer;
    private AbstractInstructionAnalyzer reader = new AbstractInstructionAnalyzer(){

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[assignee.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (valueNode != null && receiverNode != null) {
                valueNode.connect(receiverNode);
            }
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, ValueType targetType) {
            super.cast(receiver, value, targetType);
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            ClassReaderSource classSource = DependencyGraphBuilder.this.dependencyAnalyzer.getClassSource();
            if (targetType instanceof ValueType.Object) {
                String targetClsName = ((ValueType.Object)targetType).getClassName();
                ClassReader targetClass = classSource.get(targetClsName);
                if (targetClass != null && !targetClass.getName().equals("java.lang.Object")) {
                    if (valueNode != null && receiverNode != null) {
                        valueNode.connect(receiverNode, DependencyGraphBuilder.this.dependencyAnalyzer.getSuperClassFilter(targetClass.getName()));
                    }
                    return;
                }
            } else if (targetType instanceof ValueType.Array) {
                ClassReader targetClass;
                ValueType itemType = targetType;
                while (itemType instanceof ValueType.Array) {
                    itemType = ((ValueType.Array)itemType).getItemType();
                }
                if (itemType instanceof ValueType.Object && (targetClass = classSource.get(((ValueType.Object)itemType).getClassName())) == null) {
                    valueNode.connect(receiverNode);
                    return;
                }
                if (valueNode != null && receiverNode != null) {
                    valueNode.connect(receiverNode, DependencyGraphBuilder.this.dependencyAnalyzer.getSuperClassFilter(targetType.toString()));
                }
                return;
            }
            if (valueNode != null && receiverNode != null) {
                valueNode.connect(receiverNode);
            }
        }

        @Override
        public void exit(VariableReader valueToReturn) {
            DependencyNode node;
            if (valueToReturn != null && (node = DependencyGraphBuilder.this.nodes[valueToReturn.getIndex()]) != null) {
                node.connect(DependencyGraphBuilder.this.resultNode);
            }
        }

        @Override
        public void raise(VariableReader exception) {
            DependencyGraphBuilder.this.nodes[exception.getIndex()].addConsumer(DependencyGraphBuilder.this.currentExceptionConsumer);
        }

        @Override
        public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (arrayNode != null && receiverNode != null) {
                arrayNode.connect(receiverNode);
            }
        }

        @Override
        public void cloneArray(VariableReader receiver, VariableReader array) {
            DependencyNode arrayNode = this.getNode(array);
            DependencyNode receiverNode = this.getNode(receiver);
            if (arrayNode != null && receiverNode != null) {
                arrayNode.addConsumer(receiverNode::propagate);
                arrayNode.getArrayItem().connect(receiverNode.getArrayItem());
            }
            MethodDependency cloneDep = this.getAnalyzer().linkMethod(CLONE_METHOD);
            cloneDep.addLocation(this.getCallLocation());
            if (arrayNode != null) {
                arrayNode.connect(cloneDep.getVariable(0));
            }
            cloneDep.use();
        }

        @Override
        public void getElement(VariableReader receiver, VariableReader array, VariableReader index, ArrayElementType type) {
            if (this.isPrimitive(type)) {
                return;
            }
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (arrayNode != null && receiverNode != null && receiverNode != arrayNode.getArrayItem()) {
                arrayNode.getArrayItem().connect(receiverNode);
            }
        }

        @Override
        public void putElement(VariableReader array, VariableReader index, VariableReader value, ArrayElementType type) {
            if (this.isPrimitive(type)) {
                return;
            }
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()];
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            if (valueNode != null && arrayNode != null && valueNode != arrayNode.getArrayItem()) {
                valueNode.connect(arrayNode.getArrayItem());
            }
        }

        private boolean isPrimitive(ArrayElementType type) {
            return type != ArrayElementType.OBJECT;
        }

        @Override
        protected void invokeSpecial(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
            if (this.handleSpecialMethod(receiver, instance, method)) {
                return;
            }
            CallLocation callLocation = this.getCallLocation();
            if (instance == null) {
                DependencyGraphBuilder.this.dependencyAnalyzer.linkClass(method.getClassName()).initClass(callLocation);
            } else {
                DependencyGraphBuilder.this.dependencyAnalyzer.linkClass(method.getClassName());
            }
            MethodDependency methodDep = DependencyGraphBuilder.this.dependencyAnalyzer.linkMethod(method);
            methodDep.addLocation(callLocation);
            methodDep.use(false);
            if (methodDep.isMissing()) {
                return;
            }
            DependencyNode[] targetParams = methodDep.getVariables();
            for (int i = 0; i < arguments.size(); ++i) {
                DependencyNode value = DependencyGraphBuilder.this.nodes[arguments.get(i).getIndex()];
                DependencyNode param = targetParams[i + 1];
                if (value == null || param == null) continue;
                value.connect(param);
            }
            if (instance != null) {
                DependencyGraphBuilder.this.nodes[instance.getIndex()].connect(targetParams[0]);
            }
            if (methodDep.getResult() != null && receiver != null) {
                DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
                if (methodDep.getResult() != null && receiverNode != null) {
                    methodDep.getResult().connect(receiverNode);
                }
            }
            methodDep.getThrown().addConsumer(DependencyGraphBuilder.this.currentExceptionConsumer);
            this.initClass(method.getClassName());
        }

        @Override
        protected void invokeVirtual(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
            if (this.handleSpecialMethod(receiver, instance, method)) {
                return;
            }
            DependencyNode[] actualArgs = new DependencyNode[arguments.size() + 1];
            for (int i = 0; i < arguments.size(); ++i) {
                actualArgs[i + 1] = DependencyGraphBuilder.this.nodes[arguments.get(i).getIndex()];
            }
            actualArgs[0] = this.getNode(instance);
            VirtualCallConsumer listener = new VirtualCallConsumer(this.getNode(instance), method.getClassName(), method.getDescriptor(), DependencyGraphBuilder.this.dependencyAnalyzer, actualArgs, receiver != null ? this.getNode(receiver) : null, this.getCallLocation(), DependencyGraphBuilder.this.currentExceptionConsumer);
            this.getNode(instance).addConsumer(listener);
            DependencyGraphBuilder.this.dependencyAnalyzer.linkMethod(method.getClassName(), method.getDescriptor()).use();
            DependencyGraphBuilder.this.dependencyAnalyzer.getClassSource().overriddenMethods(method).forEach(methodImpl -> {
                MethodDependency implDep = DependencyGraphBuilder.this.dependencyAnalyzer.linkMethod(methodImpl.getReference()).addLocation(this.getCallLocation());
                implDep.use();
            });
        }

        private boolean handleSpecialMethod(VariableReader receiver, VariableReader instance, MethodReference method) {
            if (method.getDescriptor().equals(GET_CLASS)) {
                this.invokeGetClass(receiver, instance);
                return true;
            }
            if (method.getClassName().equals("java.lang.Class")) {
                switch (method.getName()) {
                    case "getComponentType": {
                        this.invokeGetComponentType(receiver, instance, method);
                        return true;
                    }
                    case "getSuperclass": {
                        this.invokeGetSuperclass(receiver, instance, method);
                        return true;
                    }
                    case "getInterfaces": {
                        this.invokeGetInterfaces(receiver, instance, method);
                        return true;
                    }
                }
            }
            return false;
        }

        private void invokeGetClass(VariableReader receiver, VariableReader instance) {
            MethodDependency getClassDep = DependencyGraphBuilder.this.dependencyAnalyzer.linkMethod("java.lang.Object", GET_CLASS);
            getClassDep.addLocation(this.getCallLocation());
            this.getNode(instance).addConsumer(t -> {
                getClassDep.getVariable(0).propagate(t);
                if (receiver != null) {
                    this.getNode(receiver).getClassValueNode().propagate(t);
                }
            });
            if (receiver != null) {
                this.getNode(receiver).propagate(DependencyGraphBuilder.this.dependencyAnalyzer.getType("java.lang.Class"));
            }
            getClassDep.use();
        }

        private void invokeGetComponentType(VariableReader receiver, VariableReader instance, MethodReference methodReference) {
            MethodDependency methodDep = DependencyGraphBuilder.this.dependencyAnalyzer.linkMethod(methodReference);
            methodDep.use();
            DependencyNode instanceNode = this.getNode(instance);
            DependencyNode receiverNode = this.getNode(receiver);
            if (receiverNode != null) {
                receiverNode.propagate(((DependencyGraphBuilder)DependencyGraphBuilder.this).dependencyAnalyzer.classType);
            }
            instanceNode.getClassValueNode().addConsumer(t -> {
                if (!t.getName().startsWith("[")) {
                    return;
                }
                String typeName = t.getName().substring(1);
                if (typeName.charAt(0) == 'L') {
                    typeName = ((ValueType.Object)ValueType.parse(typeName)).getClassName();
                }
                if (receiverNode != null) {
                    receiverNode.getClassValueNode().propagate(DependencyGraphBuilder.this.dependencyAnalyzer.getType(typeName));
                }
                methodDep.getVariable(0).propagate(t);
            });
        }

        private void invokeGetSuperclass(VariableReader receiver, VariableReader instance, MethodReference methodReference) {
            MethodDependency methodDep = DependencyGraphBuilder.this.dependencyAnalyzer.linkMethod(methodReference);
            methodDep.use();
            DependencyNode instanceNode = this.getNode(instance);
            DependencyNode receiverNode = this.getNode(receiver);
            receiverNode.propagate(((DependencyGraphBuilder)DependencyGraphBuilder.this).dependencyAnalyzer.classType);
            instanceNode.getClassValueNode().addConsumer(type -> {
                String className = type.getName();
                if (className.startsWith("[")) {
                    return;
                }
                ClassReader cls = DependencyGraphBuilder.this.dependencyAnalyzer.getClassSource().get(className);
                if (cls != null && cls.getParent() != null) {
                    receiverNode.getClassValueNode().propagate(DependencyGraphBuilder.this.dependencyAnalyzer.getType(cls.getParent()));
                }
                methodDep.getVariable(0).propagate(type);
            });
        }

        private void invokeGetInterfaces(VariableReader receiver, VariableReader instance, MethodReference methodReference) {
            MethodDependency methodDep = DependencyGraphBuilder.this.dependencyAnalyzer.linkMethod(methodReference);
            methodDep.use();
            DependencyNode instanceNode = this.getNode(instance);
            if (receiver == null && instanceNode != null) {
                log.info("null receiver in invokeGetInterfaces in {}", (Object)instanceNode.method);
            }
            DependencyNode receiverNode = this.getNode(receiver);
            receiverNode.propagate(((DependencyGraphBuilder)DependencyGraphBuilder.this).dependencyAnalyzer.classType);
            instanceNode.getClassValueNode().addConsumer(type -> {
                String className = type.getName();
                if (className.startsWith("[")) {
                    return;
                }
                ClassReader cls = DependencyGraphBuilder.this.dependencyAnalyzer.getClassSource().get(className);
                if (cls != null) {
                    for (String iface : cls.getInterfaces()) {
                        receiverNode.getClassValueNode().propagate(DependencyGraphBuilder.this.dependencyAnalyzer.getType(iface));
                    }
                }
                methodDep.getVariable(0).propagate(type);
            });
        }

        @Override
        public void nullCheck(VariableReader receiver, VariableReader value) {
            super.nullCheck(receiver, value);
            DependencyGraphBuilder.this.currentExceptionConsumer.consume(DependencyGraphBuilder.this.dependencyAnalyzer.getType("java.lang.NullPointerException"));
        }

        @Override
        protected DependencyNode getNode(VariableReader variable) {
            if (variable == null) {
                log.warn("null variable in DependencyNode");
                return null;
            }
            if (variable.getIndex() >= DependencyGraphBuilder.this.nodes.length) {
                log.error("invalid variable {} index {} in program ", (Object)variable.getDebugName(), (Object)variable.getIndex());
            }
            return DependencyGraphBuilder.this.nodes[variable.getIndex()];
        }

        @Override
        protected DependencyAnalyzer getAnalyzer() {
            return DependencyGraphBuilder.this.dependencyAnalyzer;
        }
    };

    DependencyGraphBuilder(DependencyAnalyzer dependencyAnalyzer) {
        this.dependencyAnalyzer = dependencyAnalyzer;
    }

    public void buildGraph(MethodDependency dep, ClassReaderSource classSource) {
        block18: {
            int i;
            this.caller = this.dependencyAnalyzer.callGraph.getNode(dep.getReference());
            MethodHolder method = dep.method;
            if (method.getProgram() == null || method.getProgram().basicBlockCount() == 0) {
                return;
            }
            if (method.getAnnotations().get(NativeInNoJvm.class.getName()) != null) {
                return;
            }
            this.program = method.getProgram();
            this.resultNode = dep.getResult();
            DataFlowGraphBuilder dfgBuilder = new DataFlowGraphBuilder();
            boolean[] significantParams = new boolean[dep.getParameterCount()];
            significantParams[0] = true;
            for (int i3 = 1; i3 < dep.getParameterCount(); ++i3) {
                ValueType arg = method.parameterType(i3 - 1);
                if (arg instanceof ValueType.Primitive) continue;
                significantParams[i3] = true;
            }
            int[] nodeMapping = dfgBuilder.buildMapping(this.program, significantParams, !(method.getResultType() instanceof ValueType.Primitive) && method.getResultType() != ValueType.VOID);
            if (DependencyAnalyzer.shouldLog) {
                log.info("Method reached: {}", (Object)method.getReference());
                StringBuilder toShowLogLineSb = new StringBuilder();
                toShowLogLineSb.append(new ListingBuilder().buildListing(this.program, "    "));
                for (int i2 = 0; i2 < nodeMapping.length; ++i2) {
                    toShowLogLineSb.append(i2 + ":" + nodeMapping[i2] + " ");
                }
                log.info(toShowLogLineSb.toString());
                log.info("");
            }
            int nodeClassCount = 0;
            for (int i2 = 0; i2 < nodeMapping.length; ++i2) {
                nodeClassCount = Math.max(nodeClassCount, nodeMapping[i2] + 1);
            }
            DependencyNode[] nodeClasses = Arrays.copyOf(dep.getVariables(), nodeClassCount);
            MethodReference ref = method.getReference();
            for (i = dep.getVariableCount(); i < nodeClasses.length; ++i) {
                nodeClasses[i] = this.dependencyAnalyzer.createNode();
                nodeClasses[i].method = ref;
                if (!DependencyAnalyzer.shouldTag) continue;
                nodeClasses[i].setTag(dep.getMethod().getReference() + ":" + i);
            }
            this.nodes = new DependencyNode[dep.getMethod().getProgram().variableCount()];
            for (i = 0; i < this.nodes.length; ++i) {
                int mappedNode = nodeMapping[i];
                this.nodes[i] = mappedNode >= 0 ? nodeClasses[mappedNode] : null;
            }
            dep.setVariables(this.nodes);
            this.reader.setCaller(this.caller.getMethod());
            this.reader.setClassSource(classSource);
            for (i = 0; i < this.program.basicBlockCount(); ++i) {
                BasicBlock block = this.program.basicBlockAt(i);
                this.currentExceptionConsumer = this.createExceptionConsumer(dep, block);
                block.readAllInstructions(this.reader);
                for (PhiReader phiReader : block.readPhis()) {
                    DependencyNode receiverNode = this.nodes[phiReader.getReceiver().getIndex()];
                    for (IncomingReader incomingReader : phiReader.readIncomings()) {
                        DependencyNode incomingNode = this.nodes[incomingReader.getValue().getIndex()];
                        if (incomingNode == null || receiverNode == null) continue;
                        incomingNode.connect(receiverNode);
                    }
                }
                for (TryCatchBlockReader tryCatchBlockReader : block.readTryCatchBlocks()) {
                    if (tryCatchBlockReader.getExceptionType() == null) continue;
                    this.dependencyAnalyzer.linkClass(tryCatchBlockReader.getExceptionType());
                }
            }
            if (!method.hasModifier(ElementModifier.SYNCHRONIZED)) break block18;
            ArrayList<DependencyNode> syncNodes = new ArrayList<DependencyNode>();
            if (this.dependencyAnalyzer.asyncSupported) {
                MethodDependency methodDep = this.dependencyAnalyzer.linkMethod(AbstractInstructionAnalyzer.MONITOR_ENTER_METHOD);
                syncNodes.add(methodDep.getVariable(1));
                methodDep.use();
            }
            MethodDependency methodDep = this.dependencyAnalyzer.linkMethod(AbstractInstructionAnalyzer.MONITOR_ENTER_SYNC_METHOD);
            syncNodes.add(methodDep.getVariable(1));
            methodDep.use();
            if (this.dependencyAnalyzer.asyncSupported) {
                methodDep = this.dependencyAnalyzer.linkMethod(AbstractInstructionAnalyzer.MONITOR_EXIT_METHOD);
                syncNodes.add(methodDep.getVariable(1));
                methodDep.use();
            }
            methodDep = this.dependencyAnalyzer.linkMethod(AbstractInstructionAnalyzer.MONITOR_EXIT_SYNC_METHOD);
            syncNodes.add(methodDep.getVariable(1));
            methodDep.use();
            if (method.hasModifier(ElementModifier.STATIC)) {
                for (DependencyNode dependencyNode : syncNodes) {
                    dependencyNode.propagate(this.dependencyAnalyzer.getType("java.lang.Class"));
                }
            } else {
                for (DependencyNode dependencyNode : syncNodes) {
                    this.nodes[0].connect(dependencyNode);
                }
            }
        }
    }

    private ExceptionConsumer createExceptionConsumer(MethodDependency methodDep, BasicBlockReader block) {
        List<? extends TryCatchBlockReader> tryCatchBlocks = block.readTryCatchBlocks();
        ClassReader[] exceptions = new ClassReader[tryCatchBlocks.size()];
        DependencyNode[] vars = new DependencyNode[tryCatchBlocks.size()];
        for (int i = 0; i < tryCatchBlocks.size(); ++i) {
            TryCatchBlockReader tryCatch = tryCatchBlocks.get(i);
            if (tryCatch.getExceptionType() != null) {
                exceptions[i] = this.dependencyAnalyzer.getClassSource().get(tryCatch.getExceptionType());
            }
            if (tryCatch.getHandler().getExceptionVariable() == null) continue;
            vars[i] = methodDep.getVariable(tryCatch.getHandler().getExceptionVariable().getIndex());
        }
        return new ExceptionConsumer(this.dependencyAnalyzer, exceptions, vars, methodDep);
    }

    static class ExceptionConsumer
    implements DependencyConsumer {
        private DependencyAnalyzer analyzer;
        private ClassReader[] exceptions;
        private DependencyNode[] vars;
        private MethodDependency method;

        ExceptionConsumer(DependencyAnalyzer analyzer, ClassReader[] exceptions, DependencyNode[] vars, MethodDependency method) {
            this.analyzer = analyzer;
            this.exceptions = exceptions;
            this.vars = vars;
            this.method = method;
        }

        @Override
        public void consume(DependencyType type) {
            ClassHierarchy hierarchy = this.analyzer.getClassHierarchy();
            for (int i = 0; i < this.exceptions.length; ++i) {
                if (this.exceptions[i] != null && !hierarchy.isSuperType(this.exceptions[i].getName(), type.getName(), false)) continue;
                if (this.vars[i] != null) {
                    this.vars[i].propagate(type);
                }
                return;
            }
            this.method.getThrown().propagate(type);
        }
    }
}

