/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.cache.IncrementalDependencyRegistration;
import com.antgroup.antchain.myjava.callgraph.CallGraph;
import com.antgroup.antchain.myjava.common.ServiceRepository;
import com.antgroup.antchain.myjava.dependency.ClassDependency;
import com.antgroup.antchain.myjava.dependency.ClassDependencyInfo;
import com.antgroup.antchain.myjava.dependency.DependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.DependencyInfo;
import com.antgroup.antchain.myjava.dependency.DependencyNode;
import com.antgroup.antchain.myjava.dependency.DependencyType;
import com.antgroup.antchain.myjava.dependency.FieldDependency;
import com.antgroup.antchain.myjava.dependency.FieldDependencyInfo;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.dependency.MethodDependencyInfo;
import com.antgroup.antchain.myjava.diagnostics.Diagnostics;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import java.util.Collection;

public class DependencyAgent
implements DependencyInfo,
ServiceRepository {
    private DependencyAnalyzer analyzer;

    DependencyAgent(DependencyAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public DependencyNode createNode() {
        return this.analyzer.createNode();
    }

    public DependencyType getType(String name) {
        return this.analyzer.getType(name);
    }

    public String generateClassName() {
        return this.analyzer.generateClassName();
    }

    public String submitClassFile(byte[] data) {
        return this.analyzer.submitClassFile(data);
    }

    public void submitClass(ClassHolder cls) {
        this.analyzer.submitClass(cls);
    }

    public void submitMethod(MethodReference method, Program program) {
        this.analyzer.submitMethod(method, program);
    }

    public MethodDependency linkMethod(MethodReference methodRef) {
        return this.analyzer.linkMethod(methodRef);
    }

    public MethodDependency linkMethod(String className, MethodDescriptor descriptor) {
        return this.analyzer.linkMethod(className, descriptor);
    }

    public ClassDependency linkClass(String className) {
        return this.analyzer.linkClass(className);
    }

    public FieldDependency linkField(FieldReference fieldRef) {
        return this.analyzer.linkField(fieldRef);
    }

    public Diagnostics getDiagnostics() {
        return this.analyzer.getDiagnostics();
    }

    @Override
    public <T> T getService(Class<T> type) {
        return this.analyzer.getService(type);
    }

    @Override
    public ClassReaderSource getClassSource() {
        return this.analyzer.agentClassSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.analyzer.getClassLoader();
    }

    public ClassHierarchy getClassHierarchy() {
        return this.analyzer.getClassHierarchy();
    }

    @Override
    public Collection<MethodReference> getReachableMethods() {
        return this.analyzer.getReachableMethods();
    }

    @Override
    public Collection<FieldReference> getReachableFields() {
        return this.analyzer.getReachableFields();
    }

    @Override
    public Collection<String> getReachableClasses() {
        return this.analyzer.getReachableClasses();
    }

    @Override
    public FieldDependencyInfo getField(FieldReference fieldRef) {
        return this.analyzer.getField(fieldRef);
    }

    @Override
    public MethodDependencyInfo getMethod(MethodReference methodRef) {
        return this.analyzer.getMethod(methodRef);
    }

    @Override
    public MethodDependencyInfo getMethodImplementation(MethodReference methodRef) {
        return this.analyzer.getMethodImplementation(methodRef);
    }

    @Override
    public ClassDependencyInfo getClass(String className) {
        return this.analyzer.getClass(className);
    }

    @Override
    public CallGraph getCallGraph() {
        return this.analyzer.getCallGraph();
    }

    public IncrementalDependencyRegistration getIncrementalCache() {
        return this.analyzer.incrementalCache;
    }

    void cleanup() {
        this.analyzer = null;
    }
}

