/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.debugging.information;

import com.antgroup.antchain.myjava.common.RecordArray;
import com.antgroup.antchain.myjava.common.RecordArrayBuilder;
import com.antgroup.antchain.myjava.debugging.information.DebugInformation;
import com.antgroup.antchain.myjava.model.ReferenceCache;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

class DebugInformationReader {
    private InputStream input;
    private int lastNumber;
    private ReferenceCache referenceCache;

    DebugInformationReader(InputStream input, ReferenceCache referenceCache) {
        this.input = input;
        this.referenceCache = referenceCache;
    }

    public DebugInformation read() throws IOException {
        DebugInformation debugInfo = new DebugInformation(this.referenceCache);
        debugInfo.fileNames = this.readStrings();
        debugInfo.classNames = this.readStrings();
        debugInfo.fields = this.readStrings();
        debugInfo.methods = this.readStrings();
        debugInfo.variableNames = this.readStrings();
        debugInfo.exactMethods = this.readExactMethods();
        debugInfo.layers = new DebugInformation.Layer[this.input.read()];
        for (int i = 0; i < debugInfo.layers.length; ++i) {
            DebugInformation.Layer layer = new DebugInformation.Layer();
            layer.fileMapping = this.readMapping();
            layer.lineMapping = this.readMapping();
            layer.classMapping = this.readMapping();
            layer.methodMapping = this.readMapping();
            debugInfo.layers[i] = layer;
        }
        debugInfo.statementStartMapping = this.readBooleanMapping();
        debugInfo.callSiteMapping = this.readCallSiteMapping();
        debugInfo.variableMappings = this.readVariableMappings(debugInfo.variableNames.length);
        debugInfo.classesMetadata = this.readClassesMetadata(debugInfo.classNames.length);
        debugInfo.controlFlowGraphs = this.readCFGs(debugInfo.fileNames.length);
        debugInfo.rebuild();
        return debugInfo;
    }

    private RecordArray[] readVariableMappings(int count) throws IOException {
        RecordArray[] mappings = new RecordArray[count];
        int varCount = this.readUnsignedNumber();
        int lastVar = 0;
        while (varCount-- > 0) {
            mappings[lastVar += this.readUnsignedNumber()] = this.readMultiMapping();
        }
        return mappings;
    }

    private List<DebugInformation.ClassMetadata> readClassesMetadata(int count) throws IOException {
        ArrayList<DebugInformation.ClassMetadata> classes = new ArrayList<DebugInformation.ClassMetadata>(count);
        for (int i = 0; i < count; ++i) {
            DebugInformation.ClassMetadata cls = new DebugInformation.ClassMetadata();
            classes.add(cls);
            cls.id = i;
            cls.jsName = this.readNullableString();
            cls.parentId = this.readUnsignedNumber() - 1;
            if (cls.parentId.equals(-1)) {
                cls.parentId = null;
            }
            int entryCount = this.readUnsignedNumber();
            this.resetRelativeNumber();
            for (int j = 0; j < entryCount; ++j) {
                int key = this.readRelativeNumber();
                int value = this.readUnsignedNumber();
                cls.fieldMap.put(key, value);
            }
        }
        return classes;
    }

    private RecordArray[] readCFGs(int count) throws IOException {
        RecordArray[] cfgs = new RecordArray[count];
        for (int i = 0; i < count; ++i) {
            cfgs[i] = this.readCFG();
        }
        return cfgs;
    }

    private RecordArray readCFG() throws IOException {
        RecordArrayBuilder builder = new RecordArrayBuilder(1, 1);
        int size = this.readUnsignedNumber();
        for (int i = 0; i < size; ++i) {
            builder.add();
        }
        int[] types = this.readRle(size);
        int nonEmptyItems = 0;
        for (int i = 0; i < size; ++i) {
            int type = types[i];
            builder.get(i).set(0, type);
            if (type == 0) continue;
            ++nonEmptyItems;
        }
        int[] sizes = this.readRle(nonEmptyItems);
        int j = 0;
        int totalSize = 0;
        for (int sz : sizes) {
            totalSize += sz;
        }
        int[] files = this.readRle(totalSize);
        int[] lines = this.readRle(totalSize);
        int lastFile = 0;
        int lastLine = 0;
        int index = 0;
        for (int i = 0; i < sizes.length; ++i) {
            while (types[j] == 0) {
                ++j;
            }
            size = sizes[i];
            RecordArrayBuilder.SubArray array = builder.get(j++).getArray(0);
            for (int k = 0; k < size; ++k) {
                array.add(lastFile += this.processSign(files[index]));
                array.add(lastLine += this.processSign(lines[index]));
                ++index;
            }
        }
        return builder.build();
    }

    private int processSign(int number) {
        boolean negative = (number & 1) != 0;
        return !negative ? number : -(number >>>= 1);
    }

    private RecordArray readMultiMapping() throws IOException {
        RecordArrayBuilder builder = this.readLinesAndColumns(2, 1);
        for (int i = 0; i < builder.size(); ++i) {
            int count = this.readUnsignedNumber();
            RecordArrayBuilder.SubArray array = builder.get(i).getArray(0);
            int last = 0;
            for (int j = 0; j < count; ++j) {
                array.add(last += this.readNumber());
            }
        }
        return builder.build();
    }

    private RecordArray readBooleanMapping() throws IOException {
        RecordArrayBuilder builder = this.readLinesAndColumns(2, 0);
        return builder.build();
    }

    private RecordArray readMapping() throws IOException {
        RecordArrayBuilder builder = this.readLinesAndColumns(3, 0);
        this.readValues(builder);
        return builder.build();
    }

    private RecordArray readCallSiteMapping() throws IOException {
        RecordArrayBuilder builder = this.readLinesAndColumns(4, 0);
        this.readValues(builder);
        this.readCallSites(builder);
        return builder.build();
    }

    private RecordArrayBuilder readLinesAndColumns(int fields, int arrays) throws IOException {
        RecordArrayBuilder builder = new RecordArrayBuilder(fields, arrays);
        int size = this.readUnsignedNumber();
        for (int i = 0; i < size; ++i) {
            builder.add();
        }
        int[] lines = this.extractLines(this.readRle(builder.size()));
        int[] columns = this.extractColumns(this.readRle(builder.size()), lines);
        for (int i = 0; i < builder.size(); ++i) {
            RecordArrayBuilder.Record record = builder.get(i);
            record.set(0, lines[i]);
            record.set(1, columns[i]);
        }
        return builder;
    }

    private void readValues(RecordArrayBuilder builder) throws IOException {
        int[] values = this.extractValues(this.readRle(builder.size()));
        for (int i = 0; i < builder.size(); ++i) {
            builder.get(i).set(2, values[i]);
        }
    }

    private void readCallSites(RecordArrayBuilder builder) throws IOException {
        int sz = 0;
        for (int i = 0; i < builder.size(); ++i) {
            if (builder.get(i).get(2) == 0) continue;
            ++sz;
        }
        int[] data = this.readRle(sz);
        int j = 0;
        int last = 0;
        for (int i = 0; i < builder.size(); ++i) {
            if (builder.get(i).get(2) == 0) continue;
            builder.get(i).set(3, last += this.processSign(data[j++]));
        }
    }

    private int[] extractLines(int[] lines) {
        int last = 0;
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = last += lines[i];
        }
        return lines;
    }

    private int[] extractColumns(int[] columns, int[] lines) {
        int last = 0;
        int lastLine = -1;
        for (int i = 0; i < columns.length; ++i) {
            if (lines[i] != lastLine) {
                lastLine = lines[i];
                last = 0;
            }
            columns[i] = last += columns[i];
        }
        return columns;
    }

    private int[] extractValues(int[] values) {
        int last = 0;
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            values[i] = value == 0 ? -1 : (last += this.processSign(value - 1));
        }
        return values;
    }

    private String[] readStrings() throws IOException {
        String[] array = new String[this.readUnsignedNumber()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readString();
        }
        return array;
    }

    private long[] readExactMethods() throws IOException {
        long[] result = new long[this.readUnsignedNumber()];
        int lastClass = 0;
        int lastMethod = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = (long)(lastClass += this.readNumber()) << 32 | (long)(lastMethod += this.readNumber());
        }
        return result;
    }

    private int[] readRle(int size) throws IOException {
        int[] array = new int[size];
        int i = 0;
        while (i < size) {
            int count = this.readUnsignedNumber();
            boolean repeat = (count & 1) != 0;
            count >>>= 1;
            if (!repeat) {
                while (count-- > 0) {
                    array[i++] = this.readUnsignedNumber();
                }
                continue;
            }
            int n = this.readUnsignedNumber();
            while (count-- > 0) {
                array[i++] = n;
            }
        }
        return array;
    }

    private int readNumber() throws IOException {
        return this.processSign(this.readUnsignedNumber());
    }

    private int readUnsignedNumber() throws IOException {
        byte b;
        int number = 0;
        int shift = 0;
        do {
            int r;
            if ((r = this.input.read()) < 0) {
                throw new EOFException();
            }
            b = (byte)r;
            number |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return number;
    }

    private int readRelativeNumber() throws IOException {
        this.lastNumber += this.readNumber();
        return this.lastNumber;
    }

    private void resetRelativeNumber() {
        this.lastNumber = 0;
    }

    private String readString() throws IOException {
        return this.readStringChars(this.readUnsignedNumber());
    }

    private String readNullableString() throws IOException {
        int size = this.readUnsignedNumber();
        return size > 0 ? this.readStringChars(size - 1) : null;
    }

    private String readStringChars(int size) throws IOException {
        int read;
        byte[] bytes = new byte[size];
        for (int pos = 0; pos < bytes.length; pos += read) {
            read = this.input.read(bytes, pos, bytes.length - pos);
            if (read != -1) continue;
            throw new EOFException();
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

