/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.debugging;

import com.antgroup.antchain.myjava.common.Promise;
import com.antgroup.antchain.myjava.debugging.Debugger;
import com.antgroup.antchain.myjava.debugging.Variable;
import com.antgroup.antchain.myjava.debugging.information.DebugInformation;
import com.antgroup.antchain.myjava.debugging.javascript.JavaScriptValue;
import com.antgroup.antchain.myjava.debugging.javascript.JavaScriptVariable;
import java.util.HashMap;
import java.util.Map;

public class Value {
    private Debugger debugger;
    private DebugInformation debugInformation;
    private JavaScriptValue jsValue;
    private Promise<Map<String, Variable>> properties;
    private Promise<String> type;

    Value(Debugger debugger, DebugInformation debugInformation, JavaScriptValue jsValue) {
        this.debugger = debugger;
        this.debugInformation = debugInformation;
        this.jsValue = jsValue;
    }

    private static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public Promise<String> getRepresentation() {
        return this.jsValue.getRepresentation();
    }

    public Promise<String> getType() {
        if (this.type == null) {
            this.type = this.jsValue.getClassName().then(className -> {
                if (className.startsWith("a/")) {
                    String origClassName = className = className.substring(2);
                    int degree = 0;
                    while (className.endsWith("[]")) {
                        className = className.substring(0, className.length() - 2);
                        ++degree;
                    }
                    String javaClassName = this.debugInformation.getClassNameByJsName((String)className);
                    if (javaClassName != null) {
                        if (degree > 0) {
                            StringBuilder sb = new StringBuilder(javaClassName);
                            for (int i = 0; i < degree; ++i) {
                                sb.append("[]");
                            }
                            javaClassName = sb.toString();
                        }
                        className = javaClassName;
                    } else {
                        className = origClassName;
                    }
                }
                return className;
            });
        }
        return this.type;
    }

    public Promise<Map<String, Variable>> getProperties() {
        if (this.properties == null) {
            this.properties = this.jsValue.getProperties().thenAsync(jsVariables -> this.getType().thenAsync(className -> {
                if (!className.startsWith("@") && className.endsWith("[]") && jsVariables.containsKey("data")) {
                    return ((JavaScriptVariable)jsVariables.get("data")).getValue().getProperties().then(arrayData -> this.fillArray((Map<String, ? extends JavaScriptVariable>)arrayData));
                }
                HashMap<String, Variable> vars = new HashMap<String, Variable>();
                for (Map.Entry entry : jsVariables.entrySet()) {
                    JavaScriptVariable jsVar = (JavaScriptVariable)entry.getValue();
                    String name = this.debugger.mapField((String)className, (String)entry.getKey());
                    if (name == null) continue;
                    Value value = new Value(this.debugger, this.debugInformation, jsVar.getValue());
                    vars.put(name, new Variable(name, value));
                }
                return Promise.of(vars);
            }));
        }
        return this.properties;
    }

    private Map<String, Variable> fillArray(Map<String, ? extends JavaScriptVariable> jsVariables) {
        HashMap<String, Variable> vars = new HashMap<String, Variable>();
        for (Map.Entry<String, ? extends JavaScriptVariable> entry : jsVariables.entrySet()) {
            JavaScriptVariable jsVar = entry.getValue();
            if (!Value.isNumeric(entry.getKey())) continue;
            Value value = new Value(this.debugger, this.debugInformation, jsVar.getValue());
            vars.put(entry.getKey(), new Variable(entry.getKey(), value));
        }
        return vars;
    }

    public Promise<Boolean> hasInnerStructure() {
        return this.getType().then(value -> !value.equals("long") && this.jsValue.hasInnerStructure());
    }

    public Promise<String> getInstanceId() {
        return this.getType().then(value -> value.equals("long") ? null : this.jsValue.getInstanceId());
    }

    public JavaScriptValue getOriginalValue() {
        return this.jsValue;
    }
}

