/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.cli;

import com.antgroup.antchain.myjava.tooling.MyJavaToolLog;
import java.util.ArrayList;
import java.util.List;

public class AccumulatingMyJavaToolLog
implements MyJavaToolLog {
    private MyJavaToolLog delegatedLog;
    private List<Message> pendingMessages = new ArrayList<Message>();

    public AccumulatingMyJavaToolLog(MyJavaToolLog delegatedLog) {
        this.delegatedLog = delegatedLog;
    }

    public void flush() {
        for (Message message : this.pendingMessages) {
            switch (message.kind) {
                case INFO: {
                    if (message.throwable != null) {
                        this.delegatedLog.info(message.text, message.throwable);
                        break;
                    }
                    this.delegatedLog.info(message.text);
                    break;
                }
                case DEBUG: {
                    if (message.throwable != null) {
                        this.delegatedLog.debug(message.text, message.throwable);
                        break;
                    }
                    this.delegatedLog.debug(message.text);
                    break;
                }
                case WARNING: {
                    if (message.throwable != null) {
                        this.delegatedLog.warning(message.text, message.throwable);
                        break;
                    }
                    this.delegatedLog.warning(message.text);
                    break;
                }
                case ERROR: {
                    if (message.throwable != null) {
                        this.delegatedLog.error(message.text, message.throwable);
                        break;
                    }
                    this.delegatedLog.error(message.text);
                }
            }
        }
        this.pendingMessages.clear();
    }

    @Override
    public void info(String text) {
        this.pendingMessages.add(new Message(MessageKind.INFO, text, null));
    }

    @Override
    public void debug(String text) {
        this.pendingMessages.add(new Message(MessageKind.DEBUG, text, null));
    }

    @Override
    public void warning(String text) {
        this.pendingMessages.add(new Message(MessageKind.WARNING, text, null));
    }

    @Override
    public void error(String text) {
        this.pendingMessages.add(new Message(MessageKind.ERROR, text, null));
    }

    @Override
    public void info(String text, Throwable e) {
        this.pendingMessages.add(new Message(MessageKind.INFO, text, e));
    }

    @Override
    public void debug(String text, Throwable e) {
        this.pendingMessages.add(new Message(MessageKind.DEBUG, text, e));
    }

    @Override
    public void warning(String text, Throwable e) {
        this.pendingMessages.add(new Message(MessageKind.WARNING, text, e));
    }

    @Override
    public void error(String text, Throwable e) {
        this.pendingMessages.add(new Message(MessageKind.ERROR, text, e));
    }

    static enum MessageKind {
        INFO,
        DEBUG,
        WARNING,
        ERROR;

    }

    static class Message {
        MessageKind kind;
        String text;
        Throwable throwable;

        public Message(MessageKind kind, String text, Throwable throwable) {
            this.kind = kind;
            this.text = text;
            this.throwable = throwable;
        }
    }
}

