/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.zip;

import com.antgroup.antchain.myjava.classlib.java.util.zip.TInflater;
import com.antgroup.antchain.myjava.classlib.java.util.zip.TInflaterInputStream;
import com.antgroup.antchain.myjava.classlib.java.util.zip.TZipConstants;
import com.antgroup.antchain.myjava.classlib.java.util.zip.TZipEntry;
import com.antgroup.antchain.myjava.classlib.java.util.zip.TZipException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class TZipFile
implements TZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private final String fileName;
    private File fileToDeleteOnClose;
    private RandomAccessFile mRaf;
    private final TZipEntry.LittleEndianReader ler = new TZipEntry.LittleEndianReader();
    private final LinkedHashMap<String, TZipEntry> mEntries = new LinkedHashMap();

    public TZipFile(File file) throws TZipException, IOException {
        this(file, 1);
    }

    public TZipFile(File file, int mode) throws IOException {
        this.fileName = file.getPath();
        if (mode != 1 && mode != 5) {
            throw new IllegalArgumentException();
        }
        this.fileToDeleteOnClose = (mode & 4) != 0 ? file : null;
        this.mRaf = new RandomAccessFile(this.fileName, "r");
        this.readCentralDir();
    }

    public TZipFile(String name) throws IOException {
        this(new File(name), 1);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public void close() throws IOException {
        RandomAccessFile raf = this.mRaf;
        if (raf != null) {
            this.mRaf = null;
            raf.close();
            if (this.fileToDeleteOnClose != null) {
                new File(this.fileName).delete();
                this.fileToDeleteOnClose = null;
            }
        }
    }

    private void checkNotClosed() {
        if (this.mRaf == null) {
            throw new IllegalStateException();
        }
    }

    public Enumeration<? extends TZipEntry> entries() {
        this.checkNotClosed();
        final Iterator<TZipEntry> iterator = this.mEntries.values().iterator();
        return new Enumeration<TZipEntry>(){

            @Override
            public boolean hasMoreElements() {
                TZipFile.this.checkNotClosed();
                return iterator.hasNext();
            }

            @Override
            public TZipEntry nextElement() {
                TZipFile.this.checkNotClosed();
                return (TZipEntry)iterator.next();
            }
        };
    }

    public TZipEntry getEntry(String entryName) {
        this.checkNotClosed();
        if (entryName == null) {
            throw new NullPointerException();
        }
        TZipEntry ze = this.mEntries.get(entryName);
        if (ze == null) {
            ze = this.mEntries.get(entryName + "/");
        }
        return ze;
    }

    public InputStream getInputStream(TZipEntry entry) throws IOException {
        if ((entry = this.getEntry(entry.getName())) == null) {
            return null;
        }
        RandomAccessFile raf = this.mRaf;
        RAFStream rafstrm = new RAFStream(raf, entry.mLocalHeaderRelOffset + 28L);
        int localExtraLenOrWhatever = this.ler.readShortLE(rafstrm);
        rafstrm.skip(entry.nameLen + localExtraLenOrWhatever);
        rafstrm.mLength = rafstrm.mOffset + entry.compressedSize;
        if (entry.compressionMethod == 8) {
            int bufSize = Math.max(1024, (int)Math.min(entry.getSize(), 65535L));
            return new ZipInflaterInputStream(rafstrm, new TInflater(true), bufSize, entry);
        }
        return rafstrm;
    }

    public String getName() {
        return this.fileName;
    }

    public int size() {
        this.checkNotClosed();
        return this.mEntries.size();
    }

    private void readCentralDir() throws IOException {
        int numEntries;
        BufferedInputStream bin;
        RAFStream rafs;
        long scanOffset;
        block7: {
            long stopOffset;
            block6: {
                scanOffset = this.mRaf.length() - 22L;
                if (scanOffset < 0L) {
                    throw new TZipException();
                }
                stopOffset = scanOffset - 65536L;
                if (stopOffset < 0L) {
                    stopOffset = 0L;
                }
                do {
                    this.mRaf.seek(scanOffset);
                    if (TZipEntry.readIntLE(this.mRaf) == 101010256L) break block6;
                } while (--scanOffset >= stopOffset);
                throw new TZipException();
            }
            rafs = new RAFStream(this.mRaf, this.mRaf.getFilePointer());
            bin = new BufferedInputStream(rafs, 22);
            int diskNumber = this.ler.readShortLE(bin);
            int diskWithCentralDir = this.ler.readShortLE(bin);
            numEntries = this.ler.readShortLE(bin);
            int totalNumEntries = this.ler.readShortLE(bin);
            this.ler.readIntLE(bin);
            long centralDirOffset = this.ler.readIntLE(bin);
            this.ler.readShortLE(bin);
            if (numEntries != totalNumEntries || diskNumber != 0 || diskWithCentralDir != 0) {
                throw new TZipException();
            }
            scanOffset = centralDirOffset;
            stopOffset = scanOffset + 6L;
            do {
                this.mRaf.seek(scanOffset);
                if (TZipEntry.readIntLE(this.mRaf) == 33639248L) break block7;
            } while (++scanOffset <= stopOffset);
            throw new TZipException();
        }
        rafs = new RAFStream(this.mRaf, scanOffset);
        bin = new BufferedInputStream(rafs, 4096);
        for (int i = 0; i < numEntries; ++i) {
            TZipEntry newEntry = new TZipEntry(this.ler, bin);
            this.mEntries.put(newEntry.getName(), newEntry);
        }
    }

    static class ZipInflaterInputStream
    extends TInflaterInputStream {
        TZipEntry entry;
        long bytesRead;

        public ZipInflaterInputStream(InputStream is, TInflater inf, int bsize, TZipEntry entry) {
            super(is, inf, bsize);
            this.entry = entry;
        }

        @Override
        public int read(byte[] buffer, int off, int nbytes) throws IOException {
            int i = super.read(buffer, off, nbytes);
            if (i != -1) {
                this.bytesRead += (long)i;
            }
            return i;
        }

        @Override
        public int available() throws IOException {
            return super.available() == 0 ? 0 : (int)(this.entry.getSize() - this.bytesRead);
        }
    }

    static class RAFStream
    extends InputStream {
        RandomAccessFile mSharedRaf;
        long mOffset;
        long mLength;

        public RAFStream(RandomAccessFile raf, long pos) throws IOException {
            this.mSharedRaf = raf;
            this.mOffset = pos;
            this.mLength = raf.length();
        }

        @Override
        public int available() throws IOException {
            if (this.mLength > this.mOffset) {
                if (this.mLength - this.mOffset < Integer.MAX_VALUE) {
                    return (int)(this.mLength - this.mOffset);
                }
                return Integer.MAX_VALUE;
            }
            return 0;
        }

        @Override
        public int read() throws IOException {
            byte[] singleByteBuf = new byte[1];
            if (this.read(singleByteBuf, 0, 1) == 1) {
                return singleByteBuf[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int count;
            this.mSharedRaf.seek(this.mOffset);
            if ((long)len > this.mLength - this.mOffset) {
                len = (int)(this.mLength - this.mOffset);
            }
            if ((count = this.mSharedRaf.read(b, off, len)) > 0) {
                this.mOffset += (long)count;
                return count;
            }
            return -1;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n > this.mLength - this.mOffset) {
                n = this.mLength - this.mOffset;
            }
            this.mOffset += n;
            return n;
        }
    }
}

