/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.zip;

import com.antgroup.antchain.myjava.classlib.java.util.zip.TDataFormatException;
import com.jcraft.jzlib.GZIPException;
import com.jcraft.jzlib.Inflater;
import java.util.Arrays;

public class TInflater {
    private boolean finished;
    private boolean nowrap;
    int inLength;
    int inRead;
    private boolean needsDictionary;
    private Inflater impl;

    public TInflater() {
        this(false);
    }

    public TInflater(boolean noHeader) {
        this.nowrap = noHeader;
        try {
            this.impl = new Inflater(noHeader);
        }
        catch (GZIPException gZIPException) {
            // empty catch block
        }
    }

    public void end() {
        this.inRead = 0;
        this.inLength = 0;
        this.impl = null;
    }

    protected void finalize() {
        this.end();
    }

    public boolean finished() {
        return this.finished;
    }

    public int getAdler() {
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        return (int)this.impl.getAdler();
    }

    private native int getAdlerImpl(long var1);

    public long getBytesRead() {
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        return this.impl.getTotalIn();
    }

    public long getBytesWritten() {
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        return this.impl.getTotalOut();
    }

    public int getRemaining() {
        return this.inLength - this.inRead;
    }

    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    private native long getTotalInImpl(long var1);

    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    private native long getTotalOutImpl(long var1);

    public int inflate(byte[] buf) throws TDataFormatException {
        return this.inflate(buf, 0, buf.length);
    }

    public int inflate(byte[] buf, int off, int nbytes) throws TDataFormatException {
        if (off > buf.length || nbytes < 0 || off < 0 || buf.length - off < nbytes) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        if (this.needsInput()) {
            return 0;
        }
        long lastInSize = this.impl.total_in;
        long lastOutSize = this.impl.total_out;
        boolean neededDict = this.needsDictionary;
        this.needsDictionary = false;
        this.impl.setOutput(buf, off, nbytes);
        int errCode = this.impl.inflate(0);
        switch (errCode) {
            case 0: {
                break;
            }
            case 2: {
                this.needsDictionary = true;
                break;
            }
            case 1: {
                this.finished = true;
                break;
            }
            default: {
                throw new TDataFormatException("Error occurred: " + errCode);
            }
        }
        if (this.needsDictionary && neededDict) {
            throw new TDataFormatException();
        }
        this.inRead = (int)((long)this.inRead + (this.impl.total_in - lastInSize));
        return (int)(this.impl.total_out - lastOutSize);
    }

    public boolean needsDictionary() {
        return this.needsDictionary;
    }

    public boolean needsInput() {
        return this.inRead == this.inLength;
    }

    public void reset() {
        if (this.impl == null) {
            throw new NullPointerException();
        }
        this.finished = false;
        this.needsDictionary = false;
        this.inLength = 0;
        this.inRead = 0;
        this.impl.init(this.nowrap);
    }

    private native void resetImpl(long var1);

    public void setDictionary(byte[] buf) {
        this.setDictionary(buf, 0, buf.length);
    }

    public void setDictionary(byte[] buf, int off, int nbytes) {
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        if (off <= buf.length && nbytes >= 0 && off >= 0 && buf.length - off >= nbytes) {
            if (off > 0) {
                buf = Arrays.copyOfRange(buf, off, buf.length);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.impl.setDictionary(buf, nbytes);
    }

    public void setInput(byte[] buf) {
        this.setInput(buf, 0, buf.length);
    }

    public void setInput(byte[] buf, int off, int nbytes) {
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        if (off > buf.length || nbytes < 0 || off < 0 || buf.length - off < nbytes) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.inRead = 0;
        this.inLength = nbytes;
        this.impl.setInput(buf, off, nbytes, false);
    }
}

