/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.impl.tz.DateTimeZone;
import com.antgroup.antchain.myjava.classlib.impl.tz.DateTimeZoneProvider;
import com.antgroup.antchain.myjava.classlib.impl.tz.FixedDateTimeZone;
import com.antgroup.antchain.myjava.classlib.java.util.TDate;
import com.antgroup.antchain.myjava.classlib.java.util.TIANATimeZone;
import com.antgroup.antchain.myjava.classlib.java.util.TLocale;
import java.io.Serializable;
import java.util.Arrays;

public abstract class TTimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3581463369166924961L;
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static TTimeZone defaultTz;
    static final TTimeZone GMT;
    private String id;

    public TTimeZone() {
    }

    TTimeZone(String id) {
        this.id = id;
    }

    public Object clone() {
        try {
            TTimeZone zone = (TTimeZone)super.clone();
            return zone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static String[] getAvailableIDs() {
        return DateTimeZoneProvider.getIds();
    }

    public static String[] getAvailableIDs(int offset) {
        String[] all = DateTimeZoneProvider.getIds();
        String[] result = new String[all.length];
        int i = 0;
        for (String id : all) {
            DateTimeZone jodaTz = DateTimeZoneProvider.getTimeZone(id);
            if (jodaTz.getStandardOffset(System.currentTimeMillis()) != offset) continue;
            result[i++] = id;
        }
        return Arrays.copyOf(result, i);
    }

    public static TTimeZone getDefault() {
        if (defaultTz == null && (defaultTz = TTimeZone.detectTimezone()) == null) {
            defaultTz = GMT;
        }
        return (TTimeZone)defaultTz.clone();
    }

    private static TTimeZone detectTimezone() {
        DateTimeZone innerTz = DateTimeZoneProvider.detectTimezone();
        return innerTz != null ? new TIANATimeZone(innerTz) : null;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, TLocale.getDefault());
    }

    public final String getDisplayName(TLocale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean daylightTime, int style) {
        return this.getDisplayName(daylightTime, style, TLocale.getDefault());
    }

    public String getDisplayName(boolean daylightTime, int style, TLocale locale) {
        return this.id;
    }

    public String getID() {
        return this.id;
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public int getOffset(long time) {
        return this.inDaylightTime(new TDate(time)) ? this.getRawOffset() + this.getDSTSavings() : this.getRawOffset();
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public static TTimeZone getTimeZone(String name) {
        char sign;
        if (name.startsWith("GMT") && name.length() > 3 && ((sign = name.charAt(3)) == '+' || sign == '-')) {
            int[] position = new int[1];
            String formattedName = TTimeZone.formatTimeZoneName(name, 4);
            int hour = TTimeZone.parseNumber(formattedName, 4, position);
            if (hour < 0 || hour > 23) {
                return (TTimeZone)GMT.clone();
            }
            int index = position[0];
            if (index != -1) {
                int raw = hour * 3600000;
                if (index < formattedName.length() && formattedName.charAt(index) == ':') {
                    int minute = TTimeZone.parseNumber(formattedName, index + 1, position);
                    if (position[0] == -1 || minute < 0 || minute > 59) {
                        return (TTimeZone)GMT.clone();
                    }
                    raw += minute * 60000;
                } else if (index > 6) {
                    raw = hour * 60000;
                }
                if (sign == '-') {
                    raw = -raw;
                }
                return new TIANATimeZone(new FixedDateTimeZone(formattedName, raw, raw));
            }
        }
        if ("GMT".equals(name)) {
            return new TIANATimeZone(new FixedDateTimeZone("GMT", 0, 0));
        }
        DateTimeZone jodaZone = DateTimeZoneProvider.getTimeZone(name);
        if (jodaZone != null) {
            return new TIANATimeZone(jodaZone);
        }
        return (TTimeZone)GMT.clone();
    }

    private static String formatTimeZoneName(String name, int offset) {
        StringBuilder buf = new StringBuilder();
        int length = name.length();
        buf.append(name.substring(0, offset));
        for (int index = offset; index < length; ++index) {
            if (Character.digit(name.charAt(index), 10) != -1) {
                buf.append(name.charAt(index));
                if (length - (index + 1) != 2) continue;
                buf.append(':');
                continue;
            }
            if (name.charAt(index) != ':') continue;
            buf.append(':');
        }
        if (buf.toString().indexOf(":") == -1) {
            buf.append(':');
            buf.append("00");
        }
        if (buf.toString().indexOf(":") == 5) {
            buf.insert(4, '0');
        }
        return buf.toString();
    }

    public boolean hasSameRules(TTimeZone zone) {
        if (zone == null) {
            return false;
        }
        return this.getRawOffset() == zone.getRawOffset();
    }

    public abstract boolean inDaylightTime(TDate var1);

    private static int parseNumber(String string, int offset, int[] position) {
        int digit;
        int index;
        int length = string.length();
        int result = 0;
        for (index = offset; index < length && (digit = Character.digit(string.charAt(index), 10)) != -1; ++index) {
            result = result * 10 + digit;
        }
        position[0] = index == offset ? -1 : index;
        return result;
    }

    public static void setDefault(TTimeZone timezone) {
        defaultTz = timezone != null ? (TTimeZone)timezone.clone() : null;
    }

    public void setID(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.id = name;
    }

    public abstract void setRawOffset(int var1);

    public abstract boolean useDaylightTime();

    private static native String getCustomTimeZone(int[] var0, boolean[] var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != TTimeZone.class) {
            return false;
        }
        TTimeZone other = (TTimeZone)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    static {
        GMT = new TIANATimeZone(new FixedDateTimeZone("GMT", 0, 0));
    }
}

