/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.text;

import com.antgroup.antchain.myjava.classlib.java.text.TAnnotation;
import com.antgroup.antchain.myjava.classlib.java.text.TAttributedCharacterIterator;
import com.antgroup.antchain.myjava.classlib.java.util.TArrayList;
import com.antgroup.antchain.myjava.classlib.java.util.TArrays;
import com.antgroup.antchain.myjava.classlib.java.util.THashMap;
import com.antgroup.antchain.myjava.classlib.java.util.THashSet;
import com.antgroup.antchain.myjava.classlib.java.util.TIterator;
import com.antgroup.antchain.myjava.classlib.java.util.TList;
import com.antgroup.antchain.myjava.classlib.java.util.TListIterator;
import com.antgroup.antchain.myjava.classlib.java.util.TMap;
import com.antgroup.antchain.myjava.classlib.java.util.TSet;

public class TAttributedString {
    String text;
    TMap<TAttributedCharacterIterator.Attribute, TList<Range>> attributeMap;

    public TAttributedString(TAttributedCharacterIterator iterator) {
        if (iterator.getBeginIndex() > iterator.getEndIndex()) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = iterator.getBeginIndex(); i < iterator.getEndIndex(); ++i) {
            buffer.append(iterator.current());
            iterator.next();
        }
        this.text = buffer.toString();
        TSet<TAttributedCharacterIterator.Attribute> attributes = iterator.getAllAttributeKeys();
        if (attributes == null) {
            return;
        }
        this.attributeMap = new THashMap<TAttributedCharacterIterator.Attribute, TList<Range>>(attributes.size() * 4 / 3 + 1);
        TIterator it = attributes.iterator();
        while (it.hasNext()) {
            TAttributedCharacterIterator.Attribute attribute = (TAttributedCharacterIterator.Attribute)it.next();
            iterator.setIndex(0);
            while (iterator.current() != '\uffff') {
                int start = iterator.getRunStart(attribute);
                int limit = iterator.getRunLimit(attribute);
                Object value = iterator.getAttribute(attribute);
                if (value != null) {
                    this.addAttribute(attribute, value, start, limit);
                }
                iterator.setIndex(limit);
            }
        }
    }

    private TAttributedString(TAttributedCharacterIterator iterator, int start, int end, TSet<TAttributedCharacterIterator.Attribute> attributes) {
        if (start < iterator.getBeginIndex() || end > iterator.getEndIndex() || start > end) {
            throw new IllegalArgumentException();
        }
        if (attributes == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        iterator.setIndex(start);
        while (iterator.getIndex() < end) {
            buffer.append(iterator.current());
            iterator.next();
        }
        this.text = buffer.toString();
        this.attributeMap = new THashMap<TAttributedCharacterIterator.Attribute, TList<Range>>(attributes.size() * 4 / 3 + 1);
        TIterator it = attributes.iterator();
        while (it.hasNext()) {
            TAttributedCharacterIterator.Attribute attribute = (TAttributedCharacterIterator.Attribute)it.next();
            iterator.setIndex(start);
            while (iterator.getIndex() < end) {
                Object value = iterator.getAttribute(attribute);
                int runStart = iterator.getRunStart(attribute);
                int limit = iterator.getRunLimit(attribute);
                if (value instanceof TAnnotation && runStart >= start && limit <= end || value != null && !(value instanceof TAnnotation)) {
                    this.addAttribute(attribute, value, (runStart < start ? start : runStart) - start, (limit > end ? end : limit) - start);
                }
                iterator.setIndex(limit);
            }
        }
    }

    public TAttributedString(TAttributedCharacterIterator iterator, int start, int end) {
        this(iterator, start, end, iterator.getAllAttributeKeys());
    }

    public TAttributedString(TAttributedCharacterIterator iterator, int start, int end, TAttributedCharacterIterator.Attribute[] attributes) {
        this(iterator, start, end, new THashSet<TAttributedCharacterIterator.Attribute>(TArrays.asList(attributes)));
    }

    public TAttributedString(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.text = value;
        this.attributeMap = new THashMap<TAttributedCharacterIterator.Attribute, TList<Range>>(11);
    }

    public TAttributedString(String value, TMap<? extends TAttributedCharacterIterator.Attribute, ?> attributes) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.length() == 0 && !attributes.isEmpty()) {
            throw new IllegalArgumentException("Cannot add attributes to empty string");
        }
        this.text = value;
        this.attributeMap = new THashMap<TAttributedCharacterIterator.Attribute, TList<Range>>(attributes.size() * 4 / 3 + 1);
        TIterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            TMap.Entry entry = (TMap.Entry)it.next();
            TArrayList<Range> ranges = new TArrayList<Range>(1);
            ranges.add(new Range(0, this.text.length(), entry.getValue()));
            this.attributeMap.put((TAttributedCharacterIterator.Attribute)entry.getKey(), ranges);
        }
    }

    public void addAttribute(TAttributedCharacterIterator.Attribute attribute, Object value) {
        if (null == attribute) {
            throw new NullPointerException();
        }
        if (this.text.length() == 0) {
            throw new IllegalArgumentException();
        }
        TList<Range> ranges = this.attributeMap.get(attribute);
        if (ranges == null) {
            ranges = new TArrayList<Range>(1);
            this.attributeMap.put(attribute, ranges);
        } else {
            ranges.clear();
        }
        ranges.add(new Range(0, this.text.length(), value));
    }

    public void addAttribute(TAttributedCharacterIterator.Attribute attribute, Object value, int start, int end) {
        if (null == attribute) {
            throw new NullPointerException();
        }
        if (start < 0 || end > this.text.length() || start >= end) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            return;
        }
        TList<Range> ranges = this.attributeMap.get(attribute);
        if (ranges == null) {
            ranges = new TArrayList<Range>(1);
            ranges.add(new Range(start, end, value));
            this.attributeMap.put(attribute, ranges);
            return;
        }
        TListIterator<Range> it = ranges.listIterator();
        while (it.hasNext()) {
            Range range = (Range)it.next();
            if (end <= range.start) {
                it.previous();
                break;
            }
            if (start >= range.end && (start != range.end || !value.equals(range.value))) continue;
            Range r1 = null;
            it.remove();
            r1 = new Range(range.start, start, range.value);
            Range r3 = new Range(end, range.end, range.value);
            while (end > range.end && it.hasNext()) {
                range = (Range)it.next();
                if (end <= range.end) {
                    if (end <= range.start && (end != range.start || !value.equals(range.value))) continue;
                    it.remove();
                    r3 = new Range(end, range.end, range.value);
                    break;
                }
                it.remove();
            }
            if (value.equals(r1.value)) {
                if (value.equals(r3.value)) {
                    it.add(new Range(r1.start < start ? r1.start : start, r3.end > end ? r3.end : end, r1.value));
                } else {
                    it.add(new Range(r1.start < start ? r1.start : start, end, r1.value));
                    if (r3.start < r3.end) {
                        it.add(r3);
                    }
                }
            } else if (value.equals(r3.value)) {
                if (r1.start < r1.end) {
                    it.add(r1);
                }
                it.add(new Range(start, r3.end > end ? r3.end : end, r3.value));
            } else {
                if (r1.start < r1.end) {
                    it.add(r1);
                }
                it.add(new Range(start, end, value));
                if (r3.start < r3.end) {
                    it.add(r3);
                }
            }
            return;
        }
        it.add(new Range(start, end, value));
    }

    public void addAttributes(TMap<? extends TAttributedCharacterIterator.Attribute, ?> attributes, int start, int end) {
        TIterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            TMap.Entry entry = (TMap.Entry)it.next();
            this.addAttribute((TAttributedCharacterIterator.Attribute)entry.getKey(), entry.getValue(), start, end);
        }
    }

    public TAttributedCharacterIterator getIterator() {
        return new AttributedIterator(this);
    }

    public TAttributedCharacterIterator getIterator(TAttributedCharacterIterator.Attribute[] attributes) {
        return new AttributedIterator(this, attributes, 0, this.text.length());
    }

    public TAttributedCharacterIterator getIterator(TAttributedCharacterIterator.Attribute[] attributes, int start, int end) {
        return new AttributedIterator(this, attributes, start, end);
    }

    static class AttributedIterator
    implements TAttributedCharacterIterator {
        private int begin;
        private int end;
        private int offset;
        private TAttributedString attrString;
        private THashSet<TAttributedCharacterIterator.Attribute> attributesAllowed;

        AttributedIterator(TAttributedString attrString) {
            this.attrString = attrString;
            this.begin = 0;
            this.end = attrString.text.length();
            this.offset = 0;
        }

        AttributedIterator(TAttributedString attrString, TAttributedCharacterIterator.Attribute[] attributes, int begin, int end) {
            if (begin < 0 || end > attrString.text.length() || begin > end) {
                throw new IllegalArgumentException();
            }
            this.begin = begin;
            this.end = end;
            this.offset = begin;
            this.attrString = attrString;
            if (attributes != null) {
                THashSet<TAttributedCharacterIterator.Attribute> set = new THashSet<TAttributedCharacterIterator.Attribute>(attributes.length * 4 / 3 + 1);
                int i = attributes.length;
                while (--i >= 0) {
                    set.add(attributes[i]);
                }
                this.attributesAllowed = set;
            }
        }

        @Override
        public Object clone() {
            try {
                AttributedIterator clone = (AttributedIterator)super.clone();
                if (this.attributesAllowed != null) {
                    clone.attributesAllowed = (THashSet)this.attributesAllowed.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public char current() {
            if (this.offset == this.end) {
                return '\uffff';
            }
            return this.attrString.text.charAt(this.offset);
        }

        @Override
        public char first() {
            if (this.begin == this.end) {
                return '\uffff';
            }
            this.offset = this.begin;
            return this.attrString.text.charAt(this.offset);
        }

        @Override
        public int getBeginIndex() {
            return this.begin;
        }

        @Override
        public int getEndIndex() {
            return this.end;
        }

        @Override
        public int getIndex() {
            return this.offset;
        }

        private boolean inRange(Range range) {
            if (!(range.value instanceof TAnnotation)) {
                return true;
            }
            return range.start >= this.begin && range.start < this.end && range.end > this.begin && range.end <= this.end;
        }

        private boolean inRange(TList<Range> ranges) {
            TIterator it = ranges.iterator();
            while (it.hasNext()) {
                Range range = (Range)it.next();
                if (range.start >= this.begin && range.start < this.end) {
                    return !(range.value instanceof TAnnotation) || range.end > this.begin && range.end <= this.end;
                }
                if (range.end <= this.begin || range.end > this.end) continue;
                return !(range.value instanceof TAnnotation) || range.start >= this.begin && range.start < this.end;
            }
            return false;
        }

        @Override
        public TSet<TAttributedCharacterIterator.Attribute> getAllAttributeKeys() {
            if (this.begin == 0 && this.end == this.attrString.text.length() && this.attributesAllowed == null) {
                return this.attrString.attributeMap.keySet();
            }
            THashSet<TAttributedCharacterIterator.Attribute> result = new THashSet<TAttributedCharacterIterator.Attribute>(this.attrString.attributeMap.size() * 4 / 3 + 1);
            TIterator it = this.attrString.attributeMap.entrySet().iterator();
            while (it.hasNext()) {
                TList ranges;
                TMap.Entry entry = (TMap.Entry)it.next();
                if (this.attributesAllowed != null && !this.attributesAllowed.contains(entry.getKey()) || !this.inRange(ranges = (TList)entry.getValue())) continue;
                result.add((TAttributedCharacterIterator.Attribute)entry.getKey());
            }
            return result;
        }

        private Object currentValue(TList<Range> ranges) {
            TIterator it = ranges.iterator();
            while (it.hasNext()) {
                Range range = (Range)it.next();
                if (this.offset < range.start || this.offset >= range.end) continue;
                return this.inRange(range) ? range.value : null;
            }
            return null;
        }

        @Override
        public Object getAttribute(TAttributedCharacterIterator.Attribute attribute) {
            if (this.attributesAllowed != null && !this.attributesAllowed.contains(attribute)) {
                return null;
            }
            TArrayList ranges = (TArrayList)this.attrString.attributeMap.get(attribute);
            if (ranges == null) {
                return null;
            }
            return this.currentValue(ranges);
        }

        @Override
        public TMap<TAttributedCharacterIterator.Attribute, Object> getAttributes() {
            THashMap<TAttributedCharacterIterator.Attribute, Object> result = new THashMap<TAttributedCharacterIterator.Attribute, Object>(this.attrString.attributeMap.size() * 4 / 3 + 1);
            TIterator it = this.attrString.attributeMap.entrySet().iterator();
            while (it.hasNext()) {
                Object value;
                TMap.Entry entry = (TMap.Entry)it.next();
                if (this.attributesAllowed != null && !this.attributesAllowed.contains(entry.getKey()) || (value = this.currentValue((TList)entry.getValue())) == null) continue;
                result.put((TAttributedCharacterIterator.Attribute)entry.getKey(), value);
            }
            return result;
        }

        @Override
        public int getRunLimit() {
            return this.getRunLimit(this.getAllAttributeKeys());
        }

        private int runLimit(TList<Range> ranges) {
            int result = this.end;
            TListIterator<Range> it = ranges.listIterator(ranges.size());
            while (it.hasPrevious()) {
                Range range = it.previous();
                if (range.end <= this.begin) break;
                if (this.offset >= range.start && this.offset < range.end) {
                    return this.inRange(range) ? range.end : result;
                }
                if (this.offset >= range.end) break;
                result = range.start;
            }
            return result;
        }

        @Override
        public int getRunLimit(TAttributedCharacterIterator.Attribute attribute) {
            if (this.attributesAllowed != null && !this.attributesAllowed.contains(attribute)) {
                return this.end;
            }
            TArrayList ranges = (TArrayList)this.attrString.attributeMap.get(attribute);
            if (ranges == null) {
                return this.end;
            }
            return this.runLimit(ranges);
        }

        @Override
        public int getRunLimit(TSet<? extends TAttributedCharacterIterator.Attribute> attributes) {
            int limit = this.end;
            TIterator it = attributes.iterator();
            while (it.hasNext()) {
                TAttributedCharacterIterator.Attribute attribute = (TAttributedCharacterIterator.Attribute)it.next();
                int newLimit = this.getRunLimit(attribute);
                if (newLimit >= limit) continue;
                limit = newLimit;
            }
            return limit;
        }

        @Override
        public int getRunStart() {
            return this.getRunStart(this.getAllAttributeKeys());
        }

        private int runStart(TList<Range> ranges) {
            int result = this.begin;
            TIterator it = ranges.iterator();
            while (it.hasNext()) {
                Range range = (Range)it.next();
                if (range.start >= this.end) break;
                if (this.offset >= range.start && this.offset < range.end) {
                    return this.inRange(range) ? range.start : result;
                }
                if (this.offset < range.start) break;
                result = range.end;
            }
            return result;
        }

        @Override
        public int getRunStart(TAttributedCharacterIterator.Attribute attribute) {
            if (this.attributesAllowed != null && !this.attributesAllowed.contains(attribute)) {
                return this.begin;
            }
            TArrayList ranges = (TArrayList)this.attrString.attributeMap.get(attribute);
            if (ranges == null) {
                return this.begin;
            }
            return this.runStart(ranges);
        }

        @Override
        public int getRunStart(TSet<? extends TAttributedCharacterIterator.Attribute> attributes) {
            int start = this.begin;
            TIterator it = attributes.iterator();
            while (it.hasNext()) {
                TAttributedCharacterIterator.Attribute attribute = (TAttributedCharacterIterator.Attribute)it.next();
                int newStart = this.getRunStart(attribute);
                if (newStart <= start) continue;
                start = newStart;
            }
            return start;
        }

        @Override
        public char last() {
            if (this.begin == this.end) {
                return '\uffff';
            }
            this.offset = this.end - 1;
            return this.attrString.text.charAt(this.offset);
        }

        @Override
        public char next() {
            if (this.offset >= this.end - 1) {
                this.offset = this.end;
                return '\uffff';
            }
            return this.attrString.text.charAt(++this.offset);
        }

        @Override
        public char previous() {
            if (this.offset == this.begin) {
                return '\uffff';
            }
            return this.attrString.text.charAt(--this.offset);
        }

        @Override
        public char setIndex(int location) {
            if (location < this.begin || location > this.end) {
                throw new IllegalArgumentException();
            }
            this.offset = location;
            if (this.offset == this.end) {
                return '\uffff';
            }
            return this.attrString.text.charAt(this.offset);
        }
    }

    static class Range {
        int start;
        int end;
        Object value;

        Range(int s, int e, Object v) {
            this.start = s;
            this.end = e;
            this.value = v;
        }
    }
}

