/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio.charset;

import com.antgroup.antchain.myjava.classlib.java.nio.TByteBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.TCharBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCharacterCodingException;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCharset;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCoderMalfunctionError;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCoderResult;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCodingErrorAction;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import java.util.Arrays;

@NoMetadata
public abstract class TCharsetDecoder {
    private static final int INIT = 0;
    private static final int IN_PROGRESS = 1;
    private static final int END = 2;
    private static final int FLUSH = 3;
    private TCharset charset;
    private float averageCharsPerByte;
    private float maxCharsPerByte;
    private String replacement = "\ufffd";
    private TCodingErrorAction malformedAction = TCodingErrorAction.REPORT;
    private TCodingErrorAction unmappableAction = TCodingErrorAction.REPORT;
    private int state;

    protected TCharsetDecoder(TCharset cs, float averageCharsPerByte, float maxCharsPerByte) {
        if (averageCharsPerByte <= 0.0f) {
            throw new IllegalArgumentException("averageCharsPerByte must be positive. Actual value is " + averageCharsPerByte);
        }
        if (maxCharsPerByte <= 0.0f) {
            throw new IllegalArgumentException("maxCharsPerByte must be positive. Actual value is " + maxCharsPerByte);
        }
        this.charset = cs;
        this.averageCharsPerByte = averageCharsPerByte;
        this.maxCharsPerByte = maxCharsPerByte;
    }

    public final TCharset charset() {
        return this.charset;
    }

    public final String replacement() {
        return this.replacement;
    }

    public final TCharsetDecoder replaceWith(String newReplacement) {
        if (newReplacement == null || newReplacement.isEmpty()) {
            throw new IllegalArgumentException("New replacement is null or empty");
        }
        this.replacement = newReplacement;
        this.implReplaceWith(newReplacement);
        return this;
    }

    protected void implReplaceWith(String newReplacement) {
    }

    public TCodingErrorAction malformedInputAction() {
        return this.malformedAction;
    }

    public final TCharsetDecoder onMalformedInput(TCodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("newAction must be non-null");
        }
        this.malformedAction = newAction;
        this.implOnMalformedInput(newAction);
        return this;
    }

    protected void implOnMalformedInput(TCodingErrorAction newAction) {
    }

    public TCodingErrorAction unmappableCharacterAction() {
        return this.unmappableAction;
    }

    public final TCharsetDecoder onUnmappableCharacter(TCodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("newAction must be non-null");
        }
        this.unmappableAction = newAction;
        this.implOnUnmappableCharacter(newAction);
        return this;
    }

    protected void implOnUnmappableCharacter(TCodingErrorAction newAction) {
    }

    public final float averageCharsPerByte() {
        return this.averageCharsPerByte;
    }

    public final float maxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public final TCoderResult decode(TByteBuffer in, TCharBuffer out, boolean endOfInput) {
        if (this.state == 2 && !endOfInput || this.state == 3) {
            throw new IllegalStateException();
        }
        this.state = !endOfInput ? 1 : 2;
        while (true) {
            TCoderResult result;
            try {
                result = this.decodeLoop(in, out);
            }
            catch (RuntimeException e) {
                throw new TCoderMalfunctionError(e);
            }
            if (result.isOverflow()) {
                return result;
            }
            if (result.isUnderflow()) {
                if (endOfInput && in.hasRemaining()) {
                    if (this.malformedAction == TCodingErrorAction.REPORT) {
                        return TCoderResult.malformedForLength(in.remaining());
                    }
                    if (out.remaining() > this.replacement.length()) {
                        in.position(in.position() + in.remaining());
                        if (this.malformedAction == TCodingErrorAction.REPLACE) {
                            out.put(this.replacement);
                        }
                    } else {
                        return TCoderResult.OVERFLOW;
                    }
                }
                return result;
            }
            if (result.isMalformed()) {
                if (this.malformedAction == TCodingErrorAction.REPORT) {
                    return result;
                }
                if (this.malformedAction == TCodingErrorAction.REPLACE) {
                    if (out.remaining() < this.replacement.length()) {
                        return TCoderResult.OVERFLOW;
                    }
                    out.put(this.replacement);
                }
                in.position(in.position() + result.length());
                continue;
            }
            if (!result.isUnmappable()) continue;
            if (this.unmappableAction == TCodingErrorAction.REPORT) {
                return result;
            }
            if (this.unmappableAction == TCodingErrorAction.REPLACE) {
                if (out.remaining() < this.replacement.length()) {
                    return TCoderResult.OVERFLOW;
                }
                out.put(this.replacement);
            }
            in.position(in.position() + result.length());
        }
    }

    public final TCoderResult flush(TCharBuffer out) {
        if (this.state != 3 && this.state != 2) {
            throw new IllegalStateException();
        }
        this.state = 3;
        return this.implFlush(out);
    }

    public final TCharsetDecoder reset() {
        this.state = 0;
        this.implReset();
        return this;
    }

    public final TCharBuffer decode(TByteBuffer in) throws TCharacterCodingException {
        TCoderResult result;
        if (this.state != 0 && this.state != 3) {
            throw new IllegalStateException();
        }
        if (in.remaining() == 0) {
            return TCharBuffer.allocate(0);
        }
        if (this.state != 0) {
            this.reset();
        }
        TCharBuffer out = TCharBuffer.allocate(Math.max(8, (int)((float)in.remaining() * this.averageCharsPerByte)));
        while (!(result = this.decode(in, out, false)).isUnderflow()) {
            if (result.isOverflow()) {
                out = this.expand(out);
            }
            if (!result.isError()) continue;
            result.throwException();
        }
        result = this.decode(in, out, true);
        if (result.isError()) {
            result.throwException();
        }
        while (!(result = this.flush(out)).isUnderflow()) {
            out = this.expand(out);
        }
        out.flip();
        return out;
    }

    public boolean isAutoDetecting() {
        return false;
    }

    public boolean isCharsetDetected() {
        throw new UnsupportedOperationException();
    }

    public TCharset detectedCharset() {
        throw new UnsupportedOperationException();
    }

    private TCharBuffer expand(TCharBuffer buffer) {
        char[] array = buffer.array();
        array = Arrays.copyOf(array, Math.max(8, array.length * 2));
        TCharBuffer result = TCharBuffer.wrap(array);
        result.position(buffer.position());
        return result;
    }

    protected abstract TCoderResult decodeLoop(TByteBuffer var1, TCharBuffer var2);

    protected TCoderResult implFlush(TCharBuffer out) {
        return TCoderResult.UNDERFLOW;
    }

    protected void implReset() {
    }
}

