/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio;

import com.antgroup.antchain.myjava.classlib.java.nio.TBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.TBufferOverflowException;
import com.antgroup.antchain.myjava.classlib.java.nio.TBufferUnderflowException;
import com.antgroup.antchain.myjava.classlib.java.nio.TByteOrder;
import com.antgroup.antchain.myjava.classlib.java.nio.TLongBufferOverArray;
import com.antgroup.antchain.myjava.classlib.java.nio.TReadOnlyBufferException;

public abstract class TLongBuffer
extends TBuffer
implements Comparable<TLongBuffer> {
    TLongBuffer(int capacity, int position, int limit) {
        super(capacity);
        this.position = position;
        this.limit = limit;
    }

    public static TLongBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        return new TLongBufferOverArray(capacity);
    }

    public static TLongBuffer wrap(long[] array, int offset, int length) {
        return new TLongBufferOverArray(0, array.length, array, offset, offset + length, false);
    }

    public static TLongBuffer wrap(long[] array) {
        return TLongBuffer.wrap(array, 0, array.length);
    }

    public abstract TLongBuffer slice();

    public abstract TLongBuffer duplicate();

    public abstract TLongBuffer asReadOnlyBuffer();

    public abstract long get();

    public abstract TLongBuffer put(long var1);

    public abstract long get(int var1);

    public abstract TLongBuffer put(int var1, long var2);

    abstract long getElement(int var1);

    abstract void putElement(int var1, long var2);

    public TLongBuffer get(long[] dst, int offset, int length) {
        if (offset < 0 || offset >= dst.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + dst.length + ")");
        }
        if (offset + length > dst.length) {
            throw new IndexOutOfBoundsException("The last long in dst " + (offset + length) + " is outside of array of size " + dst.length);
        }
        if (this.remaining() < length) {
            throw new TBufferUnderflowException();
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position;
        for (int i = 0; i < length; ++i) {
            dst[offset++] = this.getElement(pos++);
        }
        this.position += length;
        return this;
    }

    public TLongBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TLongBuffer put(TLongBuffer src) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < src.remaining()) {
            throw new TBufferOverflowException();
        }
        int length = src.remaining();
        int pos = this.position;
        int offset = src.position;
        for (int i = 0; i < length; ++i) {
            this.putElement(pos++, src.getElement(offset++));
        }
        this.position += length;
        return this;
    }

    public TLongBuffer put(long[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (offset < 0 || offset >= src.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + src.length + ")");
        }
        if (offset + length > src.length) {
            throw new IndexOutOfBoundsException("The last long in src " + (offset + length) + " is outside of array of size " + src.length);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position;
        for (int i = 0; i < length; ++i) {
            this.putElement(pos++, src[offset++]);
        }
        this.position += length;
        return this;
    }

    public final TLongBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public final boolean hasArray() {
        return this.isArrayPresent();
    }

    public final long[] array() {
        return this.getArray();
    }

    @Override
    public final int arrayOffset() {
        return this.getArrayOffset();
    }

    abstract boolean isArrayPresent();

    abstract long[] getArray();

    abstract int getArrayOffset();

    public abstract TLongBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return "[LongBuffer position=" + this.position + ", limit=" + this.limit + ", capacity=" + this.capacity + ", mark " + (this.mark >= 0 ? " at " + this.mark : " is not set") + "]";
    }

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position;
        for (int i = this.position; i < this.limit; ++i) {
            long elem = this.getElement(pos++);
            hashCode = 31 * hashCode + (int)elem + (int)(elem >>> 32);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TLongBuffer)) {
            return false;
        }
        TLongBuffer other = (TLongBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            if (this.getElement(a++) == other.getElement(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TLongBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Long.compare(this.getElement(a++), other.getElement(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    public abstract TByteOrder order();

    @Override
    public final TLongBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final TLongBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final TLongBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final TLongBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final TLongBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public TLongBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public TLongBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }
}

