/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.math;

import com.antgroup.antchain.myjava.classlib.java.math.TBigInteger;
import com.antgroup.antchain.myjava.classlib.java.math.TBitLevel;
import com.antgroup.antchain.myjava.classlib.java.math.TElementary;
import com.antgroup.antchain.myjava.classlib.java.math.TMultiplication;
import com.antgroup.antchain.myjava.interop.NoMetadata;

@NoMetadata
class TDivision {
    private TDivision() {
    }

    static int[] divide(int[] quot, int quotLength, int[] a, int aLength, int[] b, int bLength) {
        int[] normA = new int[aLength + 1];
        int[] normB = new int[bLength + 1];
        int normBLength = bLength;
        int divisorShift = Integer.numberOfLeadingZeros(b[bLength - 1]);
        if (divisorShift != 0) {
            TBitLevel.shiftLeft(normB, b, 0, divisorShift);
            TBitLevel.shiftLeft(normA, a, 0, divisorShift);
        } else {
            System.arraycopy(a, 0, normA, 0, aLength);
            System.arraycopy(b, 0, normB, 0, bLength);
        }
        int firstDivisorDigit = normB[normBLength - 1];
        int j = aLength;
        for (int i = quotLength - 1; i >= 0; --i) {
            int borrow;
            int guessDigit = 0;
            if (normA[j] == firstDivisorDigit) {
                guessDigit = -1;
            } else {
                long product = (((long)normA[j] & 0xFFFFFFFFL) << 32) + ((long)normA[j - 1] & 0xFFFFFFFFL);
                long res = TDivision.divideLongByInt(product, firstDivisorDigit);
                guessDigit = (int)res;
                int rem = (int)(res >> 32);
                if (guessDigit != 0) {
                    long leftHand = 0L;
                    long rightHand = 0L;
                    boolean rOverflowed = false;
                    ++guessDigit;
                    do {
                        --guessDigit;
                        if (rOverflowed) break;
                        leftHand = ((long)guessDigit & 0xFFFFFFFFL) * ((long)normB[normBLength - 2] & 0xFFFFFFFFL);
                        rightHand = ((long)rem << 32) + ((long)normA[j - 2] & 0xFFFFFFFFL);
                        long longR = ((long)rem & 0xFFFFFFFFL) + ((long)firstDivisorDigit & 0xFFFFFFFFL);
                        if (Integer.numberOfLeadingZeros((int)(longR >>> 32)) < 32) {
                            rOverflowed = true;
                            continue;
                        }
                        rem = (int)longR;
                    } while ((leftHand ^ Long.MIN_VALUE) > (rightHand ^ Long.MIN_VALUE));
                }
            }
            if (guessDigit != 0 && (borrow = TDivision.multiplyAndSubtract(normA, j - normBLength, normB, normBLength, guessDigit)) != 0) {
                --guessDigit;
                long carry = 0L;
                for (int k = 0; k < normBLength; ++k) {
                    normA[j - normBLength + k] = (int)(carry += ((long)normA[j - normBLength + k] & 0xFFFFFFFFL) + ((long)normB[k] & 0xFFFFFFFFL));
                    carry >>>= 32;
                }
            }
            if (quot != null) {
                quot[i] = guessDigit;
            }
            --j;
        }
        if (divisorShift != 0) {
            TBitLevel.shiftRight(normB, normBLength, normA, 0, divisorShift);
            return normB;
        }
        System.arraycopy(normA, 0, normB, 0, bLength);
        return normA;
    }

    static int divideArrayByInt(int[] dest, int[] src, int srcLength, int divisor) {
        long rem = 0L;
        long bLong = (long)divisor & 0xFFFFFFFFL;
        for (int i = srcLength - 1; i >= 0; --i) {
            long quot;
            long temp = rem << 32 | (long)src[i] & 0xFFFFFFFFL;
            if (temp >= 0L) {
                quot = temp / bLong;
                rem = temp % bLong;
            } else {
                long aPos = temp >>> 1;
                long bPos = divisor >>> 1;
                quot = aPos / bPos;
                rem = aPos % bPos;
                rem = (rem << 1) + (temp & 1L);
                if ((divisor & 1) != 0) {
                    if (quot <= rem) {
                        rem -= quot;
                    } else if (quot - rem <= bLong) {
                        rem += bLong - quot;
                        --quot;
                    } else {
                        rem += (bLong << 1) - quot;
                        quot -= 2L;
                    }
                }
            }
            dest[i] = (int)(quot & 0xFFFFFFFFL);
        }
        return (int)rem;
    }

    static int remainderArrayByInt(int[] src, int srcLength, int divisor) {
        long result = 0L;
        for (int i = srcLength - 1; i >= 0; --i) {
            long temp = (result << 32) + ((long)src[i] & 0xFFFFFFFFL);
            long res = TDivision.divideLongByInt(temp, divisor);
            result = (int)(res >> 32);
        }
        return (int)result;
    }

    static int remainder(TBigInteger dividend, int divisor) {
        return TDivision.remainderArrayByInt(dividend.digits, dividend.numberLength, divisor);
    }

    static long divideLongByInt(long a, int b) {
        long rem;
        long quot;
        long bLong = (long)b & 0xFFFFFFFFL;
        if (a >= 0L) {
            quot = a / bLong;
            rem = a % bLong;
        } else {
            long aPos = a >>> 1;
            long bPos = b >>> 1;
            quot = aPos / bPos;
            rem = aPos % bPos;
            rem = (rem << 1) + (a & 1L);
            if ((b & 1) != 0) {
                if (quot <= rem) {
                    rem -= quot;
                } else if (quot - rem <= bLong) {
                    rem += bLong - quot;
                    --quot;
                } else {
                    rem += (bLong << 1) - quot;
                    quot -= 2L;
                }
            }
        }
        return rem << 32 | quot & 0xFFFFFFFFL;
    }

    static TBigInteger[] divideAndRemainderByInteger(TBigInteger val, int divisor, int divisorSign) {
        int[] valDigits = val.digits;
        int valLen = val.numberLength;
        int valSign = val.sign;
        if (valLen == 1) {
            long a = (long)valDigits[0] & 0xFFFFFFFFL;
            long b = (long)divisor & 0xFFFFFFFFL;
            long quo = a / b;
            long rem = a % b;
            if (valSign != divisorSign) {
                quo = -quo;
            }
            if (valSign < 0) {
                rem = -rem;
            }
            return new TBigInteger[]{TBigInteger.valueOf(quo), TBigInteger.valueOf(rem)};
        }
        int quotientLength = valLen;
        int quotientSign = valSign == divisorSign ? 1 : -1;
        int[] quotientDigits = new int[quotientLength];
        int[] remainderDigits = new int[]{TDivision.divideArrayByInt(quotientDigits, valDigits, valLen, divisor)};
        TBigInteger result0 = new TBigInteger(quotientSign, quotientLength, quotientDigits);
        TBigInteger result1 = new TBigInteger(valSign, 1, remainderDigits);
        result0.cutOffLeadingZeroes();
        result1.cutOffLeadingZeroes();
        return new TBigInteger[]{result0, result1};
    }

    static int multiplyAndSubtract(int[] a, int start, int[] b, int bLen, int c) {
        long carry0 = 0L;
        long carry1 = 0L;
        for (int i = 0; i < bLen; ++i) {
            carry0 = TMultiplication.unsignedMultAddAdd(b[i], c, (int)carry0, 0);
            carry1 = ((long)a[start + i] & 0xFFFFFFFFL) - (carry0 & 0xFFFFFFFFL) + carry1;
            a[start + i] = (int)carry1;
            carry1 >>= 32;
            carry0 >>>= 32;
        }
        carry1 = ((long)a[start + bLen] & 0xFFFFFFFFL) - carry0 + carry1;
        a[start + bLen] = (int)carry1;
        return (int)(carry1 >> 32);
    }

    static TBigInteger gcdBinary(TBigInteger op1, TBigInteger op2) {
        TBigInteger swap;
        int lsb1 = op1.getLowestSetBit();
        int lsb2 = op2.getLowestSetBit();
        int pow2Count = Math.min(lsb1, lsb2);
        TBitLevel.inplaceShiftRight(op1, lsb1);
        TBitLevel.inplaceShiftRight(op2, lsb2);
        if (op1.compareTo(op2) == 1) {
            swap = op1;
            op1 = op2;
            op2 = swap;
        }
        do {
            if (op2.numberLength == 1 || op2.numberLength == 2 && op2.digits[1] > 0) {
                op2 = TBigInteger.valueOf(TDivision.gcdBinary(op1.longValue(), op2.longValue()));
                break;
            }
            if ((double)op2.numberLength > (double)op1.numberLength * 1.2) {
                if ((op2 = op2.remainder(op1)).signum() != 0) {
                    TBitLevel.inplaceShiftRight(op2, op2.getLowestSetBit());
                }
            } else {
                do {
                    TElementary.inplaceSubtract(op2, op1);
                    TBitLevel.inplaceShiftRight(op2, op2.getLowestSetBit());
                } while (op2.compareTo(op1) >= 0);
            }
            swap = op2;
            op2 = op1;
            op1 = swap;
        } while (op1.sign != 0);
        return op2.shiftLeft(pow2Count);
    }

    static long gcdBinary(long op1, long op2) {
        int lsb1 = Long.numberOfTrailingZeros(op1);
        int lsb2 = Long.numberOfTrailingZeros(op2);
        int pow2Count = Math.min(lsb1, lsb2);
        if (lsb1 != 0) {
            op1 >>>= lsb1;
        }
        if (lsb2 != 0) {
            op2 >>>= lsb2;
        }
        do {
            if (op1 >= op2) {
                op1 -= op2;
                op1 >>>= Long.numberOfTrailingZeros(op1);
                continue;
            }
            op2 -= op1;
            op2 >>>= Long.numberOfTrailingZeros(op2);
        } while (op1 != 0L);
        return op2 << pow2Count;
    }

    static TBigInteger modInverseMontgomery(TBigInteger a, TBigInteger p) {
        int lsbv;
        if (a.sign == 0) {
            throw new ArithmeticException("BigInteger not invertible");
        }
        if (!p.testBit(0)) {
            return TDivision.modInverseHars(a, p);
        }
        int m = p.numberLength * 32;
        TBigInteger u = p.copy();
        TBigInteger v = a.copy();
        int max = Math.max(v.numberLength, u.numberLength);
        TBigInteger r = new TBigInteger(1, 1, new int[max + 1]);
        TBigInteger s = new TBigInteger(1, 1, new int[max + 1]);
        s.digits[0] = 1;
        int k = 0;
        int lsbu = u.getLowestSetBit();
        if (lsbu > (lsbv = v.getLowestSetBit())) {
            TBitLevel.inplaceShiftRight(u, lsbu);
            TBitLevel.inplaceShiftRight(v, lsbv);
            TBitLevel.inplaceShiftLeft(r, lsbv);
            k += lsbu - lsbv;
        } else {
            TBitLevel.inplaceShiftRight(u, lsbu);
            TBitLevel.inplaceShiftRight(v, lsbv);
            TBitLevel.inplaceShiftLeft(s, lsbu);
            k += lsbv - lsbu;
        }
        r.sign = 1;
        block0: while (v.signum() > 0) {
            int toShift;
            while (u.compareTo(v) > 0) {
                TElementary.inplaceSubtract(u, v);
                toShift = u.getLowestSetBit();
                TBitLevel.inplaceShiftRight(u, toShift);
                TElementary.inplaceAdd(r, s);
                TBitLevel.inplaceShiftLeft(s, toShift);
                k += toShift;
            }
            while (u.compareTo(v) <= 0) {
                TElementary.inplaceSubtract(v, u);
                if (v.signum() == 0) continue block0;
                toShift = v.getLowestSetBit();
                TBitLevel.inplaceShiftRight(v, toShift);
                TElementary.inplaceAdd(s, r);
                TBitLevel.inplaceShiftLeft(r, toShift);
                k += toShift;
            }
        }
        if (!u.isOne()) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        if (r.compareTo(p) >= 0) {
            TElementary.inplaceSubtract(r, p);
        }
        r = p.subtract(r);
        int n1 = TDivision.calcN(p);
        if (k > m) {
            r = TDivision.monPro(r, TBigInteger.ONE, p, n1);
            k -= m;
        }
        r = TDivision.monPro(r, TBigInteger.getPowerOfTwo(m - k), p, n1);
        return r;
    }

    private static int calcN(TBigInteger a) {
        long m0 = (long)a.digits[0] & 0xFFFFFFFFL;
        long n2 = 1L;
        long powerOfTwo = 2L;
        do {
            if ((m0 * n2 & powerOfTwo) == 0L) continue;
            n2 |= powerOfTwo;
        } while ((powerOfTwo <<= 1) < 0x100000000L);
        n2 = -n2;
        return (int)(n2 & 0xFFFFFFFFL);
    }

    static TBigInteger squareAndMultiply(TBigInteger x2, TBigInteger a2, TBigInteger exponent, TBigInteger modulus, int n2) {
        TBigInteger res = x2;
        for (int i = exponent.bitLength() - 1; i >= 0; --i) {
            res = TDivision.monPro(res, res, modulus, n2);
            if (!TBitLevel.testBit(exponent, i)) continue;
            res = TDivision.monPro(res, a2, modulus, n2);
        }
        return res;
    }

    static TBigInteger modInverseHars(TBigInteger a, TBigInteger m) {
        TBigInteger s;
        TBigInteger r;
        TBigInteger v;
        TBigInteger u;
        if (a.compareTo(m) == -1) {
            u = m;
            v = a;
            r = TBigInteger.ZERO;
            s = TBigInteger.ONE;
        } else {
            v = m;
            u = a;
            s = TBigInteger.ZERO;
            r = TBigInteger.ONE;
        }
        int uLen = u.bitLength();
        int vLen = v.bitLength();
        int f = uLen - vLen;
        while (vLen > 1) {
            if (u.sign == v.sign) {
                u = u.subtract(v.shiftLeft(f));
                r = r.subtract(s.shiftLeft(f));
            } else {
                u = u.add(v.shiftLeft(f));
                r = r.add(s.shiftLeft(f));
            }
            if ((f = (uLen = u.abs().bitLength()) - (vLen = v.abs().bitLength())) >= 0) continue;
            TBigInteger temp = u;
            u = v;
            v = temp;
            temp = r;
            r = s;
            s = temp;
            f = -f;
            vLen = uLen;
        }
        if (v.sign == 0) {
            return TBigInteger.ZERO;
        }
        if (v.sign < 0) {
            s = s.negate();
        }
        if (s.compareTo(m) == 1) {
            return s.subtract(m);
        }
        if (s.sign < 0) {
            return s.add(m);
        }
        return s;
    }

    static TBigInteger slidingWindow(TBigInteger x2, TBigInteger a2, TBigInteger exponent, TBigInteger modulus, int n2) {
        int i;
        TBigInteger[] pows = new TBigInteger[8];
        TBigInteger res = x2;
        pows[0] = a2;
        TBigInteger x3 = TDivision.monPro(a2, a2, modulus, n2);
        for (i = 1; i <= 7; ++i) {
            pows[i] = TDivision.monPro(pows[i - 1], x3, modulus, n2);
        }
        for (i = exponent.bitLength() - 1; i >= 0; --i) {
            if (TBitLevel.testBit(exponent, i)) {
                int j;
                int lowexp = 1;
                int acc3 = i;
                for (j = Math.max(i - 3, 0); j <= i - 1; ++j) {
                    if (!TBitLevel.testBit(exponent, j)) continue;
                    if (j < acc3) {
                        acc3 = j;
                        lowexp = lowexp << i - j ^ 1;
                        continue;
                    }
                    lowexp ^= 1 << j - acc3;
                }
                for (j = acc3; j <= i; ++j) {
                    res = TDivision.monPro(res, res, modulus, n2);
                }
                res = TDivision.monPro(pows[lowexp - 1 >> 1], res, modulus, n2);
                i = acc3;
                continue;
            }
            res = TDivision.monPro(res, res, modulus, n2);
        }
        return res;
    }

    static TBigInteger oddModPow(TBigInteger base, TBigInteger exponent, TBigInteger modulus) {
        int k = modulus.numberLength << 5;
        TBigInteger a2 = base.shiftLeft(k).mod(modulus);
        TBigInteger x2 = TBigInteger.getPowerOfTwo(k).mod(modulus);
        int n2 = TDivision.calcN(modulus);
        TBigInteger res = modulus.numberLength == 1 ? TDivision.squareAndMultiply(x2, a2, exponent, modulus, n2) : TDivision.slidingWindow(x2, a2, exponent, modulus, n2);
        return TDivision.monPro(res, TBigInteger.ONE, modulus, n2);
    }

    static TBigInteger evenModPow(TBigInteger base, TBigInteger exponent, TBigInteger modulus) {
        int j = modulus.getLowestSetBit();
        TBigInteger q = modulus.shiftRight(j);
        TBigInteger x1 = TDivision.oddModPow(base, exponent, q);
        TBigInteger x2 = TDivision.pow2ModPow(base, exponent, j);
        TBigInteger qInv = TDivision.modPow2Inverse(q, j);
        TBigInteger y = x2.subtract(x1).multiply(qInv);
        TDivision.inplaceModPow2(y, j);
        if (y.sign < 0) {
            y = y.add(TBigInteger.getPowerOfTwo(j));
        }
        return x1.add(q.multiply(y));
    }

    static TBigInteger pow2ModPow(TBigInteger base, TBigInteger exponent, int j) {
        TBigInteger res = TBigInteger.ONE;
        TBigInteger e = exponent.copy();
        TBigInteger baseMod2toN = base.copy();
        if (base.testBit(0)) {
            TDivision.inplaceModPow2(e, j - 1);
        }
        TDivision.inplaceModPow2(baseMod2toN, j);
        for (int i = e.bitLength() - 1; i >= 0; --i) {
            TBigInteger res2 = res.copy();
            TDivision.inplaceModPow2(res2, j);
            res = res.multiply(res2);
            if (!TBitLevel.testBit(e, i)) continue;
            res = res.multiply(baseMod2toN);
            TDivision.inplaceModPow2(res, j);
        }
        TDivision.inplaceModPow2(res, j);
        return res;
    }

    private static void monReduction(int[] res, TBigInteger modulus, int n2) {
        int[] modulusDigits = modulus.digits;
        int modulusLen = modulus.numberLength;
        long outerCarry = 0L;
        for (int i = 0; i < modulusLen; ++i) {
            long innnerCarry = 0L;
            int m = (int)TMultiplication.unsignedMultAddAdd(res[i], n2, 0, 0);
            for (int j = 0; j < modulusLen; ++j) {
                innnerCarry = TMultiplication.unsignedMultAddAdd(m, modulusDigits[j], res[i + j], (int)innnerCarry);
                res[i + j] = (int)innnerCarry;
                innnerCarry >>>= 32;
            }
            res[i + modulusLen] = (int)(outerCarry += ((long)res[i + modulusLen] & 0xFFFFFFFFL) + innnerCarry);
            outerCarry >>>= 32;
        }
        res[modulusLen << 1] = (int)outerCarry;
        for (int j = 0; j < modulusLen + 1; ++j) {
            res[j] = res[j + modulusLen];
        }
    }

    static TBigInteger monPro(TBigInteger a, TBigInteger b, TBigInteger modulus, int n2) {
        int modulusLen = modulus.numberLength;
        int[] res = new int[(modulusLen << 1) + 1];
        TMultiplication.multArraysPAP(a.digits, Math.min(modulusLen, a.numberLength), b.digits, Math.min(modulusLen, b.numberLength), res);
        TDivision.monReduction(res, modulus, n2);
        return TDivision.finalSubtraction(res, modulus);
    }

    static TBigInteger finalSubtraction(int[] res, TBigInteger modulus) {
        boolean doSub;
        int modulusLen = modulus.numberLength;
        boolean bl = doSub = res[modulusLen] != 0;
        if (!doSub) {
            int[] modulusDigits = modulus.digits;
            doSub = true;
            for (int i = modulusLen - 1; i >= 0; --i) {
                if (res[i] == modulusDigits[i]) continue;
                doSub = res[i] != 0 && ((long)res[i] & 0xFFFFFFFFL) > ((long)modulusDigits[i] & 0xFFFFFFFFL);
                break;
            }
        }
        TBigInteger result = new TBigInteger(1, modulusLen + 1, res);
        if (doSub) {
            TElementary.inplaceSubtract(result, modulus);
        }
        result.cutOffLeadingZeroes();
        return result;
    }

    static TBigInteger modPow2Inverse(TBigInteger x, int n) {
        TBigInteger y = new TBigInteger(1, new int[1 << n]);
        y.numberLength = 1;
        y.digits[0] = 1;
        y.sign = 1;
        for (int i = 1; i < n; ++i) {
            if (!TBitLevel.testBit(x.multiply(y), i)) continue;
            int n2 = i >> 5;
            y.digits[n2] = y.digits[n2] | 1 << (i & 0x1F);
        }
        return y;
    }

    static void inplaceModPow2(TBigInteger x, int n) {
        int fd = n >> 5;
        if (x.numberLength < fd || x.bitLength() <= n) {
            return;
        }
        int leadingZeros = 32 - (n & 0x1F);
        x.numberLength = fd + 1;
        int n2 = fd;
        x.digits[n2] = x.digits[n2] & (leadingZeros < 32 ? -1 >>> leadingZeros : 0);
        x.cutOffLeadingZeroes();
    }
}

