/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang;

import com.antgroup.antchain.myjava.classlib.java.lang.TClassLoader;
import com.antgroup.antchain.myjava.classlib.java.lang.TDefaultUncaughtExceptionHandler;
import com.antgroup.antchain.myjava.classlib.java.lang.TInterruptedException;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.lang.TRunnable;
import com.antgroup.antchain.myjava.classlib.java.lang.TStackTraceElement;
import com.antgroup.antchain.myjava.classlib.java.lang.TThreadInterruptHandler;
import com.antgroup.antchain.myjava.interop.AsyncCallback;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.runtime.Fiber;

@NoMetadata
public class TThread
extends TObject
implements TRunnable {
    private static TThread mainThread;
    private static TThread currentThread;
    private static int nextId;
    private static int activeCount;
    private static UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    private UncaughtExceptionHandler uncaughtExceptionHandler;
    private long id;
    private int priority;
    private boolean daemon;
    private final Object finishedLock = new Object();
    public TThreadInterruptHandler interruptHandler;
    private String name;
    private boolean alive = true;
    TRunnable target;

    public TThread() {
        this(null, null);
    }

    public TThread(String name) {
        this(null, name);
    }

    public TThread(TRunnable target) {
        this(target, null);
    }

    public TThread(TRunnable target, String name) {
        this.name = name;
        this.target = target;
        this.id = nextId++;
    }

    public void start() {
        if (Fiber.userThreadCount > 0) {
            return;
        }
        boolean daemon = this.daemon;
        if (!daemon) {
            ++Fiber.userThreadCount;
        }
        Fiber.start(this::runThread, daemon);
    }

    private void runThread() {
        try {
            ++activeCount;
            TThread.setCurrentThread(this);
            this.run();
        }
        catch (Throwable t) {
            this.getUncaughtExceptionHandler().uncaughtException(this, t);
        }
        finally {
            this.alive = false;
            --activeCount;
        }
    }

    static void setCurrentThread(TThread thread) {
        if (currentThread != thread) {
            currentThread = thread;
        }
    }

    static TThread getMainThread() {
        return mainThread;
    }

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    public static TThread currentThread() {
        return currentThread;
    }

    public String getName() {
        return this.name;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join(long millis, int nanos) throws InterruptedException {
        if (TThread.currentThread() == this) {
            return;
        }
        Object object = this.finishedLock;
        synchronized (object) {
            this.finishedLock.wait(millis, nanos);
        }
    }

    public final void join(long millis) throws InterruptedException {
        this.join(millis, 0);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public void interrupt() {
    }

    public static boolean interrupted() {
        return false;
    }

    public boolean isInterrupted() {
        return false;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public static int activeCount() {
        return activeCount;
    }

    public long getId() {
        return this.id;
    }

    public static void sleep(long millis) throws TInterruptedException {
    }

    private static void sleep(long millis, AsyncCallback<Void> callback) {
    }

    public final void setPriority(int newPriority) {
        this.priority = newPriority;
    }

    public final int getPriority() {
        return this.priority;
    }

    public TStackTraceElement[] getStackTrace() {
        return new TStackTraceElement[0];
    }

    public TClassLoader getContextClassLoader() {
        return TClassLoader.getSystemClassLoader();
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (this.uncaughtExceptionHandler != null) {
            return this.uncaughtExceptionHandler;
        }
        return defaultUncaughtExceptionHandler;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        defaultUncaughtExceptionHandler = handler;
    }

    static {
        currentThread = mainThread = new TThread("main");
        nextId = 1;
        activeCount = 1;
        defaultUncaughtExceptionHandler = new TDefaultUncaughtExceptionHandler();
    }

    @NoMetadata
    public static interface UncaughtExceptionHandler {
        public void uncaughtException(TThread var1, Throwable var2);
    }
}

