/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang;

import com.antgroup.antchain.myjava.classlib.impl.console.StderrOutputStream;
import com.antgroup.antchain.myjava.classlib.impl.console.StdoutOutputStream;
import com.antgroup.antchain.myjava.classlib.java.io.TConsole;
import com.antgroup.antchain.myjava.classlib.java.io.TInputStream;
import com.antgroup.antchain.myjava.classlib.java.io.TOutputStream;
import com.antgroup.antchain.myjava.classlib.java.io.TPrintStream;
import com.antgroup.antchain.myjava.classlib.java.lang.TArrayStoreException;
import com.antgroup.antchain.myjava.classlib.java.lang.TConsoleInputStream;
import com.antgroup.antchain.myjava.classlib.java.lang.TIndexOutOfBoundsException;
import com.antgroup.antchain.myjava.classlib.java.lang.TNullPointerException;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.lang.reflect.TArray;
import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.DelegateTo;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.runtime.Allocator;
import com.antgroup.antchain.myjava.runtime.GC;
import com.antgroup.antchain.myjava.runtime.RuntimeArray;
import com.antgroup.antchain.myjava.runtime.RuntimeClass;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;
import java.util.Enumeration;
import java.util.Properties;

@NoMetadata
public final class TSystem
extends TObject {
    private static TPrintStream outCache;
    private static TPrintStream errCache;
    private static TInputStream inCache;
    private static Properties properties;

    private TSystem() {
    }

    public static TPrintStream out() {
        if (outCache == null) {
            outCache = new TPrintStream((TOutputStream)((Object)StdoutOutputStream.INSTANCE), false);
        }
        return outCache;
    }

    public static TPrintStream err() {
        if (errCache == null) {
            errCache = new TPrintStream((TOutputStream)((Object)StderrOutputStream.INSTANCE), false);
        }
        return errCache;
    }

    public static TInputStream in() {
        if (inCache == null) {
            inCache = new TConsoleInputStream();
        }
        return inCache;
    }

    public static TConsole console() {
        return null;
    }

    public static void arraycopy(TObject src, int srcPos, TObject dest, int destPos, int length) {
        if (src == null || dest == null) {
            throw new TNullPointerException("Either src or dest is null");
        }
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > TArray.getLength(src) || destPos + length > TArray.getLength(dest)) {
            throw new TIndexOutOfBoundsException();
        }
        if (src != dest) {
            Class<?> srcType = src.getClass().getComponentType();
            Class<?> targetType = dest.getClass().getComponentType();
            if (srcType == null || targetType == null) {
                throw new TArrayStoreException();
            }
            if (srcType != targetType) {
                if (!srcType.isPrimitive() && !targetType.isPrimitive()) {
                    Object[] srcArray = (Object[])src;
                    int pos = srcPos;
                    for (int i = 0; i < length; ++i) {
                        Object elem;
                        if (targetType.isInstance(elem = srcArray[pos++])) continue;
                        TSystem.doArrayCopy(src, srcPos, dest, destPos, i);
                        throw new TArrayStoreException();
                    }
                    TSystem.doArrayCopy(src, srcPos, dest, destPos, length);
                    return;
                }
                if (!srcType.isPrimitive() || !targetType.isPrimitive()) {
                    throw new TArrayStoreException();
                }
            }
        }
        TSystem.doArrayCopy(src, srcPos, dest, destPos, length);
    }

    private static void doArrayCopy(Object src, int srcPos, Object dest, int destPos, int length) {
        TSystem.doArrayCopyLowLevel((RuntimeArray)WasmRuntime.addressToObject(Address.ofObject(src)), srcPos, (RuntimeArray)WasmRuntime.addressToObject(Address.ofObject(dest)), destPos, length);
    }

    @Unmanaged
    private static void doArrayCopyLowLevel(RuntimeArray src, int srcPos, RuntimeArray dest, int destPos, int length) {
        RuntimeClass type = RuntimeClass.getClass(src);
        int itemSize = type.itemType.size;
        if ((type.itemType.flags & 2) == 0) {
            itemSize = Address.sizeOf();
        }
        Address srcAddress = Address.align(src.toAddress().add(RuntimeArray.class, 1), itemSize);
        srcAddress = srcAddress.add(itemSize * srcPos);
        Address destAddress = Address.align(dest.toAddress().add(RuntimeArray.class, 1), itemSize);
        destAddress = destAddress.add(itemSize * destPos);
        Allocator.moveMemoryBlock(srcAddress, destAddress, length * itemSize);
    }

    public static long currentTimeMillis() {
        return TSystem.currentTimeMillisLowLevel();
    }

    private static long currentTimeMillisLowLevel() {
        return 0L;
    }

    private static void initPropertiesIfNeeded() {
        if (properties == null) {
            Properties defaults = new Properties();
            defaults.put("java.version", "1.8");
            defaults.put("os.name", "MyJava");
            defaults.put("file.separator", "/");
            defaults.put("path.separator", ":");
            defaults.put("line.separator", TSystem.lineSeparator());
            defaults.put("java.io.tmpdir", TSystem.getTempDir());
            defaults.put("java.vm.version", "1.8");
            defaults.put("user.home", TSystem.getHomeDir());
            properties = new Properties(defaults);
        }
    }

    private static String getTempDir() {
        return "/tmp";
    }

    private static String getHomeDir() {
        return "/";
    }

    public static String getProperty(String key) {
        TSystem.initPropertiesIfNeeded();
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        String value = TSystem.getProperty(key);
        return value != null ? value : def;
    }

    public static Properties getProperties() {
        TSystem.initPropertiesIfNeeded();
        Properties result = new Properties();
        TSystem.copyProperties(properties, result);
        return result;
    }

    public static void setProperties(Properties props) {
        TSystem.initPropertiesIfNeeded();
        TSystem.copyProperties(props, properties);
    }

    private static void copyProperties(Properties from, Properties to) {
        to.clear();
        if (from != null) {
            Enumeration<?> e = from.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                to.setProperty(key, from.getProperty(key));
            }
        }
    }

    public static String setProperty(String key, String value) {
        TSystem.initPropertiesIfNeeded();
        return (String)properties.put(key, value);
    }

    public static String clearProperty(String key) {
        return (String)properties.remove(key);
    }

    public static void setErr(TPrintStream err) {
        errCache = err;
    }

    public static void setOut(TPrintStream out) {
        outCache = out;
    }

    @DelegateTo(value="gcLowLevel")
    public static void gc() {
    }

    private static void gcLowLevel() {
        GC.collectGarbageFull();
    }

    public static void runFinalization() {
    }

    public static long nanoTime() {
        return TSystem.currentTimeMillisLowLevel() * 1000000L;
    }

    public static int identityHashCode(Object x) {
        return ((TObject)x).identity();
    }

    public static String lineSeparator() {
        return "\n";
    }

    public static String getenv(String name) {
        return null;
    }
}

