/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.io;

import com.antgroup.antchain.myjava.classlib.java.io.TDataInput;
import com.antgroup.antchain.myjava.classlib.java.io.TEOFException;
import com.antgroup.antchain.myjava.classlib.java.io.TFilterInputStream;
import com.antgroup.antchain.myjava.classlib.java.io.TInputStream;
import com.antgroup.antchain.myjava.classlib.java.io.TPushbackInputStream;
import com.antgroup.antchain.myjava.classlib.java.io.TUTFDataFormatException;
import com.antgroup.antchain.myjava.classlib.java.lang.TDouble;
import com.antgroup.antchain.myjava.classlib.java.lang.TFloat;
import com.antgroup.antchain.myjava.classlib.java.lang.TIndexOutOfBoundsException;
import com.antgroup.antchain.myjava.classlib.java.lang.TNullPointerException;
import com.antgroup.antchain.myjava.classlib.java.lang.TStringBuilder;
import java.io.IOException;

public class TDataInputStream
extends TFilterInputStream
implements TDataInput {
    byte[] buff = new byte[8];

    public TDataInputStream(TInputStream in) {
        super(in);
    }

    @Override
    public final int read(byte[] buffer) throws IOException {
        return this.in.read(buffer, 0, buffer.length);
    }

    @Override
    public final int read(byte[] buffer, int offset, int length) throws IOException {
        return this.in.read(buffer, offset, length);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int temp = this.in.read();
        if (temp < 0) {
            throw new TEOFException();
        }
        return temp != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int temp = this.in.read();
        if (temp < 0) {
            throw new TEOFException();
        }
        return (byte)temp;
    }

    private int readToBuff(int count) throws IOException {
        int offset;
        int bytesRead;
        for (offset = 0; offset < count; offset += bytesRead) {
            bytesRead = this.in.read(this.buff, offset, count - offset);
            if (bytesRead != -1) continue;
            return bytesRead;
        }
        return offset;
    }

    @Override
    public final char readChar() throws IOException {
        if (this.readToBuff(2) < 0) {
            throw new TEOFException();
        }
        return (char)((this.buff[0] & 0xFF) << 8 | this.buff[1] & 0xFF);
    }

    @Override
    public final double readDouble() throws IOException {
        return TDouble.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return TFloat.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] buffer) throws IOException {
        this.readFully(buffer, 0, buffer.length);
    }

    @Override
    public final void readFully(byte[] buffer, int offset, int length) throws IOException {
        if (length < 0) {
            throw new TIndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        if (this.in == null) {
            throw new TNullPointerException();
        }
        if (buffer == null) {
            throw new TNullPointerException();
        }
        if (offset < 0 || offset > buffer.length - length) {
            throw new TIndexOutOfBoundsException();
        }
        while (length > 0) {
            int result = this.in.read(buffer, offset, length);
            if (result < 0) {
                throw new TEOFException();
            }
            offset += result;
            length -= result;
        }
    }

    @Override
    public final int readInt() throws IOException {
        if (this.readToBuff(4) < 0) {
            throw new TEOFException();
        }
        return (this.buff[0] & 0xFF) << 24 | (this.buff[1] & 0xFF) << 16 | (this.buff[2] & 0xFF) << 8 | this.buff[3] & 0xFF;
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        TStringBuilder line = new TStringBuilder(80);
        boolean foundTerminator = false;
        block5: while (true) {
            int nextByte = this.in.read();
            switch (nextByte) {
                case -1: {
                    if (line.length() == 0 && !foundTerminator) {
                        return null;
                    }
                    return line.toString();
                }
                case 13: {
                    if (foundTerminator) {
                        ((TPushbackInputStream)this.in).unread(nextByte);
                        return line.toString();
                    }
                    foundTerminator = true;
                    if (this.in.getClass() == TPushbackInputStream.class) continue block5;
                    this.in = new TPushbackInputStream(this.in);
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                ((TPushbackInputStream)this.in).unread(nextByte);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    @Override
    public final long readLong() throws IOException {
        if (this.readToBuff(8) < 0) {
            throw new TEOFException();
        }
        int i1 = (this.buff[0] & 0xFF) << 24 | (this.buff[1] & 0xFF) << 16 | (this.buff[2] & 0xFF) << 8 | this.buff[3] & 0xFF;
        int i2 = (this.buff[4] & 0xFF) << 24 | (this.buff[5] & 0xFF) << 16 | (this.buff[6] & 0xFF) << 8 | this.buff[7] & 0xFF;
        return ((long)i1 & 0xFFFFFFFFL) << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    @Override
    public final short readShort() throws IOException {
        if (this.readToBuff(2) < 0) {
            throw new TEOFException();
        }
        return (short)((this.buff[0] & 0xFF) << 24 >> 16 | this.buff[1] & 0xFF);
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int temp = this.in.read();
        if (temp < 0) {
            throw new TEOFException();
        }
        return temp & 0xFF;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        if (this.readToBuff(2) < 0) {
            throw new TEOFException();
        }
        return (char)((this.buff[0] & 0xFF) << 8 | this.buff[1] & 0xFF);
    }

    @Override
    public final String readUTF() throws IOException {
        return this.decodeUTF(this.readUnsignedShort());
    }

    String decodeUTF(int utfSize) throws IOException {
        return TDataInputStream.decodeUTF(utfSize, this);
    }

    private static String decodeUTF(int utfSize, TDataInput in) throws IOException {
        byte[] buf = new byte[utfSize];
        char[] out = new char[utfSize];
        in.readFully(buf, 0, utfSize);
        return TDataInputStream.convertUTF8WithBuf(buf, out, 0, utfSize);
    }

    public static String readUTF(TDataInput in) throws IOException {
        return TDataInputStream.decodeUTF(in.readUnsignedShort(), in);
    }

    @Override
    public final int skipBytes(int count) throws IOException {
        long skip;
        int skipped = 0;
        while (skipped < count && (skip = this.in.skip((long)(count - skipped))) != 0L) {
            skipped = (int)((long)skipped + skip);
        }
        if (skipped < 0) {
            throw new TEOFException();
        }
        return skipped;
    }

    private static String convertUTF8WithBuf(byte[] buf, char[] out, int offset, int utfSize) throws TUTFDataFormatException {
        int count = 0;
        int s = 0;
        while (count < utfSize) {
            byte b;
            char ch;
            out[s] = ch = (char)buf[offset + count++];
            char a = out[s];
            if (ch < '\u0080') {
                ++s;
                continue;
            }
            if ((a & 0xE0) == 192) {
                if (count >= utfSize) {
                    throw new TUTFDataFormatException("End of stream reached");
                }
                if (((b = buf[offset + count++]) & 0xC0) != 128) {
                    throw new TUTFDataFormatException("Malformed UTF-8 sequence");
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) == 224) {
                if (count + 1 >= utfSize) {
                    throw new TUTFDataFormatException("Malformed UTF-8 sequence");
                }
                b = buf[offset + count++];
                byte c = buf[offset + count++];
                if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                    throw new TUTFDataFormatException("Malformed UTF-8 sequence");
                }
                out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            throw new TUTFDataFormatException("Malformed UTF-8 sequence");
        }
        return new String(out, 0, s);
    }
}

