/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public class TBufferedWriter
extends Writer {
    private Writer out;
    private char[] buf;
    private int pos;
    private final String lineSeparator = "\n";

    public TBufferedWriter(Writer out) {
        super((Object)out);
        this.out = out;
        this.buf = new char[8192];
    }

    public TBufferedWriter(Writer out, int size) {
        super((Object)out);
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.out = out;
        this.buf = new char[size];
    }

    @Override
    public void close() throws IOException {
        Throwable thrown;
        block8: {
            if (this.isClosed()) {
                return;
            }
            thrown = null;
            try {
                this.flushInternal();
            }
            catch (Throwable e) {
                thrown = e;
            }
            this.buf = null;
            try {
                this.out.close();
            }
            catch (Throwable e) {
                if (thrown != null) break block8;
                thrown = e;
            }
        }
        this.out = null;
        if (thrown != null) {
            if (thrown instanceof IOException) {
                throw (IOException)thrown;
            }
            if (thrown instanceof RuntimeException) {
                throw (RuntimeException)thrown;
            }
            throw new IOException(thrown);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.isClosed()) {
            throw new IOException();
        }
        this.flushInternal();
        this.out.flush();
    }

    private void flushInternal() throws IOException {
        if (this.pos > 0) {
            this.out.write(this.buf, 0, this.pos);
        }
        this.pos = 0;
    }

    private boolean isClosed() {
        return this.out == null;
    }

    public void newLine() throws IOException {
        this.write("\n", 0, "\n".length());
    }

    @Override
    public void write(char[] cbuf, int offset, int count) throws IOException {
        if (this.isClosed()) {
            throw new IOException();
        }
        if (offset < 0 || offset > Objects.requireNonNull(cbuf).length - count || count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos == 0 && count >= this.buf.length) {
            this.out.write(cbuf, offset, count);
            return;
        }
        int available = this.buf.length - this.pos;
        if (count < available) {
            available = count;
        }
        if (available > 0) {
            System.arraycopy(cbuf, offset, this.buf, this.pos, available);
            this.pos += available;
        }
        if (this.pos == this.buf.length) {
            this.out.write(this.buf, 0, this.buf.length);
            this.pos = 0;
            if (count > available) {
                offset += available;
                if ((available = count - available) >= this.buf.length) {
                    this.out.write(cbuf, offset, available);
                    return;
                }
                System.arraycopy(cbuf, offset, this.buf, this.pos, available);
                this.pos += available;
            }
        }
    }

    @Override
    public void write(int oneChar) throws IOException {
        if (this.isClosed()) {
            throw new IOException();
        }
        if (this.pos >= this.buf.length) {
            this.out.write(this.buf, 0, this.buf.length);
            this.pos = 0;
        }
        this.buf[this.pos++] = (char)oneChar;
    }

    @Override
    public void write(String str, int offset, int count) throws IOException {
        if (this.isClosed()) {
            throw new IOException();
        }
        if (count <= 0) {
            return;
        }
        if (offset > Objects.requireNonNull(str).length() - count || offset < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.pos == 0 && count >= this.buf.length) {
            char[] chars = new char[count];
            str.getChars(offset, offset + count, chars, 0);
            this.out.write(chars, 0, count);
            return;
        }
        int available = this.buf.length - this.pos;
        if (count < available) {
            available = count;
        }
        if (available > 0) {
            str.getChars(offset, offset + available, this.buf, this.pos);
            this.pos += available;
        }
        if (this.pos == this.buf.length) {
            this.out.write(this.buf, 0, this.buf.length);
            this.pos = 0;
            if (count > available) {
                offset += available;
                if ((available = count - available) >= this.buf.length) {
                    char[] chars = new char[count];
                    str.getChars(offset, offset + available, chars, 0);
                    this.out.write(chars, 0, available);
                    return;
                }
                str.getChars(offset, offset + available, this.buf, this.pos);
                this.pos += available;
            }
        }
    }
}

