/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl;

import com.antgroup.antchain.myjava.interop.Export;
import com.antgroup.antchain.myjava.model.AnnotationContainer;
import com.antgroup.antchain.myjava.model.AnnotationHolder;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassHolderTransformer;
import com.antgroup.antchain.myjava.model.ClassHolderTransformerContext;
import com.antgroup.antchain.myjava.model.FieldHolder;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MemberHolder;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.emit.ProgramEmitter;
import com.antgroup.antchain.myjava.model.emit.ValueEmitter;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import java.util.Properties;

public class ScalaHacks
implements ClassHolderTransformer {
    private static final String ATTR_NAME_CLASS = "java.util.jar.Attributes$Name";
    private static final String SCALA_INTERNAL_CLASS_MARKER = "$";

    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        switch (cls.getName()) {
            case "scala.util.PropertiesTrait$class": {
                this.transformPropertiesTrait(cls, context.getHierarchy());
                break;
            }
            case "scala.util.Properties$": {
                this.transformProperties(cls);
                break;
            }
            default: {
                if (!cls.getName().endsWith(SCALA_INTERNAL_CLASS_MARKER)) break;
                this.checkAndRemoveExportAnnotation(cls);
            }
        }
    }

    private void transformPropertiesTrait(ClassHolder cls, ClassHierarchy hierarchy) {
        for (MethodHolder method : cls.getMethods()) {
            if (!method.getName().equals("scalaProps")) continue;
            ProgramEmitter pe = ProgramEmitter.create(method, hierarchy);
            pe.construct(Properties.class, new ValueEmitter[0]).returnValue();
        }
    }

    private void transformProperties(ClassHolder cls) {
        for (FieldHolder fieldHolder : cls.getFields().toArray(new FieldHolder[0])) {
            if (!fieldHolder.getName().equals("ScalaCompilerVersion")) continue;
            cls.removeField(fieldHolder);
        }
        for (MemberHolder memberHolder : cls.getMethods().toArray(new MethodHolder[0])) {
            if (memberHolder.getName().equals("ScalaCompilerVersion")) {
                cls.removeMethod((MethodHolder)memberHolder);
                continue;
            }
            if (!memberHolder.getName().equals("<init>")) continue;
            Program program = ((MethodHolder)memberHolder).getProgram();
            for (int i = 0; i < program.basicBlockCount(); ++i) {
                BasicBlock block = program.basicBlockAt(i);
                for (Instruction insn : block) {
                    ConstructInstruction cons;
                    if (insn instanceof InvokeInstruction) {
                        if (!((InvokeInstruction)insn).getMethod().getClassName().equals(ATTR_NAME_CLASS)) continue;
                        insn.delete();
                        continue;
                    }
                    if (insn instanceof PutFieldInstruction) {
                        if (!((PutFieldInstruction)insn).getField().getFieldName().equals("ScalaCompilerVersion")) continue;
                        insn.delete();
                        continue;
                    }
                    if (!(insn instanceof ConstructInstruction) || !(cons = (ConstructInstruction)insn).getType().equals(ATTR_NAME_CLASS)) continue;
                    cons.setType("java.lang.Object");
                }
            }
        }
    }

    private void checkAndRemoveExportAnnotation(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods()) {
            AnnotationContainer items = method.getAnnotations();
            AnnotationHolder exportAnn = items.get(Export.class.getTypeName());
            if (exportAnn == null) continue;
            method.getAnnotations().remove(exportAnn);
        }
    }
}

