/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl;

import com.antgroup.antchain.myjava.classlib.ReflectionContext;
import com.antgroup.antchain.myjava.classlib.ReflectionSupplier;
import com.antgroup.antchain.myjava.dependency.AbstractDependencyListener;
import com.antgroup.antchain.myjava.dependency.DependencyAgent;
import com.antgroup.antchain.myjava.dependency.DependencyNode;
import com.antgroup.antchain.myjava.dependency.FieldDependency;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.FieldReader;
import com.antgroup.antchain.myjava.model.MemberReader;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectionDependencyListener
extends AbstractDependencyListener {
    private List<ReflectionSupplier> reflectionSuppliers;
    private MethodReference fieldGet = new MethodReference(Field.class, "get", Object.class, Object.class);
    private MethodReference fieldSet = new MethodReference(Field.class, "set", Object.class, Object.class, Void.TYPE);
    private MethodReference newInstance = new MethodReference(Constructor.class, "newInstance", Object[].class, Object.class);
    private MethodReference invokeMethod = new MethodReference(Method.class, "invoke", Object.class, Object[].class, Object.class);
    private MethodReference getFields = new MethodReference(Class.class, "getDeclaredFields", Field[].class);
    private MethodReference getConstructors = new MethodReference(Class.class, "getDeclaredConstructors", Constructor[].class);
    private MethodReference getMethods = new MethodReference(Class.class, "getDeclaredMethods", Method[].class);
    private MethodReference forName = new MethodReference(Class.class, "forName", String.class, Boolean.class, ClassLoader.class, Class.class);
    private MethodReference forNameShort = new MethodReference(Class.class, "forName", String.class, Class.class);
    private MethodReference fieldGetType = new MethodReference(Field.class, "getType", Class.class);
    private MethodReference methodGetReturnType = new MethodReference(Method.class, "getReturnType", Class.class);
    private MethodReference methodGetParameterTypes = new MethodReference(Method.class, "getParameterTypes", Class[].class);
    private MethodReference constructorGetParameterTypes = new MethodReference(Constructor.class, "getParameterTypes", Class[].class);
    private Map<String, Set<String>> accessibleFieldCache = new LinkedHashMap<String, Set<String>>();
    private Map<String, Set<MethodDescriptor>> accessibleMethodCache = new LinkedHashMap<String, Set<MethodDescriptor>>();
    private Set<String> classesWithReflectableFields = new LinkedHashSet<String>();
    private Set<String> classesWithReflectableMethods = new LinkedHashSet<String>();
    private DependencyNode allClasses;
    private DependencyNode typesInReflectableSignaturesNode;

    public ReflectionDependencyListener(List<ReflectionSupplier> reflectionSuppliers) {
        this.reflectionSuppliers = reflectionSuppliers;
    }

    @Override
    public void started(DependencyAgent agent) {
        this.allClasses = agent.createNode();
        this.typesInReflectableSignaturesNode = agent.createNode();
    }

    public Set<String> getClassesWithReflectableFields() {
        return this.classesWithReflectableFields;
    }

    public Set<String> getClassesWithReflectableMethods() {
        return this.classesWithReflectableMethods;
    }

    public Set<String> getAccessibleFields(String className) {
        return this.accessibleFieldCache.get(className);
    }

    public Set<MethodDescriptor> getAccessibleMethods(String className) {
        return this.accessibleMethodCache.get(className);
    }

    @Override
    public void classReached(DependencyAgent agent, String className) {
        this.allClasses.propagate(agent.getType(className));
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        if (method.getReference().equals(this.fieldGet)) {
            this.handleFieldGet(agent, method);
        } else if (method.getReference().equals(this.fieldSet)) {
            this.handleFieldSet(agent, method);
        } else if (method.getReference().equals(this.newInstance)) {
            this.handleNewInstance(agent, method);
        } else if (method.getReference().equals(this.invokeMethod)) {
            this.handleInvoke(agent, method);
        } else if (method.getReference().equals(this.getFields)) {
            method.getVariable(0).getClassValueNode().addConsumer(type -> {
                if (!type.getName().startsWith("[")) {
                    this.classesWithReflectableFields.add(type.getName());
                    ClassReader cls = agent.getClassSource().get(type.getName());
                    if (cls != null) {
                        for (FieldReader fieldReader : cls.getFields()) {
                            this.linkType(agent, fieldReader.getType());
                        }
                    }
                }
            });
        } else if (method.getReference().equals(this.getConstructors) || method.getReference().equals(this.getMethods)) {
            method.getVariable(0).getClassValueNode().addConsumer(type -> {
                if (!type.getName().startsWith("[")) {
                    this.classesWithReflectableMethods.add(type.getName());
                    ClassReader cls = agent.getClassSource().get(type.getName());
                    if (cls != null) {
                        for (MethodReader methodReader : cls.getMethods()) {
                            this.linkType(agent, methodReader.getResultType());
                            for (ValueType param : methodReader.getParameterTypes()) {
                                this.linkType(agent, param);
                            }
                        }
                    }
                }
            });
        } else if (method.getReference().equals(this.forName) || method.getReference().equals(this.forNameShort)) {
            this.allClasses.connect(method.getResult().getClassValueNode());
        } else if (method.getReference().equals(this.fieldGetType) || method.getReference().equals(this.methodGetReturnType)) {
            method.getResult().propagate(agent.getType("java.lang.Class"));
            this.typesInReflectableSignaturesNode.connect(method.getResult().getClassValueNode());
        } else if (method.getReference().equals(this.methodGetParameterTypes) || method.getReference().equals(this.constructorGetParameterTypes)) {
            method.getResult().getArrayItem().propagate(agent.getType("java.lang.Class"));
            this.typesInReflectableSignaturesNode.connect(method.getResult().getArrayItem().getClassValueNode());
        }
    }

    private void handleFieldGet(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getFields).addLocation(location).getVariable(0).getClassValueNode();
        classValueNode.addConsumer(reflectedType -> {
            if (reflectedType.getName().startsWith("[")) {
                return;
            }
            Set<String> accessibleFields = this.getAccessibleFields(agent, reflectedType.getName());
            ClassReader cls = agent.getClassSource().get(reflectedType.getName());
            for (String fieldName : accessibleFields) {
                FieldReader field = cls.getField(fieldName);
                FieldDependency fieldDep = agent.linkField(field.getReference()).addLocation(location);
                this.propagateGet(agent, field.getType(), fieldDep.getValue(), method.getResult(), location);
                this.linkClassIfNecessary(agent, field, location);
            }
        });
    }

    private void handleFieldSet(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getFields).addLocation(location).getVariable(0).getClassValueNode();
        classValueNode.addConsumer(reflectedType -> {
            if (reflectedType.getName().startsWith("[")) {
                return;
            }
            Set<String> accessibleFields = this.getAccessibleFields(agent, reflectedType.getName());
            ClassReader cls = agent.getClassSource().get(reflectedType.getName());
            for (String fieldName : accessibleFields) {
                FieldReader field = cls.getField(fieldName);
                FieldDependency fieldDep = agent.linkField(field.getReference()).addLocation(location);
                this.propagateSet(agent, field.getType(), method.getVariable(2), fieldDep.getValue(), location);
                this.linkClassIfNecessary(agent, field, location);
            }
        });
    }

    private void handleNewInstance(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getConstructors).addLocation(location).getVariable(0).getClassValueNode();
        classValueNode.addConsumer(reflectedType -> {
            if (reflectedType.getName().startsWith("[")) {
                return;
            }
            Set<MethodDescriptor> accessibleMethods = this.getAccessibleMethods(agent, reflectedType.getName());
            ClassReader cls = agent.getClassSource().get(reflectedType.getName());
            for (MethodDescriptor methodDescriptor : accessibleMethods) {
                MethodReader calledMethod = cls.getMethod(methodDescriptor);
                MethodDependency calledMethodDep = agent.linkMethod(calledMethod.getReference()).addLocation(location);
                calledMethodDep.use();
                for (int i = 0; i < calledMethod.parameterCount(); ++i) {
                    this.propagateSet(agent, methodDescriptor.parameterType(i), method.getVariable(1).getArrayItem(), calledMethodDep.getVariable(i + 1), location);
                }
                calledMethodDep.getVariable(0).propagate(reflectedType);
                this.linkClassIfNecessary(agent, calledMethod, location);
            }
        });
        classValueNode.connect(method.getResult());
    }

    private void handleInvoke(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getMethods).addLocation(location).getVariable(0).getClassValueNode();
        classValueNode.addConsumer(reflectedType -> {
            if (reflectedType.getName().startsWith("[")) {
                return;
            }
            Set<MethodDescriptor> accessibleMethods = this.getAccessibleMethods(agent, reflectedType.getName());
            ClassReader cls = agent.getClassSource().get(reflectedType.getName());
            for (MethodDescriptor methodDescriptor : accessibleMethods) {
                MethodReader calledMethod = cls.getMethod(methodDescriptor);
                MethodDependency calledMethodDep = agent.linkMethod(calledMethod.getReference()).addLocation(location);
                calledMethodDep.use();
                for (int i = 0; i < calledMethod.parameterCount(); ++i) {
                    this.propagateSet(agent, methodDescriptor.parameterType(i), method.getVariable(2).getArrayItem(), calledMethodDep.getVariable(i + 1), location);
                }
                this.propagateSet(agent, ValueType.object(reflectedType.getName()), method.getVariable(1), calledMethodDep.getVariable(0), location);
                this.propagateGet(agent, calledMethod.getResultType(), calledMethodDep.getResult(), method.getResult(), location);
                this.linkClassIfNecessary(agent, calledMethod, location);
            }
        });
    }

    private void linkType(DependencyAgent agent, ValueType type) {
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            agent.linkClass(className);
            this.typesInReflectableSignaturesNode.propagate(agent.getType(className));
        }
    }

    private void linkClassIfNecessary(DependencyAgent agent, MemberReader member, CallLocation location) {
        if (member.hasModifier(ElementModifier.STATIC)) {
            agent.linkClass(member.getOwnerName()).initClass(location);
        }
    }

    private Set<String> getAccessibleFields(DependencyAgent agent, String className) {
        return this.accessibleFieldCache.computeIfAbsent(className, key -> this.gatherAccessibleFields(agent, (String)key));
    }

    private Set<MethodDescriptor> getAccessibleMethods(DependencyAgent agent, String className) {
        return this.accessibleMethodCache.computeIfAbsent(className, key -> this.gatherAccessibleMethods(agent, (String)key));
    }

    private Set<String> gatherAccessibleFields(DependencyAgent agent, String className) {
        ReflectionContextImpl context = new ReflectionContextImpl(agent);
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        for (ReflectionSupplier supplier : this.reflectionSuppliers) {
            fields.addAll(supplier.getAccessibleFields(context, className));
        }
        return fields;
    }

    private Set<MethodDescriptor> gatherAccessibleMethods(DependencyAgent agent, String className) {
        ReflectionContextImpl context = new ReflectionContextImpl(agent);
        LinkedHashSet<MethodDescriptor> methods = new LinkedHashSet<MethodDescriptor>();
        for (ReflectionSupplier supplier : this.reflectionSuppliers) {
            methods.addAll(supplier.getAccessibleMethods(context, className));
        }
        return methods;
    }

    private void propagateGet(DependencyAgent agent, ValueType type, DependencyNode sourceNode, DependencyNode targetNode, CallLocation location) {
        if (type instanceof ValueType.Primitive) {
            MethodReference boxMethod;
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    boxMethod = new MethodReference(Boolean.class, "valueOf", Boolean.TYPE, Boolean.class);
                    break;
                }
                case BYTE: {
                    boxMethod = new MethodReference(Byte.class, "valueOf", Byte.TYPE, Byte.class);
                    break;
                }
                case SHORT: {
                    boxMethod = new MethodReference(Short.class, "valueOf", Short.TYPE, Short.class);
                    break;
                }
                case CHARACTER: {
                    boxMethod = new MethodReference(Character.class, "valueOf", Character.TYPE, Character.class);
                    break;
                }
                case INTEGER: {
                    boxMethod = new MethodReference(Integer.class, "valueOf", Integer.TYPE, Integer.class);
                    break;
                }
                case LONG: {
                    boxMethod = new MethodReference(Long.class, "valueOf", Long.TYPE, Long.class);
                    break;
                }
                case FLOAT: {
                    boxMethod = new MethodReference(Float.class, "valueOf", Float.TYPE, Float.class);
                    break;
                }
                case DOUBLE: {
                    boxMethod = new MethodReference(Double.class, "valueOf", Double.TYPE, Double.class);
                    break;
                }
                default: {
                    throw new AssertionError((Object)type.toString());
                }
            }
            MethodDependency boxMethodDep = agent.linkMethod(boxMethod).addLocation(location);
            boxMethodDep.use();
            boxMethodDep.getResult().connect(targetNode);
        } else if (type instanceof ValueType.Array || type instanceof ValueType.Object) {
            sourceNode.connect(targetNode);
        }
    }

    private void propagateSet(DependencyAgent agent, ValueType type, DependencyNode sourceNode, DependencyNode targetNode, CallLocation location) {
        if (type instanceof ValueType.Primitive) {
            MethodReference unboxMethod;
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    unboxMethod = new MethodReference(Boolean.class, "booleanValue", Boolean.TYPE);
                    break;
                }
                case BYTE: {
                    unboxMethod = new MethodReference(Byte.class, "byteValue", Byte.TYPE);
                    break;
                }
                case SHORT: {
                    unboxMethod = new MethodReference(Short.class, "shortValue", Short.TYPE);
                    break;
                }
                case CHARACTER: {
                    unboxMethod = new MethodReference(Character.class, "charValue", Character.TYPE);
                    break;
                }
                case INTEGER: {
                    unboxMethod = new MethodReference(Integer.class, "intValue", Integer.TYPE);
                    break;
                }
                case LONG: {
                    unboxMethod = new MethodReference(Long.class, "longValue", Long.TYPE);
                    break;
                }
                case FLOAT: {
                    unboxMethod = new MethodReference(Float.class, "floatValue", Float.TYPE);
                    break;
                }
                case DOUBLE: {
                    unboxMethod = new MethodReference(Double.class, "doubleOf", Double.TYPE);
                    break;
                }
                default: {
                    throw new AssertionError((Object)type.toString());
                }
            }
            MethodDependency unboxMethodDep = agent.linkMethod(unboxMethod).addLocation(location);
            unboxMethodDep.use();
            sourceNode.connect(unboxMethodDep.getResult());
        } else if (type instanceof ValueType.Array || type instanceof ValueType.Object) {
            sourceNode.connect(targetNode);
        }
    }

    private static class ReflectionContextImpl
    implements ReflectionContext {
        private DependencyAgent agent;

        public ReflectionContextImpl(DependencyAgent agent) {
            this.agent = agent;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.agent.getClassLoader();
        }

        @Override
        public ClassReaderSource getClassSource() {
            return this.agent.getClassSource();
        }
    }
}

