/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl;

import com.antgroup.antchain.myjava.diagnostics.Diagnostics;
import com.antgroup.antchain.myjava.interop.PlatformMarker;
import com.antgroup.antchain.myjava.model.AnnotationReader;
import com.antgroup.antchain.myjava.model.AnnotationValue;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassHolderTransformer;
import com.antgroup.antchain.myjava.model.ClassHolderTransformerContext;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.FieldReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MemberReader;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.optimization.ConstantConditionElimination;
import com.antgroup.antchain.myjava.model.optimization.GlobalValueNumbering;
import com.antgroup.antchain.myjava.model.optimization.UnreachableBasicBlockEliminator;

public class PlatformMarkerSupport
implements ClassHolderTransformer {
    private String[] tags;

    public PlatformMarkerSupport(String[] tags) {
        this.tags = tags;
    }

    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        for (MethodHolder method : cls.getMethods()) {
            if (method.getProgram() == null) continue;
            this.transformProgram(method.getReference(), method.getProgram(), context.getHierarchy(), context.getDiagnostics());
        }
    }

    private void transformProgram(MethodReference containingMethod, Program program, ClassHierarchy hierarchy, Diagnostics diagnostics) {
        boolean hasChanges = false;
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                Variable receiver;
                MarkerKind kind;
                if (instruction instanceof InvokeInstruction) {
                    MethodReference methodRef = ((InvokeInstruction)instruction).getMethod();
                    MethodReader method = hierarchy.resolve(methodRef);
                    if (method == null || (kind = this.isMarker(method)) == null) continue;
                    if (!method.hasModifier(ElementModifier.STATIC)) {
                        diagnostics.error(new CallLocation(containingMethod, instruction.getLocation()), "Method '{{m0}}' is marked with '{{c1}}' and should be static", methodRef, PlatformMarker.class.getName());
                    }
                    if (method.getResultType() != ValueType.BOOLEAN) {
                        diagnostics.error(new CallLocation(containingMethod, instruction.getLocation()), "Method '{{m0}}' is marked with '{{c1}}' and should return boolean", methodRef, PlatformMarker.class.getName());
                        continue;
                    }
                    receiver = ((InvokeInstruction)instruction).getReceiver();
                } else {
                    FieldReference fieldRef;
                    FieldReader field;
                    if (!(instruction instanceof GetFieldInstruction) || (field = hierarchy.resolve(fieldRef = ((GetFieldInstruction)instruction).getField())) == null || (kind = this.isMarker(field)) == null) continue;
                    if (!field.hasModifier(ElementModifier.STATIC)) {
                        diagnostics.error(new CallLocation(containingMethod, instruction.getLocation()), "Field '{{f0}}' is marked with '{{c1}}' and should be static", fieldRef, PlatformMarker.class.getName());
                    }
                    if (field.getType() != ValueType.BOOLEAN) {
                        diagnostics.error(new CallLocation(containingMethod, instruction.getLocation()), "Field '{{f0}}' is marked with '{{c1}}' and should be boolean", fieldRef, PlatformMarker.class.getName());
                        continue;
                    }
                    receiver = ((GetFieldInstruction)instruction).getReceiver();
                }
                hasChanges = true;
                if (receiver == null) {
                    instruction.delete();
                    continue;
                }
                IntegerConstantInstruction trueResult = new IntegerConstantInstruction();
                trueResult.setReceiver(receiver);
                trueResult.setConstant(kind == MarkerKind.TRUE ? 1 : 0);
                trueResult.setLocation(instruction.getLocation());
                instruction.replace(trueResult);
            }
        }
        if (hasChanges) {
            boolean changed;
            do {
                changed = new GlobalValueNumbering(true).optimize(program) | new ConstantConditionElimination().optimize(containingMethod.getDescriptor(), program);
                new UnreachableBasicBlockEliminator().optimize(program);
            } while (changed);
        }
    }

    private MarkerKind isMarker(MemberReader member) {
        AnnotationReader annot = member.getAnnotations().get(PlatformMarker.class.getName());
        if (annot == null) {
            return null;
        }
        AnnotationValue value = annot.getValue("value");
        if (value == null) {
            return MarkerKind.TRUE;
        }
        String tagToMatch = value.getString();
        for (String tag : this.tags) {
            if (!tag.equals(tagToMatch)) continue;
            return MarkerKind.TRUE;
        }
        return MarkerKind.FALSE;
    }

    static enum MarkerKind {
        TRUE,
        FALSE;

    }
}

