/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl;

import com.antgroup.antchain.myjava.backend.wasm.MyJavaWasmHost;
import com.antgroup.antchain.myjava.classlib.ReflectionSupplier;
import com.antgroup.antchain.myjava.classlib.impl.ClassForNameTransformer;
import com.antgroup.antchain.myjava.classlib.impl.DeclaringClassDependencyListener;
import com.antgroup.antchain.myjava.classlib.impl.KotlinHacks;
import com.antgroup.antchain.myjava.classlib.impl.NumericClassTransformer;
import com.antgroup.antchain.myjava.classlib.impl.ObfuscationHacks;
import com.antgroup.antchain.myjava.classlib.impl.PlatformMarkerSupport;
import com.antgroup.antchain.myjava.classlib.impl.ReflectionDependencyListener;
import com.antgroup.antchain.myjava.classlib.impl.ScalaHacks;
import com.antgroup.antchain.myjava.classlib.impl.ServiceLoaderInformation;
import com.antgroup.antchain.myjava.classlib.impl.ServiceLoaderSupport;
import com.antgroup.antchain.myjava.classlib.impl.StringConcatFactorySubstitutor;
import com.antgroup.antchain.myjava.classlib.impl.SystemClassTransformer;
import com.antgroup.antchain.myjava.classlib.impl.lambda.LambdaMetafactorySubstitutor;
import com.antgroup.antchain.myjava.classlib.impl.tz.DateTimeZoneProviderIntrinsic;
import com.antgroup.antchain.myjava.classlib.impl.tz.DateTimeZoneProviderPatch;
import com.antgroup.antchain.myjava.classlib.impl.unicode.CLDRReader;
import com.antgroup.antchain.myjava.classlib.java.lang.reflect.AnnotationDependencyListener;
import com.antgroup.antchain.myjava.interop.PlatformMarker;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.vm.MyJavaPluginUtil;
import com.antgroup.antchain.myjava.vm.spi.MyJavaHost;
import com.antgroup.antchain.myjava.vm.spi.MyJavaPlugin;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ServiceLoader;

public class JCLPlugin
implements MyJavaPlugin {
    @Override
    public void install(MyJavaHost host) {
        host.add(new ObfuscationHacks());
        if (!JCLPlugin.isBootstrap()) {
            ServiceLoaderSupport serviceLoaderSupport = new ServiceLoaderSupport(host.getClassLoader());
            host.add(serviceLoaderSupport);
            host.registerService(ServiceLoaderInformation.class, serviceLoaderSupport);
        }
        if (!JCLPlugin.isBootstrap()) {
            host.registerService(CLDRReader.class, CLDRReader.getInstance(host.getProperties(), host.getClassLoader()));
            host.add(new ClassForNameTransformer());
        }
        host.add(new AnnotationDependencyListener());
        LambdaMetafactorySubstitutor lms = new LambdaMetafactorySubstitutor();
        host.add(new MethodReference("java.lang.invoke.LambdaMetafactory", "metafactory", ValueType.object("java.lang.invoke.MethodHandles$Lookup"), ValueType.object("java.lang.String"), ValueType.object("java.lang.invoke.MethodType"), ValueType.object("java.lang.invoke.MethodType"), ValueType.object("java.lang.invoke.MethodHandle"), ValueType.object("java.lang.invoke.MethodType"), ValueType.object("java.lang.invoke.CallSite")), lms);
        host.add(new MethodReference("java.lang.invoke.LambdaMetafactory", "altMetafactory", ValueType.object("java.lang.invoke.MethodHandles$Lookup"), ValueType.object("java.lang.String"), ValueType.object("java.lang.invoke.MethodType"), ValueType.arrayOf(ValueType.object("java.lang.Object")), ValueType.object("java.lang.invoke.CallSite")), lms);
        StringConcatFactorySubstitutor stringConcatSubstitutor = new StringConcatFactorySubstitutor();
        host.add(new MethodReference("java.lang.invoke.StringConcatFactory", "makeConcat", ValueType.object("java.lang.invoke.MethodHandles$Lookup"), ValueType.object("java.lang.String"), ValueType.object("java.lang.invoke.MethodType"), ValueType.object("java.lang.invoke.CallSite")), stringConcatSubstitutor);
        host.add(new MethodReference("java.lang.invoke.StringConcatFactory", "makeConcatWithConstants", ValueType.object("java.lang.invoke.MethodHandles$Lookup"), ValueType.object("java.lang.String"), ValueType.object("java.lang.invoke.MethodType"), ValueType.object("java.lang.String"), ValueType.arrayOf(ValueType.object("java.lang.Object")), ValueType.object("java.lang.invoke.CallSite")), stringConcatSubstitutor);
        if (!JCLPlugin.isBootstrap()) {
            host.add(new ScalaHacks());
            host.add(new KotlinHacks());
        }
        host.add(new NumericClassTransformer());
        host.add(new SystemClassTransformer());
        if (!JCLPlugin.isBootstrap()) {
            ArrayList<ReflectionSupplier> reflectionSuppliers = new ArrayList<ReflectionSupplier>();
            for (ReflectionSupplier supplier : ServiceLoader.load(ReflectionSupplier.class, host.getClassLoader())) {
                reflectionSuppliers.add(supplier);
            }
            ReflectionDependencyListener reflection = new ReflectionDependencyListener(reflectionSuppliers);
            host.registerService(ReflectionDependencyListener.class, reflection);
            host.add(reflection);
            host.add(new PlatformMarkerSupport(host.getPlatformTags()));
            MyJavaWasmHost wasmHost = host.getExtension(MyJavaWasmHost.class);
            if (wasmHost != null) {
                wasmHost.add(context -> new DateTimeZoneProviderIntrinsic(context.getProperties()));
            }
        }
        MyJavaPluginUtil.handleNatives(host, Class.class);
        MyJavaPluginUtil.handleNatives(host, ClassLoader.class);
        MyJavaPluginUtil.handleNatives(host, System.class);
        MyJavaPluginUtil.handleNatives(host, Array.class);
        MyJavaPluginUtil.handleNatives(host, Math.class);
        host.add(new DeclaringClassDependencyListener());
        this.applyTimeZoneDetection(host);
    }

    private void applyTimeZoneDetection(MyJavaHost host) {
        boolean autodetect = Boolean.parseBoolean(host.getProperties().getProperty("java.util.TimeZone.autodetect", "false"));
        if (!autodetect) {
            host.add(new DateTimeZoneProviderPatch());
        }
    }

    @PlatformMarker
    private static boolean isBootstrap() {
        return false;
    }
}

