/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.cache;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.InvokeDynamicInstruction;
import com.antgroup.antchain.myjava.model.MethodHandle;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.RuntimeConstant;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import java.util.LinkedHashSet;
import java.util.Set;

public class ProgramDependencyExtractor
extends AbstractInstructionVisitor {
    private final AnalyzingVisitor visitor = new AnalyzingVisitor();

    public String[] extractDependencies(Program program) {
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                instruction.acceptVisitor(this.visitor);
            }
        }
        String[] result = this.visitor.dependencies.toArray(new String[0]);
        this.visitor.dependencies.clear();
        return result;
    }

    static class AnalyzingVisitor
    extends AbstractInstructionVisitor {
        Set<String> dependencies = new LinkedHashSet<String>();

        AnalyzingVisitor() {
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            this.dependencies.add(insn.getField().getClassName());
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            this.dependencies.add(insn.getField().getClassName());
        }

        @Override
        public void visit(InvokeInstruction insn) {
            this.dependencies.add(insn.getMethod().getClassName());
        }

        @Override
        public void visit(InvokeDynamicInstruction insn) {
            for (RuntimeConstant cst : insn.getBootstrapArguments()) {
                if (cst.getKind() != 7) continue;
                MethodHandle handle = cst.getMethodHandle();
                this.dependencies.add(handle.getClassName());
            }
        }
    }
}

