/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.cache;

import com.antgroup.antchain.myjava.cache.CachedElement;
import com.antgroup.antchain.myjava.cache.CachedField;
import com.antgroup.antchain.myjava.cache.CachedMethod;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.FieldReader;
import com.antgroup.antchain.myjava.model.GenericTypeParameter;
import com.antgroup.antchain.myjava.model.GenericValueType;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class CachedClassReader
extends CachedElement
implements ClassReader {
    String parent;
    GenericTypeParameter[] parameters;
    GenericValueType.Object genericParent;
    String owner;
    String declaringClass;
    String simpleName;
    Set<String> interfaces;
    Set<GenericValueType.Object> genericInterfaces;
    Map<MethodDescriptor, CachedMethod> methods;
    Map<String, CachedField> fields;

    CachedClassReader() {
    }

    @Override
    public GenericTypeParameter[] getGenericParameters() {
        return this.parameters != null ? (GenericTypeParameter[])this.parameters.clone() : new GenericTypeParameter[]{};
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public GenericValueType.Object getGenericParent() {
        return this.genericParent;
    }

    @Override
    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public Set<GenericValueType.Object> getGenericInterfaces() {
        return this.genericInterfaces;
    }

    @Override
    public MethodReader getMethod(MethodDescriptor method) {
        return this.methods.get(method);
    }

    @Override
    public Collection<? extends MethodReader> getMethods() {
        return this.methods.values();
    }

    @Override
    public Collection<? extends MethodReader> getConstructors() {
        return this.methods.values().stream().filter(m -> "<init>".equals(m.getName())).collect(Collectors.toList());
    }

    @Override
    public FieldReader getField(String name) {
        return this.fields.get(name);
    }

    @Override
    public Collection<? extends FieldReader> getFields() {
        return this.fields.values();
    }

    @Override
    public String getOwnerName() {
        return this.owner;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getDeclaringClassName() {
        return this.declaringClass;
    }
}

