/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.render;

import com.antgroup.antchain.myjava.backend.wasm.model.WasmFunction;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmGlobalInfo;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmMemorySegment;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmModule;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.render.WasmRenderingVisitor;
import com.antgroup.antchain.myjava.backend.wasm.render.WasmSignature;
import com.antgroup.antchain.myjava.backend.wasm.render.WasmSignatureCollector;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class WasmRenderer {
    private WasmRenderingVisitor visitor = new WasmRenderingVisitor();

    public WasmRenderer append(String text) {
        this.visitor.append(text);
        return this;
    }

    public WasmRenderer lf() {
        this.visitor.lf();
        return this;
    }

    public WasmRenderer indent() {
        this.visitor.indent();
        return this;
    }

    public WasmRenderer outdent() {
        this.visitor.outdent();
        return this;
    }

    public boolean isLineNumbersEmitted() {
        return this.visitor.lineNumbersEmitted;
    }

    public void setLineNumbersEmitted(boolean value) {
        this.visitor.lineNumbersEmitted = value;
    }

    public void render(WasmModule module) {
        this.visitor.open().append("module");
        this.renderTypes(module);
        int functionIndex = 0;
        for (WasmFunction function : module.getFunctions().values()) {
            if (function.getImportName() == null) continue;
            this.lf().append(";; function #" + functionIndex++).lf().render(function);
        }
        for (WasmFunction function : module.getFunctions().values()) {
            if (function.getImportName() != null) continue;
            this.lf().append(";; function #" + functionIndex++).lf().render(function);
        }
        this.renderTable(module);
        this.renderMemory(module);
        this.renderGlobal(module);
        this.renderElement(module);
        this.renderData(module);
        if (module.getStartFunction() != null) {
            this.visitor.lf().open().append("start $" + module.getStartFunction().getName()).close().lf();
        }
        this.visitor.close().lf();
    }

    public void renderMemory(WasmModule module) {
        this.visitor.lf();
        this.visitor.open().append("memory (export \"memory\") " + module.getMinMemorySize()).close().lf();
    }

    public void renderGlobal(WasmModule module) {
        List<WasmGlobalInfo> globalInfos = module.getGlobals();
        if (globalInfos.isEmpty()) {
            return;
        }
        this.visitor.lf();
        for (int i = 0; i < globalInfos.size(); ++i) {
            WasmGlobalInfo globalInfo = globalInfos.get(i);
            this.visitor.open().append("global global" + i + " (" + globalInfo.getType().toString().toLowerCase() + ".const " + globalInfo.getValueString() + ")").close().lf();
        }
    }

    public void renderData(WasmModule module) {
        for (WasmMemorySegment segment : module.getSegments()) {
            this.visitor.lf().open().append("data (i32.const " + segment.getOffset() + ")");
            this.visitor.indent();
            for (int i = 0; i < segment.getLength(); i += 256) {
                this.visitor.lf().append("\"");
                byte[] part = segment.getData(i, Math.min(segment.getLength(), i + 256) - i);
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < part.length; ++j) {
                    int b = part[j] << 24 >>> 24;
                    if (b < 32 || b > 126) {
                        sb.append("\\" + Character.forDigit(b >> 4, 16) + Character.forDigit(b & 0xF, 16));
                        continue;
                    }
                    if (b == 92) {
                        sb.append("\\\\");
                        continue;
                    }
                    if (b == 34) {
                        sb.append("\\\"");
                        continue;
                    }
                    sb.append((char)b);
                }
                this.visitor.append(sb.toString()).append("\"");
            }
            this.visitor.outdent();
            this.visitor.close();
        }
    }

    public void render(WasmFunction function) {
        this.visitor.open().append("func $" + function.getName());
        if (function.getImportName() != null) {
            String importModule = function.getImportModule();
            if (importModule == null) {
                importModule = "";
            }
            this.visitor.append(" (import \"" + importModule + "\" \"" + function.getImportName() + "\")");
        } else if (function.getExportName() != null) {
            this.visitor.append(" (export \"" + function.getExportName() + "\")");
        }
        this.renderSignature(function);
        int firstLocalVariable = function.getParameters().size();
        if (firstLocalVariable < function.getLocalVariables().size()) {
            this.visitor.lf().open().append("local");
            List<WasmLocal> locals = function.getLocalVariables().subList(firstLocalVariable, function.getLocalVariables().size());
            for (WasmLocal local : locals) {
                this.visitor.append(" ").append(local.getType());
            }
            this.visitor.close();
        }
        for (WasmExpression part : function.getBody()) {
            this.visitor.preprocess(part);
        }
        for (WasmExpression part : function.getBody()) {
            this.visitor.line(part);
        }
        this.visitor.close().lf();
        this.visitor.clear();
    }

    private void renderSignature(WasmFunction function) {
        WasmSignature signature = WasmSignature.fromFunction(function);
        this.visitor.append(" ").open().append("type $type" + this.visitor.getSignatureIndex(signature)).close();
    }

    private void renderTypes(WasmModule module) {
        WasmSignatureCollector signatureCollector = new WasmSignatureCollector(this.visitor::getSignatureIndex);
        for (WasmFunction function : module.getFunctions().values()) {
            this.visitor.getSignatureIndex(WasmSignature.fromFunction(function));
            for (WasmExpression part : function.getBody()) {
                part.acceptVisitor(signatureCollector);
            }
        }
        if (this.visitor.signatureList.isEmpty()) {
            return;
        }
        this.visitor.lf();
        int index = 0;
        for (WasmSignature signature : this.visitor.signatureList) {
            this.visitor.open().append("type $type" + index++ + " ");
            this.visitor.open().append("func");
            if (signature.types.length > 1) {
                this.visitor.append(" ").open().append("param");
                for (int i = 1; i < signature.types.length; ++i) {
                    this.visitor.append(" ").append(signature.types[i]);
                }
                this.visitor.close();
            }
            if (signature.types[0] != null) {
                this.visitor.append(" ").open().append("result ");
                this.visitor.append(signature.types[0]);
                this.visitor.close();
            }
            this.visitor.close();
            this.visitor.close();
            this.visitor.lf();
        }
    }

    private void renderTable(WasmModule module) {
        if (module.getFunctionTable().isEmpty()) {
            return;
        }
        this.visitor.lf().open().append("table " + module.getFunctionTable().size() + " anyfunc").close().lf();
    }

    private void renderElement(WasmModule module) {
        if (module.getFunctionTable().isEmpty()) {
            return;
        }
        this.visitor.lf().open().append("elem (i32.const 0)");
        for (WasmFunction function : module.getFunctionTable()) {
            this.visitor.lf().append("$" + function.getName());
        }
        this.visitor.close().lf();
    }

    public String toString() {
        return this.visitor.sb.toString();
    }

    public void writeTo(Writer writer) throws IOException {
        this.visitor.sb.writeTo(writer);
    }
}

