/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.model.expression;

import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmBlock;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmBranch;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmBreak;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmConditional;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmConversion;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmDrop;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpressionVisitor;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmFloat32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmFloat64Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmFloatBinary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmFloatUnary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmGetGlobal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmGetLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIndirectCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt64Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntUnary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmLoadFloat32;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmLoadFloat64;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmLoadInt32;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmLoadInt64;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmMemoryGrow;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmReturn;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmSetGlobal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmSetLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmStoreFloat32;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmStoreFloat64;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmStoreInt32;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmStoreInt64;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmSwitch;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmUnreachable;

public class WasmDefaultExpressionVisitor
implements WasmExpressionVisitor {
    @Override
    public void visit(WasmBlock expression) {
        for (WasmExpression part : expression.getBody()) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmBranch expression) {
        expression.getCondition().acceptVisitor(this);
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmBreak expression) {
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmSwitch expression) {
        expression.getSelector().acceptVisitor(this);
    }

    @Override
    public void visit(WasmConditional expression) {
        expression.getCondition().acceptVisitor(this);
        for (WasmExpression part : expression.getThenBlock().getBody()) {
            part.acceptVisitor(this);
        }
        for (WasmExpression part : expression.getElseBlock().getBody()) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmReturn expression) {
        if (expression.getValue() != null) {
            expression.getValue().acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmUnreachable expression) {
    }

    @Override
    public void visit(WasmInt32Constant expression) {
    }

    @Override
    public void visit(WasmInt64Constant expression) {
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
    }

    @Override
    public void visit(WasmGetLocal expression) {
    }

    @Override
    public void visit(WasmSetLocal expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmGetGlobal expression) {
    }

    @Override
    public void visit(WasmSetGlobal expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmIntBinary expression) {
        expression.getFirst().acceptVisitor(this);
        expression.getSecond().acceptVisitor(this);
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        expression.getFirst().acceptVisitor(this);
        expression.getSecond().acceptVisitor(this);
    }

    @Override
    public void visit(WasmIntUnary expression) {
        expression.getOperand().acceptVisitor(this);
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        expression.getOperand().acceptVisitor(this);
    }

    @Override
    public void visit(WasmConversion expression) {
        expression.getOperand().acceptVisitor(this);
    }

    @Override
    public void visit(WasmCall expression) {
        for (WasmExpression argument : expression.getArguments()) {
            argument.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        expression.getSelector().acceptVisitor(this);
        for (WasmExpression argument : expression.getArguments()) {
            argument.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WasmDrop expression) {
        expression.getOperand().acceptVisitor(this);
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        expression.getIndex().acceptVisitor(this);
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        expression.getIndex().acceptVisitor(this);
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        expression.getIndex().acceptVisitor(this);
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        expression.getIndex().acceptVisitor(this);
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmMemoryGrow expression) {
        expression.getAmount().acceptVisitor(this);
    }
}

