/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.model;

import com.antgroup.antchain.myjava.backend.wasm.model.WasmFunction;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmGlobalInfo;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmMemorySegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WasmModule {
    private int minMemorySize;
    private int maxMemorySize;
    private List<WasmMemorySegment> segments = new ArrayList<WasmMemorySegment>();
    private Map<String, WasmFunction> functions = new LinkedHashMap<String, WasmFunction>();
    private Map<String, WasmFunction> readonlyFunctions = Collections.unmodifiableMap(this.functions);
    private List<WasmFunction> renderedFunctions = new ArrayList<WasmFunction>();
    private List<WasmFunction> functionTable = new ArrayList<WasmFunction>();
    private WasmFunction startFunction;
    private List<WasmGlobalInfo> globals = new ArrayList<WasmGlobalInfo>();

    public void add(WasmFunction function) {
        if (this.functions.containsKey(function.getName())) {
            throw new IllegalArgumentException("Function " + function.getName() + " already defined in this module");
        }
        if (function.module != null) {
            throw new IllegalArgumentException("Given function is already registered in another module");
        }
        this.functions.put(function.getName(), function);
        function.module = this;
    }

    public void remove(WasmFunction function) {
        if (function.getModule() != this) {
            return;
        }
        function.module = null;
        this.functions.remove(function.getName());
    }

    public Map<String, WasmFunction> getFunctions() {
        return this.readonlyFunctions;
    }

    public void setRenderedFunctions(List<WasmFunction> renderedFunctions) {
        this.renderedFunctions = renderedFunctions;
    }

    public List<WasmFunction> getRenderedFunctions() {
        return this.renderedFunctions;
    }

    public List<WasmFunction> getFunctionTable() {
        return this.functionTable;
    }

    public List<WasmMemorySegment> getSegments() {
        return this.segments;
    }

    public int getMinMemorySize() {
        return this.minMemorySize;
    }

    public void setMinMemorySize(int minMemorySize) {
        this.minMemorySize = minMemorySize;
    }

    public int getMaxMemorySize() {
        return this.maxMemorySize;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public WasmFunction getStartFunction() {
        return this.startFunction;
    }

    public void setStartFunction(WasmFunction startFunction) {
        this.startFunction = startFunction;
    }

    public List<WasmGlobalInfo> getGlobals() {
        return this.globals;
    }

    public void setGlobals(List<WasmGlobalInfo> globals) {
        this.globals = globals;
    }
}

