/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinaryOperation;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntType;
import com.antgroup.antchain.myjava.model.MethodReference;

public class LongIntrinsic
implements WasmIntrinsic {
    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (!methodReference.getClassName().equals(Long.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "divideUnsigned": 
            case "remainderUnsigned": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "divideUnsigned": {
                return new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.DIV_UNSIGNED, manager.generate(invocation.getArguments().get(0)), manager.generate(invocation.getArguments().get(1)));
            }
            case "remainderUnsigned": {
                return new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.REM_UNSIGNED, manager.generate(invocation.getArguments().get(0)), manager.generate(invocation.getArguments().get(1)));
            }
        }
        throw new AssertionError();
    }
}

