/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.binary.BinaryWriter;
import com.antgroup.antchain.myjava.backend.wasm.generate.CallSiteBinaryGenerator;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmClassGenerator;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmStringPool;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinaryOperation;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmUnreachable;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.lowlevel.CallSiteDescriptor;
import com.antgroup.antchain.myjava.runtime.CallSite;
import com.antgroup.antchain.myjava.runtime.ExceptionHandling;
import java.util.ArrayList;
import java.util.List;

public class ExceptionHandlingIntrinsic
implements WasmIntrinsic {
    private CallSiteBinaryGenerator callSiteBinaryGenerator;
    private WasmClassGenerator classGenerator;
    private List<WasmInt32Constant> constants = new ArrayList<WasmInt32Constant>();

    public ExceptionHandlingIntrinsic(BinaryWriter binaryWriter, WasmClassGenerator classGenerator, WasmStringPool stringPool, boolean obfuscated) {
        this.callSiteBinaryGenerator = new CallSiteBinaryGenerator(binaryWriter, classGenerator, stringPool, obfuscated);
        this.classGenerator = classGenerator;
    }

    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (!methodReference.getClassName().equals(ExceptionHandling.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "findCallSiteById": 
            case "abort": {
                return true;
            }
        }
        return false;
    }

    public void postProcess(List<? extends CallSiteDescriptor> callSites) {
        int address = this.callSiteBinaryGenerator.writeCallSites(callSites);
        for (WasmInt32Constant constant : this.constants) {
            constant.setValue(address);
        }
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "findCallSiteById": {
                WasmInt32Constant constant = new WasmInt32Constant(0);
                constant.setLocation(invocation.getLocation());
                this.constants.add(constant);
                int callSiteSize = this.classGenerator.getClassSize(CallSite.class.getName());
                WasmExpression id = manager.generate(invocation.getArguments().get(0));
                WasmIntBinary offset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.MUL, id, new WasmInt32Constant(callSiteSize));
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, constant, offset);
            }
            case "abort": {
                return new WasmUnreachable();
            }
        }
        throw new IllegalArgumentException("Unknown method: " + invocation.getMethod());
    }
}

