/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.javautils.JavaByteArrayWasmExprPair;
import com.antgroup.antchain.myjava.backend.wasm.javautils.JavaStringWasmUtils;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmBlock;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmUnreachable;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.runtime.Console;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;

public class ConsoleIntrinsic
implements WasmIntrinsic {
    private static final MethodReference PRINTLN_STRING = new MethodReference(WasmRuntime.class, "printlnString", Integer.TYPE, Integer.TYPE, Integer.TYPE);

    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (!methodReference.getClassName().equals(Console.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "printlnStringBytes": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "printlnStringBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                String name = manager.getNames().forMethod(PRINTLN_STRING);
                WasmCall call = new WasmCall(name, true);
                call.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                call.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(call);
                return block;
            }
        }
        return new WasmUnreachable();
    }
}

