/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmBlock;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.interop.AnnotationsHolder;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;
import java.lang.annotation.Annotation;

public class AnnotationIntrinsic
implements WasmIntrinsic {
    private static final MethodReference GET_ANNOTATION_TYPE = new MethodReference(WasmRuntime.class, "getAnnotationType", Integer.TYPE, Integer.TYPE);
    private static final MethodReference CLASS_TO_STRING = new MethodReference(Class.class, "toString", Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_ANNOTATION_PROP = new MethodReference(AnnotationsHolder.class, "getProp", Annotation.class, String.class, Object.class);

    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (methodReference.getClassName().equals(Annotation.class.getName())) {
            return true;
        }
        ClassReader clsReader = ctx.getClassSource().get(methodReference.getClassName());
        if (clsReader == null) {
            return false;
        }
        return clsReader.getInterfaces().contains(Annotation.class.getName());
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        String methodName;
        switch (methodName = invocation.getMethod().getName()) {
            case "annotationType": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                String name = manager.getNames().forMethod(GET_ANNOTATION_TYPE);
                name = "myjava_get_annotation_type";
                WasmCall call = new WasmCall(name, false);
                call.getArguments().add(arg);
                block.getBody().add(call);
                return block;
            }
            case "toString": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                String name = manager.getNames().forMethod(CLASS_TO_STRING);
                WasmCall call = new WasmCall(name, false);
                call.getArguments().add(arg);
                block.getBody().add(call);
                return block;
            }
        }
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        WasmExpression selfArg = manager.generate(invocation.getArguments().get(0));
        WasmInt32Constant propNameArg = new WasmInt32Constant(manager.getStringPool().getStringPointer(methodName));
        String name = manager.getNames().forMethod(GET_ANNOTATION_PROP);
        WasmCall call = new WasmCall(name, false);
        call.getArguments().add(selfArg);
        call.getArguments().add(propNameArg);
        block.getBody().add(call);
        return block;
    }
}

