/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.generate;

import com.antgroup.antchain.myjava.backend.wasm.binary.BinaryWriter;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataArray;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataPrimitives;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataStructure;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataValue;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmClassGenerator;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WasmStringPool {
    private WasmClassGenerator classGenerator;
    private BinaryWriter binaryWriter;
    private List<DataValue> poolStringObjects = new ArrayList<DataValue>();
    private Map<String, Integer> stringMap = new HashMap<String, Integer>();
    private DataStructure arrayHeaderType = new DataStructure(0, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.INT);
    private DataStructure stringType = new DataStructure(0, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.INT);
    private int stringPoolSize = 0;
    private Map<String, Integer> stringCharactersCache = new HashMap<String, Integer>();

    public WasmStringPool(WasmClassGenerator classGenerator, BinaryWriter binaryWriter) {
        this.classGenerator = classGenerator;
        this.binaryWriter = binaryWriter;
    }

    public int getStringPointer(String value) {
        Integer pointer = this.stringMap.get(value);
        if (pointer == null) {
            pointer = this.generateStringPointer(value);
            this.stringMap.put(value, pointer);
        }
        return pointer;
    }

    public int getCount() {
        return this.stringMap.size();
    }

    public int getStringPoolSize() {
        return this.stringPoolSize;
    }

    public int getStringCharacters(String value) {
        this.getStringPointer(value);
        return this.stringCharactersCache.getOrDefault(value, -1);
    }

    private int generateStringPointer(String value) {
        int memoryAddressBeforeStringAppend = this.binaryWriter.getAddress();
        DataArray charactersType = new DataArray(DataPrimitives.SHORT, value.length());
        DataStructure wrapperType = new DataStructure(0, this.arrayHeaderType, charactersType);
        DataValue wrapper = wrapperType.createValue();
        DataValue header = wrapper.getValue(0);
        DataValue characters = wrapper.getValue(1);
        int classPointer = this.classGenerator.getClassPointer(ValueType.arrayOf(ValueType.CHARACTER));
        header.setInt(0, classPointer >>> 3 | Integer.MIN_VALUE);
        header.setInt(2, value.length());
        for (int i = 0; i < value.length(); ++i) {
            characters.setShort(i, (short)value.charAt(i));
        }
        DataValue stringObject = this.stringType.createValue();
        int stringPointer = this.binaryWriter.append(stringObject);
        classPointer = this.classGenerator.getClassPointer(ValueType.object(String.class.getName()));
        stringObject.setInt(0, classPointer >>> 3 | Integer.MIN_VALUE);
        int charactersAddress = this.binaryWriter.append(wrapper);
        this.stringCharactersCache.put(value, charactersAddress);
        stringObject.setAddress(2, charactersAddress);
        this.poolStringObjects.add(stringObject);
        this.stringPoolSize += this.binaryWriter.getAddress() - memoryAddressBeforeStringAppend;
        return stringPointer;
    }

    public void resetStringClassReferences() {
        int stringClsPointer = this.classGenerator.getClassPointer(ValueType.object(String.class.getName()));
        for (DataValue stringObject : this.poolStringObjects) {
            stringObject.setInt(0, stringClsPointer >>> 3 | Integer.MIN_VALUE);
        }
    }
}

