/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.generate;

import com.antgroup.antchain.myjava.backend.lowlevel.generate.NameProvider;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmStringPool;
import com.antgroup.antchain.myjava.backend.wasm.generators.WasmMethodGenerator;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmFunction;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmModule;
import com.antgroup.antchain.myjava.diagnostics.Diagnostics;
import com.antgroup.antchain.myjava.interop.Import;
import com.antgroup.antchain.myjava.model.AnnotationReader;
import com.antgroup.antchain.myjava.model.AnnotationValue;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.FieldReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.classes.TagRegistry;
import com.antgroup.antchain.myjava.model.classes.VirtualTableProvider;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class WasmGenerationContext {
    private ClassReaderSource classSource;
    private WasmModule module;
    private Diagnostics diagnostics;
    private VirtualTableProvider vtableProvider;
    private TagRegistry tagRegistry;
    private WasmStringPool stringPool;
    public final NameProvider names;
    private Map<MethodReference, ImportedMethod> importedMethods = new HashMap<MethodReference, ImportedMethod>();
    private List<WasmIntrinsic> intrinsics = new ArrayList<WasmIntrinsic>();
    private List<WasmMethodGenerator> generators = new ArrayList<WasmMethodGenerator>();
    private Map<MethodReference, IntrinsicHolder> intrinsicCache = new HashMap<MethodReference, IntrinsicHolder>();
    private Map<MethodReference, GeneratorHolder> generatorCache = new HashMap<MethodReference, GeneratorHolder>();

    public WasmGenerationContext(ClassReaderSource classSource, WasmModule module, Diagnostics diagnostics, VirtualTableProvider vtableProvider, TagRegistry tagRegistry, WasmStringPool stringPool, NameProvider names) {
        this.classSource = classSource;
        this.module = module;
        this.diagnostics = diagnostics;
        this.vtableProvider = vtableProvider;
        this.tagRegistry = tagRegistry;
        this.stringPool = stringPool;
        this.names = names;
    }

    public void addIntrinsic(WasmIntrinsic intrinsic) {
        this.intrinsics.add(intrinsic);
    }

    public void addGenerator(WasmMethodGenerator generator) {
        this.generators.add(generator);
    }

    public WasmIntrinsic getIntrinsic(MethodReference method) {
        return this.intrinsicCache.computeIfAbsent((MethodReference)method, (Function<MethodReference, IntrinsicHolder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getIntrinsic$1(com.antgroup.antchain.myjava.model.MethodReference ), (Lcom/antgroup/antchain/myjava/model/MethodReference;)Lcom/antgroup/antchain/myjava/backend/wasm/generate/WasmGenerationContext$IntrinsicHolder;)((WasmGenerationContext)this)).value;
    }

    public WasmMethodGenerator getGenerator(MethodReference method) {
        return this.generatorCache.computeIfAbsent((MethodReference)method, (Function<MethodReference, GeneratorHolder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getGenerator$3(com.antgroup.antchain.myjava.model.MethodReference ), (Lcom/antgroup/antchain/myjava/model/MethodReference;)Lcom/antgroup/antchain/myjava/backend/wasm/generate/WasmGenerationContext$GeneratorHolder;)((WasmGenerationContext)this)).value;
    }

    public ImportedMethod getImportedMethod(MethodReference reference) {
        return this.importedMethods.computeIfAbsent(reference, ref -> {
            String module;
            ClassReader cls = this.classSource.get(ref.getClassName());
            if (cls == null) {
                return null;
            }
            MethodReader method = cls.getMethod(ref.getDescriptor());
            if (method == null) {
                return null;
            }
            AnnotationReader annotation = method.getAnnotations().get(Import.class.getName());
            if (annotation == null) {
                return null;
            }
            String name = annotation.getValue("name").getString();
            AnnotationValue moduleValue = annotation.getValue("module");
            String string = module = moduleValue != null ? moduleValue.getString() : null;
            if (module != null && module.isEmpty()) {
                module = null;
            }
            return new ImportedMethod(name, module);
        });
    }

    public WasmFunction getFunction(String name) {
        return this.module.getFunctions().get(name);
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public ValueType getFieldType(FieldReference fieldReference) {
        ClassReader cls = this.classSource.get(fieldReference.getClassName());
        FieldReader field = cls.getField(fieldReference.getFieldName());
        if (field == null) {
            throw new RuntimeException("can't find field " + fieldReference.getFieldName() + " in " + fieldReference.getClassName());
        }
        return field.getType();
    }

    public VirtualTableProvider getVirtualTableProvider() {
        return this.vtableProvider;
    }

    public TagRegistry getTagRegistry() {
        return this.tagRegistry;
    }

    public WasmStringPool getStringPool() {
        return this.stringPool;
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    private /* synthetic */ GeneratorHolder lambda$getGenerator$3(MethodReference key) {
        return new GeneratorHolder(this.generators.stream().filter(generator -> generator.isApplicable(key)).findFirst().orElse(null));
    }

    private /* synthetic */ IntrinsicHolder lambda$getIntrinsic$1(MethodReference key) {
        return new IntrinsicHolder(this.intrinsics.stream().filter(intrinsic -> intrinsic.isApplicable(this, key)).findFirst().orElse(null));
    }

    public static class ImportedMethod {
        public final String name;
        public final String module;

        ImportedMethod(String name, String module) {
            this.name = name;
            this.module = module;
        }
    }

    static class GeneratorHolder {
        WasmMethodGenerator value;

        GeneratorHolder(WasmMethodGenerator value) {
            this.value = value;
        }
    }

    static class IntrinsicHolder {
        WasmIntrinsic value;

        IntrinsicHolder(WasmIntrinsic value) {
            this.value = value;
        }
    }
}

