/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.generate;

import com.antgroup.antchain.myjava.dependency.AbstractDependencyListener;
import com.antgroup.antchain.myjava.dependency.DependencyAgent;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.interop.ContractInterface;
import com.antgroup.antchain.myjava.interop.DelegateTo;
import com.antgroup.antchain.myjava.interop.Export;
import com.antgroup.antchain.myjava.interop.LinkClass;
import com.antgroup.antchain.myjava.interop.LinkClasses;
import com.antgroup.antchain.myjava.model.AnnotationContainerReader;
import com.antgroup.antchain.myjava.model.AnnotationHolder;
import com.antgroup.antchain.myjava.model.AnnotationReader;
import com.antgroup.antchain.myjava.model.AnnotationValue;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassHolderTransformer;
import com.antgroup.antchain.myjava.model.ClassHolderTransformerContext;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.parsing.ClassRefsRenamer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WasmDependencyListener
extends AbstractDependencyListener
implements ClassHolderTransformer {
    public Set<MethodReader> linkClassStatic = new HashSet<MethodReader>();
    private ClassRefsRenamer renamer;

    public WasmDependencyListener(ClassRefsRenamer renamer) {
        this.renamer = renamer;
    }

    @Override
    public void classReached(DependencyAgent agent, String className) {
        ClassReader cls = agent.getClassSource().get(className);
        for (MethodReader methodReader : cls.getMethods()) {
            AnnotationReader exportAnnotation = methodReader.getAnnotations().get(Export.class.getName());
            if (exportAnnotation != null) {
                agent.linkMethod(methodReader.getReference()).use();
                continue;
            }
            AnnotationReader contractInterfaceAnnotation = methodReader.getAnnotations().get(ContractInterface.class.getName());
            if (contractInterfaceAnnotation == null) continue;
            agent.linkMethod(methodReader.getReference()).use();
        }
        List<AnnotationReader> linkClassAnnotations = this.getLinkClassAnnotations(cls.getAnnotations());
        for (AnnotationReader annotation : linkClassAnnotations) {
            this.dealLinkClass(agent, annotation);
        }
    }

    private List<AnnotationReader> getLinkClassAnnotations(AnnotationContainerReader annotationContainer) {
        ArrayList<AnnotationReader> result = new ArrayList<AnnotationReader>();
        AnnotationReader linkClassesAnnotation = annotationContainer.get(LinkClasses.class.getName());
        if (linkClassesAnnotation != null) {
            List<AnnotationValue> linkClassAnnotationList = linkClassesAnnotation.getValue("value").getList();
            for (AnnotationValue linkClassAnnotation : linkClassAnnotationList) {
                result.add(linkClassAnnotation.getAnnotation());
            }
        } else {
            AnnotationReader linkClassAnnotation = annotationContainer.get(LinkClass.class.getName());
            if (linkClassAnnotation != null) {
                result.add(linkClassAnnotation);
            }
        }
        return result;
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        AnnotationReader delegateAnnot = method.getMethod().getAnnotations().get(DelegateTo.class.getName());
        if (delegateAnnot != null) {
            String delegateMethodName = delegateAnnot.getValue("value").getString();
            ClassReader cls = agent.getClassSource().get(method.getReference().getClassName());
            for (MethodReader methodReader : cls.getMethods()) {
                if (!methodReader.getName().equals(delegateMethodName) || methodReader == method.getMethod()) continue;
                MethodDependency dep = agent.linkMethod(methodReader.getReference());
                dep.use();
                method.addLocationListener(dep::addLocation);
            }
        }
        List<AnnotationReader> linkClassAnnotations = this.getLinkClassAnnotations(method.getMethod().getAnnotations());
        for (AnnotationReader annotation : linkClassAnnotations) {
            this.dealLinkClass(agent, annotation);
        }
    }

    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        for (MethodHolder method : cls.getMethods()) {
            AnnotationHolder delegateAnnot = method.getAnnotations().get(DelegateTo.class.getName());
            if (delegateAnnot == null) continue;
            method.setProgram(null);
            method.getModifiers().add(ElementModifier.NATIVE);
        }
    }

    private void dealLinkClass(DependencyAgent agent, AnnotationReader annoReader) {
        if (annoReader.getValue("target") == null) {
            return;
        }
        String originLinkClassName = ((ValueType.Object)annoReader.getValue("target").getValue()).getClassName();
        annoReader = this.renamer != null && annoReader instanceof AnnotationHolder ? this.renamer.rename((AnnotationHolder)annoReader) : annoReader;
        ClassReader linkClassReader = agent.getClassSource().get(originLinkClassName);
        if (!(linkClassReader instanceof ClassHolder)) {
            throw new RuntimeException("LinkClass read class " + originLinkClassName + " not renameable");
        }
        linkClassReader = this.renamer.rename((ClassHolder)linkClassReader);
        Collection<? extends MethodReader> constructors = linkClassReader.getConstructors();
        for (MethodReader methodReader : constructors) {
            agent.linkMethod(methodReader.getReference()).use();
        }
        AnnotationValue methodField = annoReader.getValue("methods");
        List<AnnotationValue> list = methodField.getList();
        HashMap<String, Integer> linkMethodNameMap = new HashMap<String, Integer>();
        for (AnnotationValue annotationValue : list) {
            linkMethodNameMap.put(annotationValue.getString(), 0);
        }
        for (MethodReader methodReader : linkClassReader.getMethods()) {
            if (!linkMethodNameMap.containsKey(methodReader.getName())) continue;
            agent.linkMethod(methodReader.getReference()).use();
            if (!methodReader.hasModifier(ElementModifier.STATIC)) continue;
            this.linkClassStatic.add(methodReader);
        }
    }
}

