/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.generate;

import com.antgroup.antchain.myjava.backend.lowlevel.generate.NameProvider;
import com.antgroup.antchain.myjava.backend.wasm.binary.BinaryWriter;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataArray;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataPrimitives;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataStructure;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataType;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataValue;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmStringPool;
import com.antgroup.antchain.myjava.backend.wasm.javautils.ClassBinarySizeCalculator;
import com.antgroup.antchain.myjava.common.IntegerArray;
import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.Function;
import com.antgroup.antchain.myjava.interop.LinkClass;
import com.antgroup.antchain.myjava.interop.LinkClasses;
import com.antgroup.antchain.myjava.interop.NoInitClass;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.StaticInit;
import com.antgroup.antchain.myjava.interop.Structure;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.interop.WithAnnotations;
import com.antgroup.antchain.myjava.model.AccessLevel;
import com.antgroup.antchain.myjava.model.AnnotationContainerReader;
import com.antgroup.antchain.myjava.model.AnnotationReader;
import com.antgroup.antchain.myjava.model.AnnotationValue;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.FieldReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.GenericTypeParameter;
import com.antgroup.antchain.myjava.model.GenericValueType;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.analysis.ClassInitializerInfo;
import com.antgroup.antchain.myjava.model.analysis.ClassMetadataRequirements;
import com.antgroup.antchain.myjava.model.classes.TagRegistry;
import com.antgroup.antchain.myjava.model.classes.VirtualTable;
import com.antgroup.antchain.myjava.model.classes.VirtualTableEntry;
import com.antgroup.antchain.myjava.model.classes.VirtualTableProvider;
import com.antgroup.antchain.myjava.runtime.RuntimeClass;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;

public class WasmClassGenerator {
    private static final Logger log = LoggerFactory.getLogger(WasmClassGenerator.class);
    private ClassReaderSource processedClassSource;
    private ClassReaderSource classSource;
    public final NameProvider names;
    private Map<ValueType, ClassBinaryData> binaryDataMap = new LinkedHashMap<ValueType, ClassBinaryData>();
    private ClassBinarySizeCalculator classBinarySizeCalculator = new ClassBinarySizeCalculator();
    private BinaryWriter binaryWriter;
    private Map<MethodReference, Integer> functions = new HashMap<MethodReference, Integer>();
    private List<String> functionTable = new ArrayList<String>();
    private VirtualTableProvider vtableProvider;
    private TagRegistry tagRegistry;
    private WasmStringPool stringPool;
    private DataStructure objectStructure = new DataStructure(0, DataPrimitives.INT, DataPrimitives.ADDRESS);
    private DataStructure classStructure = new DataStructure(8, this.objectStructure, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.INT);
    private IntegerArray staticGcRoots = new IntegerArray(1);
    private int staticGcRootsAddress;
    private int classesAddress;
    private int classCount;
    private ClassMetadataRequirements metadataRequirements;
    private ClassInitializerInfo classInitializerInfo;
    private Map<ClassReader, DataValue> toUpdateConstructorsClassHeaders = new HashMap<ClassReader, DataValue>();
    private static final int CLASS_SIZE = 1;
    private static final int CLASS_FLAGS = 2;
    private static final int CLASS_TAG = 3;
    private static final int CLASS_CANARY = 4;
    private static final int CLASS_NAME = 5;
    private static final int CLASS_SIMPLE_NAME = 6;
    private static final int CLASS_CANONICAL_NAME = 7;
    private static final int CLASS_ITEM_TYPE = 8;
    private static final int CLASS_ARRAY_TYPE = 9;
    private static final int CLASS_DECLARING_CLASS = 10;
    private static final int CLASS_ENCLOSING_CLASS = 11;
    private static final int CLASS_IS_INSTANCE = 12;
    private static final int CLASS_INIT = 13;
    private static final int CLASS_PARENT = 14;
    private static final int CLASS_PARENT_PARAMETERIZED_TYPE = 15;
    private static final int CLASS_CONSTRUCTORS = 16;
    private static final int CLASS_PARAMETERIZED_INTERFACES_COUNT = 17;
    private static final int CLASS_PARAMETERIZED_INTERFACES_LAYOUT = 18;
    private static final int CLASS_ENUM_VALUES = 19;
    private static final int CLASS_LAYOUT = 20;
    private static final int CLASS_FIELD_NAMES_LAYOUT = 21;
    private static final int CLASS_ANNOTATIONS_LAYOUT = 22;
    private static final int CLASS_TYPE_VARIABLES_LAYOUT = 23;
    private static final int CLASS_VTABLE_SIZE = 24;
    private List<ClassAddressPlaceholder> classAddressPlaceholders = new ArrayList<ClassAddressPlaceholder>();
    private List<ClassParameterizedTypePlaceholder> classParameterizedTypePlaceholders = new ArrayList<ClassParameterizedTypePlaceholder>();
    private List<ParameterizedTypePlaceholder> parameterizedTypesPlaceholders = new ArrayList<ParameterizedTypePlaceholder>();
    private List<ClassArrayTypePlaceholder> classArrayTypePlaceholders = new ArrayList<ClassArrayTypePlaceholder>();
    private Map<String, Boolean> classLayoutCalculatedDone = new HashMap<String, Boolean>();

    public WasmClassGenerator(ClassReaderSource processedClassSource, ClassReaderSource classSource, VirtualTableProvider vtableProvider, TagRegistry tagRegistry, BinaryWriter binaryWriter, NameProvider names, ClassMetadataRequirements metadataRequirements, ClassInitializerInfo classInitializerInfo) {
        this.processedClassSource = processedClassSource;
        this.classSource = classSource;
        this.vtableProvider = vtableProvider;
        this.tagRegistry = tagRegistry;
        this.binaryWriter = binaryWriter;
        this.stringPool = new WasmStringPool(this, binaryWriter);
        this.names = names;
        this.metadataRequirements = metadataRequirements;
        this.classInitializerInfo = classInitializerInfo;
    }

    public WasmStringPool getStringPool() {
        return this.stringPool;
    }

    private void addClass(ValueType type) {
        if (this.binaryDataMap.containsKey(type)) {
            return;
        }
        ClassBinaryData binaryData = new ClassBinaryData();
        binaryData.type = type;
        this.binaryDataMap.put(type, binaryData);
        if (type instanceof ValueType.Primitive) {
            int size = 0;
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    size = 1;
                    break;
                }
                case SHORT: 
                case CHARACTER: {
                    size = 2;
                    break;
                }
                case INTEGER: 
                case FLOAT: {
                    size = 4;
                    break;
                }
                case LONG: 
                case DOUBLE: {
                    size = 8;
                }
            }
            binaryData.data = this.createPrimitiveClassData(size, type);
            binaryData.start = this.binaryWriter.append(binaryData.data);
        } else if (type == ValueType.VOID) {
            binaryData.data = this.createPrimitiveClassData(0, type);
            binaryData.start = this.binaryWriter.append(binaryData.data);
        } else if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            ClassReader cls = this.classSource.get(className);
            if (cls != null) {
                this.calculateLayout(cls, binaryData);
                if (binaryData.start >= 0) {
                    ArrayList<ToUpdateMethodInfoValue> toUpdateMethodInfoValues = new ArrayList<ToUpdateMethodInfoValue>();
                    binaryData.start = this.binaryWriter.append(this.createStructure(binaryData, toUpdateMethodInfoValues));
                    this.fixToUpdateMethodInfoValues(toUpdateMethodInfoValues);
                }
            }
        } else if (type instanceof ValueType.Array) {
            ValueType itemType = ((ValueType.Array)type).getItemType();
            this.addClass(itemType);
            ClassBinaryData itemBinaryData = this.binaryDataMap.get(itemType);
            VirtualTable vtable = this.vtableProvider.lookup("java.lang.Object");
            int vtableSize = vtable != null ? vtable.size() : 0;
            DataArray arrayType = new DataArray(DataPrimitives.INT, vtableSize);
            DataType methodInfoArrayType = this.getMethodInfoArrayType(vtableSize);
            DataValue wrapper = new DataStructure(0, this.classStructure, arrayType, methodInfoArrayType).createValue();
            ArrayList<ToUpdateMethodInfoValue> toUpdateMethodInfoValues = new ArrayList<ToUpdateMethodInfoValue>();
            if (vtableSize > 0) {
                this.fillVirtualTable(binaryData, vtable, wrapper.getValue(1), wrapper.getValue(2), toUpdateMethodInfoValues);
            }
            binaryData.size = 4;
            binaryData.data = wrapper.getValue(0);
            binaryData.data.setInt(1, 4);
            this.classAddressPlaceholders.add(new ClassAddressPlaceholder(itemBinaryData, binaryData.data.getValue(8)));
            binaryData.data.setAddress(8, itemBinaryData.start);
            binaryData.data.setInt(12, this.functionTable.size());
            binaryData.data.setInt(4, RuntimeClass.computeCanary(4, 0));
            this.functionTable.add(this.names.forSupertypeFunction(type));
            binaryData.data.setAddress(5, this.stringPool.getStringPointer(type.toString().replace('/', '.')));
            binaryData.data.setAddress(6, 0L);
            binaryData.data.setAddress(7, 0L);
            binaryData.data.setInt(13, -1);
            binaryData.data.setAddress(14, this.getClassPointer(ValueType.object("java.lang.Object")));
            binaryData.data.setAddress(15, 0L);
            binaryData.data.setInt(17, 0);
            binaryData.data.setAddress(18, 0L);
            binaryData.data.setAddress(16, 0L);
            binaryData.data.setInt(24, vtableSize);
            binaryData.start = this.binaryWriter.append(vtableSize > 0 ? wrapper : binaryData.data);
            if (itemBinaryData.data != null) {
                itemBinaryData.data.setAddress(9, binaryData.start);
            } else {
                this.classArrayTypePlaceholders.add(new ClassArrayTypePlaceholder(binaryData, itemBinaryData));
            }
            this.fixToUpdateMethodInfoValues(toUpdateMethodInfoValues);
        }
    }

    private DataValue createPrimitiveClassData(int size, ValueType type) {
        String name;
        DataValue value = this.classStructure.createValue();
        value.setInt(1, size);
        value.setInt(2, 2);
        value.setInt(12, this.functionTable.size());
        value.setAddress(6, 0L);
        value.setAddress(7, 0L);
        value.setInt(13, -1);
        this.functionTable.add(this.names.forSupertypeFunction(type));
        if (type == ValueType.VOID) {
            name = "void";
        } else {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    name = "boolean";
                    break;
                }
                case BYTE: {
                    name = "byte";
                    break;
                }
                case SHORT: {
                    name = "short";
                    break;
                }
                case CHARACTER: {
                    name = "char";
                    break;
                }
                case INTEGER: {
                    name = "int";
                    break;
                }
                case LONG: {
                    name = "long";
                    break;
                }
                case FLOAT: {
                    name = "float";
                    break;
                }
                case DOUBLE: {
                    name = "double";
                    break;
                }
                default: {
                    name = "";
                }
            }
        }
        value.setAddress(5, this.stringPool.getStringPointer(name));
        return value;
    }

    public List<String> getFunctionTable() {
        return this.functionTable;
    }

    private DataType getMethodInfoArrayType(int size) {
        DataStructure methodInfoType = new DataStructure(0, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.INT, DataPrimitives.INT);
        return new DataArray(methodInfoType, size);
    }

    private boolean requireAnnotationMetadata(ClassReader cls) {
        if (cls == null) {
            return false;
        }
        if (!this.requireClassMetadata(cls)) {
            return false;
        }
        for (AnnotationReader annotationReader : cls.getAnnotations().all()) {
            if (!annotationReader.getType().equals(WithAnnotations.class.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean requireClassMetadata(ClassReader cls) {
        if (cls == null) {
            return false;
        }
        for (AnnotationReader annotationReader : cls.getAnnotations().all()) {
            if (!annotationReader.getType().equals(NoMetadata.class.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean requireMethodMetadata(ClassReader cls, MethodReader method) {
        if (!this.requireClassMetadata(cls)) {
            return false;
        }
        for (AnnotationReader annotationReader : method.getAnnotations().all()) {
            if (!annotationReader.getType().equals(NoMetadata.class.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean requireFieldMetadata(ClassReader cls, FieldReader field) {
        if (!this.requireClassMetadata(cls)) {
            return false;
        }
        for (AnnotationReader annotationReader : field.getAnnotations().all()) {
            if (!annotationReader.getType().equals(NoMetadata.class.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean isIgnoredAnnotationType(String annotationTypeName) {
        Set ignoredAnnotationTypes = Arrays.asList(Override.class, Deprecated.class, SuppressWarnings.class, Unmanaged.class, StaticInit.class, NoMetadata.class, WithAnnotations.class, NoInitClass.class, LinkClass.class, LinkClasses.class).stream().map(t -> t.getName()).collect(Collectors.toSet());
        return ignoredAnnotationTypes.contains(annotationTypeName);
    }

    private int createTypeVariablesLayout(GenericTypeParameter[] typeParameters, ClassReader cls, ClassBinaryData binaryData) {
        int typeParametersCount = typeParameters.length;
        if (typeParametersCount < 1) {
            return 0;
        }
        if (typeParametersCount > 128) {
            throw new IllegalArgumentException("too many type variables count in class " + cls.getName());
        }
        DataStructure typeVariablesArrayWithSizeType = new DataStructure(0, DataPrimitives.INT, DataPrimitives.ADDRESS);
        DataValue typeVariablesArrayWithSize = ((DataType)typeVariablesArrayWithSizeType).createValue();
        typeVariablesArrayWithSize.setInt(0, typeParametersCount);
        DataStructure typeVariableItemType = new DataStructure(0, DataPrimitives.ADDRESS);
        DataArray typeVariableArrayType = new DataArray(typeVariableItemType, typeParametersCount);
        DataValue typeVariableArray = ((DataType)typeVariableArrayType).createValue();
        for (int i = 0; i < typeParametersCount; ++i) {
            GenericTypeParameter typeParameter = typeParameters[i];
            DataValue typeVariableItem = typeVariableArray.getValue(i);
            typeVariableItem.setAddress(0, binaryData.typeVariableNamesLayout.getOrDefault(typeParameter.getName(), 0));
        }
        typeVariablesArrayWithSize.setAddress(1, this.binaryWriter.append(typeVariableArray));
        return this.binaryWriter.append(typeVariablesArrayWithSize);
    }

    private int createAnnotationsLayout(AnnotationContainerReader annotationContainer, ClassReader cls) {
        ArrayList<AnnotationInfoToGenerateWasm> annotationInfoToGenerateWasms = new ArrayList<AnnotationInfoToGenerateWasm>();
        for (AnnotationReader annotationReader : annotationContainer.all()) {
            ClassReader annotationCls;
            String annotationType = annotationReader.getType();
            if (this.isIgnoredAnnotationType(annotationType)) continue;
            ValueType.Object annoValueType = ValueType.object(annotationType);
            this.addClass(annoValueType);
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<AnnotationValue> fieldValues = new ArrayList<AnnotationValue>();
            ClassReader classReader = annotationCls = this.binaryDataMap.get(annoValueType) != null ? this.binaryDataMap.get((Object)annoValueType).cls : null;
            if (annotationCls == null) continue;
            List<String> annotationFieldNames = annotationCls.getMethods().stream().map(x -> x.getName()).collect(Collectors.toList());
            annotationFieldNames.forEach(f -> {
                MethodReader annoFieldMethod;
                AnnotationValue value = annotation.getValue((String)f);
                if (value == null && annotationCls != null && (annoFieldMethod = (MethodReader)annotationCls.getMethods().stream().filter(x -> x.getName().equals(f)).findFirst().orElse(null)) != null && annoFieldMethod.getAnnotationDefault() != null) {
                    value = annoFieldMethod.getAnnotationDefault();
                }
                fieldNames.add((String)f);
                fieldValues.add(value);
            });
            annotationInfoToGenerateWasms.add(new AnnotationInfoToGenerateWasm(annotationType, fieldNames, fieldValues));
        }
        int annotationsCount = annotationInfoToGenerateWasms.size();
        if (annotationsCount < 1) {
            return 0;
        }
        if (annotationsCount > 0) {
            if (annotationsCount > 128) {
                throw new IllegalArgumentException("too many annotations count in class " + cls.getName());
            }
            DataStructure dataStructure = new DataStructure(0, DataPrimitives.INT, DataPrimitives.INT);
            DataValue annotationArrayWithSizeValue = ((DataType)dataStructure).createValue();
            annotationArrayWithSizeValue.setInt(0, annotationsCount);
            DataStructure annotationItemType = new DataStructure(0, DataPrimitives.ADDRESS, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS);
            DataArray annotationArrayType = new DataArray(annotationItemType, annotationsCount);
            DataValue annotationArray = ((DataType)annotationArrayType).createValue();
            for (int i = 0; i < annotationsCount; ++i) {
                AnnotationInfoToGenerateWasm annotationInfo = (AnnotationInfoToGenerateWasm)annotationInfoToGenerateWasms.get(i);
                DataValue annotationItemValue = annotationArray.getValue(i);
                DataValue classAddrPlaceholder = annotationItemValue.getValue(0);
                classAddrPlaceholder.setAddress(0, 0L);
                ValueType.Object annotationType = ValueType.object(annotationInfo.annotationClassName);
                this.addClass(annotationType);
                ClassBinaryData annotationTypeBinaryData = this.binaryDataMap.get(annotationType);
                this.classAddressPlaceholders.add(new ClassAddressPlaceholder(annotationTypeBinaryData, classAddrPlaceholder));
                int annotationFieldsCount = annotationInfo.fieldNames.size();
                annotationItemValue.setInt(1, annotationFieldsCount);
                DataArray annotationFieldNamesArrayType = new DataArray(DataPrimitives.INT, annotationFieldsCount);
                DataValue annotationFieldNamesArray = ((DataType)annotationFieldNamesArrayType).createValue();
                for (int k = 0; k < annotationFieldsCount; ++k) {
                    String fieldName = annotationInfo.fieldNames.get(k);
                    annotationFieldNamesArray.setInt(k, this.stringPool.getStringPointer(fieldName));
                }
                annotationItemValue.setAddress(2, this.binaryWriter.append(annotationFieldNamesArray));
                DataArray annotationFieldValuesArrayType = new DataArray(DataPrimitives.INT, annotationFieldsCount);
                DataValue annotationFieldValuesArray = ((DataType)annotationFieldValuesArrayType).createValue();
                for (int k = 0; k < annotationFieldsCount; ++k) {
                    AnnotationValue annotationValue = annotationInfo.fieldValues.get(k);
                    if (annotationValue == null) {
                        throw new RuntimeException("not supported null annotation value of key " + k + " in annotation " + annotationInfo.annotationClassName);
                    }
                    int valueInt = 0;
                    switch (annotationValue.getType()) {
                        case 0: {
                            valueInt = annotationValue.getBoolean() ? 1 : 0;
                            break;
                        }
                        case 1: {
                            valueInt = annotationValue.getByte();
                            break;
                        }
                        case 12: {
                            valueInt = annotationValue.getChar();
                            break;
                        }
                        case 2: {
                            valueInt = annotationValue.getShort();
                            break;
                        }
                        case 3: {
                            valueInt = annotationValue.getInt();
                            break;
                        }
                        case 7: {
                            valueInt = this.stringPool.getStringPointer(annotationValue.getString());
                            break;
                        }
                        default: {
                            valueInt = 0;
                            new RuntimeException("not supported annotation value type " + annotationValue.getType() + " for " + annotationInfo.annotationClassName).printStackTrace();
                        }
                    }
                    annotationFieldValuesArray.setInt(k, valueInt);
                }
                annotationItemValue.setAddress(3, this.binaryWriter.append(annotationFieldValuesArray));
            }
            annotationArrayWithSizeValue.setInt(1, this.binaryWriter.append(annotationArray));
            return this.binaryWriter.append(annotationArrayWithSizeValue);
        }
        return 0;
    }

    private DataValue createStructure(ClassBinaryData binaryData, List<ToUpdateMethodInfoValue> toUpdateMethodInfoValues) {
        List<FieldReference> fields;
        DataValue header;
        int binaryWriterAddressBeforeCreateStructure = this.binaryWriter.getAddress();
        String parent = binaryData.cls.getParent();
        int parentPtr = !binaryData.isInferface && parent != null ? this.getClassPointer(ValueType.object(binaryData.cls.getParent())) : 0;
        String name = ((ValueType.Object)binaryData.type).getClassName();
        ClassMetadataRequirements.Info requirements = this.metadataRequirements.getInfo(name);
        int flags = 0;
        VirtualTable vtable = this.vtableProvider.lookup(name);
        int vtableSize = vtable != null ? vtable.size() : 0;
        DataArray arrayType = new DataArray(DataPrimitives.INT, vtableSize);
        DataType methodInfoArrayType = this.getMethodInfoArrayType(vtableSize);
        DataValue wrapper = new DataStructure(0, this.classStructure, arrayType, methodInfoArrayType).createValue();
        DataValue array = wrapper.getValue(1);
        DataValue methodInfoArray = wrapper.getValue(2);
        binaryData.data = header = wrapper.getValue(0);
        int occupiedSize = binaryData.size;
        if ((occupiedSize & 3) != 0) {
            occupiedSize = occupiedSize >> 2 << 3;
        }
        header.setInt(1, occupiedSize);
        List<TagRegistry.Range> ranges = this.tagRegistry.getRanges(name);
        int tag = ranges.stream().mapToInt(range -> range.lower).min().orElse(0);
        header.setInt(3, tag);
        header.setInt(4, RuntimeClass.computeCanary(occupiedSize, tag));
        boolean requireName = true;
        int nameAddress = requireName ? this.stringPool.getStringPointer(name) : 0;
        header.setAddress(5, nameAddress);
        header.setInt(12, this.functionTable.size());
        this.functionTable.add(this.names.forSupertypeFunction(ValueType.object(name)));
        header.setAddress(14, parentPtr);
        ClassReader cls = this.processedClassSource.get(name);
        if (cls != null) {
            if (cls.getSimpleName() != null && requirements.simpleName()) {
                header.setAddress(6, this.stringPool.getStringPointer(cls.getSimpleName()));
            }
            if (cls.getGenericParent() != null || cls.getGenericInterfaces() != null && cls.getGenericInterfaces().size() > 0) {
                this.classParameterizedTypePlaceholders.add(new ClassParameterizedTypePlaceholder(binaryData));
            }
            if (cls.getOwnerName() != null && this.processedClassSource.get(cls.getOwnerName()) != null && requirements.enclosingClass()) {
                ValueType.Object enclosingClassValueType = ValueType.object(cls.getOwnerName());
                header.setAddress(11, this.getClassPointer(enclosingClassValueType));
                if (this.binaryDataMap.get(enclosingClassValueType) != null) {
                    this.classAddressPlaceholders.add(new ClassAddressPlaceholder(this.binaryDataMap.get(enclosingClassValueType), header.getValue(11)));
                }
            }
            if (cls.getDeclaringClassName() != null && this.processedClassSource.get(cls.getDeclaringClassName()) != null && requirements.declaringClass()) {
                ValueType.Object declaringClassValueType = ValueType.object(cls.getDeclaringClassName());
                header.setAddress(10, this.getClassPointer(declaringClassValueType));
                if (this.binaryDataMap.get(declaringClassValueType) != null) {
                    this.classAddressPlaceholders.add(new ClassAddressPlaceholder(this.binaryDataMap.get(declaringClassValueType), header.getValue(10)));
                }
            }
            header.setAddress(7, 0L);
        }
        header.setInt(24, vtableSize);
        if (vtable != null) {
            this.fillVirtualTable(binaryData, vtable, array, methodInfoArray, toUpdateMethodInfoValues);
        }
        if (!(fields = this.getReferenceFields(binaryData.cls)).isEmpty()) {
            DataValue layoutSize = DataPrimitives.SHORT.createValue();
            layoutSize.setShort(0, (short)fields.size());
            header.setAddress(20, this.binaryWriter.append(layoutSize));
            for (FieldReference field : fields) {
                DataValue layoutElement = DataPrimitives.SHORT.createValue();
                int offset = binaryData.fieldLayout.get(field.getFieldName());
                layoutElement.setShort(0, (short)offset);
                this.binaryWriter.append(layoutElement);
            }
            List allInClassLayoutFields = binaryData.cls.getFields().stream().filter(f -> !f.hasModifier(ElementModifier.STATIC)).collect(Collectors.toList());
            DataValue layoutSize2 = DataPrimitives.INT.createValue();
            int toPutMetaFieldsCount = allInClassLayoutFields.size();
            if (!this.requireClassMetadata(binaryData.cls)) {
                toPutMetaFieldsCount = 0;
            }
            layoutSize2.setInt(0, toPutMetaFieldsCount);
            header.setAddress(21, this.binaryWriter.append(layoutSize2));
            if (toPutMetaFieldsCount > 0) {
                for (FieldReader field : allInClassLayoutFields) {
                    String fieldName = field.getName();
                    AccessLevel fieldAccessLevel = field.getLevel();
                    int fieldAccessLevelInt = fieldAccessLevel.ordinal();
                    int fieldModifiers = ElementModifier.pack(field.readModifiers());
                    DataStructure fieldItemDataStructure = new DataStructure(2, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.INT, DataPrimitives.INT);
                    DataValue fieldItemDataValue = fieldItemDataStructure.createValue();
                    int fieldNameOffset = binaryData.fieldNamesLayout.get(fieldName);
                    fieldItemDataValue.setInt(0, fieldNameOffset);
                    int offset = binaryData.fieldLayout.get(fieldName);
                    fieldItemDataValue.setInt(1, offset);
                    fieldItemDataValue.setAddress(2, 0L);
                    int fieldAnnotationsLayoutAddr = binaryData.fieldAnnotationsLayouts.getOrDefault(field.getName(), 0);
                    fieldItemDataValue.setAddress(3, fieldAnnotationsLayoutAddr);
                    fieldItemDataValue.setInt(5, fieldAccessLevelInt);
                    fieldItemDataValue.setInt(6, fieldModifiers);
                    this.binaryWriter.append(fieldItemDataValue);
                    this.classAddressPlaceholders.add(new ClassAddressPlaceholder(this.binaryDataMap.get(field.getType()), fieldItemDataValue.getValue(2)));
                    if (!(field.getGenericType() instanceof GenericValueType.Object)) continue;
                    this.parameterizedTypesPlaceholders.add(new ParameterizedTypePlaceholder((GenericValueType.Object)field.getGenericType(), fieldItemDataValue.getValue(4)));
                }
            }
        }
        if (cls != null && this.requireAnnotationMetadata(cls)) {
            int annotationsLayout = this.createAnnotationsLayout(cls.getAnnotations(), cls);
            header.setAddress(22, annotationsLayout);
        }
        if (cls != null && this.requireClassMetadata(cls) && cls.getGenericParameters() != null) {
            int typeVariablesLayout = this.createTypeVariablesLayout(cls.getGenericParameters(), cls, binaryData);
            header.setAddress(23, typeVariablesLayout);
        }
        for (FieldReference field : this.getStaticReferenceFields(binaryData.cls)) {
            this.staticGcRoots.add(binaryData.fieldLayout.get(field.getFieldName()));
        }
        if (cls != null) {
            if (cls.hasModifier(ElementModifier.ENUM)) {
                header.setAddress(19, this.generateEnumValues(cls, binaryData));
                flags |= 4;
            }
            if (cls.hasModifier(ElementModifier.SYNTHETIC)) {
                flags |= 0x400;
            }
            if (cls.hasModifier(ElementModifier.INTERFACE)) {
                flags |= 8;
            }
            if (cls.hasModifier(ElementModifier.ANNOTATION)) {
                flags |= 0x10;
            }
        }
        if (cls != null) {
            header.setAddress(16, 0L);
            this.toUpdateConstructorsClassHeaders.put(cls, header);
        } else {
            header.setAddress(16, 0L);
        }
        if (cls != null && binaryData.start >= 0 && cls.getMethod(new MethodDescriptor("<clinit>", ValueType.VOID)) != null && this.classInitializerInfo.isDynamicInitializer(name)) {
            header.setInt(13, this.functionTable.size());
            this.functionTable.add(this.names.forClassInitializer(name));
        } else {
            header.setInt(13, -1);
        }
        header.setInt(2, flags);
        if (binaryData.cls != null) {
            int classOtherSize = this.binaryWriter.getAddress() - binaryWriterAddressBeforeCreateStructure;
            this.classBinarySizeCalculator.addSize(binaryData.cls.getName(), classOtherSize);
            this.classBinarySizeCalculator.addSize(binaryData.cls.getName(), BinaryWriter.getDataTypeOffset((vtable != null ? wrapper : header).getType(), 0));
        }
        return vtable != null ? wrapper : header;
    }

    private int generateEnumValues(ClassReader cls, ClassBinaryData binaryData) {
        FieldReader[] fields = (FieldReader[])cls.getFields().stream().filter(field -> field.hasModifier(ElementModifier.ENUM)).toArray(FieldReader[]::new);
        DataValue sizeValue = DataPrimitives.INT.createValue();
        sizeValue.setInt(0, fields.length);
        int valuesAddress = this.binaryWriter.append(sizeValue);
        for (FieldReader field2 : fields) {
            DataValue fieldDataValue = DataPrimitives.ADDRESS.createValue();
            fieldDataValue.setAddress(0, binaryData.fieldLayout.get(field2.getName()));
            this.binaryWriter.append(fieldDataValue);
        }
        return valuesAddress;
    }

    private List<FieldReference> getReferenceFields(ClassReader cls) {
        return cls.getFields().stream().filter(field -> !field.hasModifier(ElementModifier.STATIC)).filter(field -> this.isReferenceType(field.getType())).filter(field -> !field.getOwnerName().equals("java.lang.Object") && !field.getName().equals("monitor")).map(field -> field.getReference()).collect(Collectors.toList());
    }

    private List<FieldReference> getStaticReferenceFields(ClassReader cls) {
        return cls.getFields().stream().filter(field -> field.hasModifier(ElementModifier.STATIC)).filter(field -> this.isReferenceType(field.getType())).map(field -> field.getReference()).collect(Collectors.toList());
    }

    private boolean isReferenceType(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            return false;
        }
        if (type instanceof ValueType.Object) {
            ClassReader cls = this.classSource.get(((ValueType.Object)type).getClassName());
            if (cls == null) {
                return true;
            }
            if (cls.getName().equals(Address.class.getName())) {
                return false;
            }
            while (cls != null) {
                if (cls.getName().equals(Structure.class.getName()) || cls.getName().equals(Function.class.getName())) {
                    return false;
                }
                if (cls.getParent() == null) {
                    return true;
                }
                cls = this.classSource.get(cls.getParent());
            }
            return true;
        }
        return true;
    }

    private void fixToUpdateMethodInfoValues(List<ToUpdateMethodInfoValue> toUpdateMethodInfoValues) {
        for (ToUpdateMethodInfoValue toUpdateMethodInfoValue : toUpdateMethodInfoValues) {
            toUpdateMethodInfoValue.methodParamTypeNamesArrayInClass.setInt(0, this.binaryWriter.append(toUpdateMethodInfoValue.methodParamTypeNamesArray));
        }
    }

    private void fillVirtualTable(ClassBinaryData binaryData, VirtualTable vtable, DataValue array, DataValue methodInfoArray, List<ToUpdateMethodInfoValue> toUpdateMethodInfoValues) {
        int index = 0;
        ArrayList<VirtualTable> tables = new ArrayList<VirtualTable>();
        for (VirtualTable vt = vtable; vt != null; vt = vt.getParent()) {
            tables.add(vt);
        }
        for (int i = tables.size() - 1; i >= 0; --i) {
            for (MethodDescriptor methodDescriptor : ((VirtualTable)tables.get(i)).getMethods()) {
                int methodIndex = -1;
                MethodReader methodReader = null;
                if (methodDescriptor != null) {
                    methodReader = this.classSource.resolve(new MethodReference(((VirtualTable)tables.get(i)).getClassName(), methodDescriptor));
                    VirtualTableEntry entry = vtable.getEntry(methodDescriptor);
                    if (entry != null) {
                        methodIndex = this.functions.computeIfAbsent(entry.getImplementor(), implementor -> {
                            int result = this.functionTable.size();
                            this.functionTable.add(this.names.forMethod((MethodReference)implementor));
                            return result;
                        });
                    }
                }
                int curIndex = index++;
                array.setInt(curIndex, methodIndex);
                DataValue methodInfoDataValue = methodInfoArray.getValue(curIndex);
                if (methodIndex >= 0 && this.requireClassMetadata(binaryData.cls)) {
                    int layout;
                    methodInfoDataValue.setInt(0, binaryData.methodNamesLayout.getOrDefault(methodDescriptor.getName(), 0));
                    methodInfoDataValue.setAddress(1, 0L);
                    this.classAddressPlaceholders.add(new ClassAddressPlaceholder(this.binaryDataMap.get(methodDescriptor.getResultType()), methodInfoDataValue.getValue(1)));
                    ValueType[] paramTypes = methodDescriptor.getParameterTypes();
                    methodInfoDataValue.setInt(2, paramTypes.length);
                    DataArray methodParamTypeNamesArrayType = new DataArray(DataPrimitives.INT, paramTypes.length);
                    DataValue methodParamTypeNamesArray = ((DataType)methodParamTypeNamesArrayType).createValue();
                    for (int j = 0; j < paramTypes.length; ++j) {
                        ValueType paramType = paramTypes[j];
                        String paramTypeName = paramType.toString();
                        int paramTypeNameAddress = this.stringPool.getStringPointer(paramTypeName);
                        methodParamTypeNamesArray.setInt(j, paramTypeNameAddress);
                    }
                    methodInfoDataValue.setInt(3, 0);
                    toUpdateMethodInfoValues.add(new ToUpdateMethodInfoValue(methodInfoDataValue.getValue(3), methodParamTypeNamesArray));
                    if (this.requireAnnotationMetadata(binaryData.cls)) {
                        layout = binaryData.methodsAnnotationLayouts.getOrDefault(methodDescriptor, 0);
                        methodInfoDataValue.setInt(4, layout);
                    }
                    layout = binaryData.methodsTypeParametersLayouts.getOrDefault(methodDescriptor, 0);
                    methodInfoDataValue.setAddress(5, layout);
                    int methodAccessLevelInt = 0;
                    int methodModifiers = 0;
                    if (methodReader != null) {
                        AccessLevel methodAccessLevel = methodReader.getLevel();
                        methodAccessLevelInt = methodAccessLevel.ordinal();
                        methodModifiers = ElementModifier.pack(methodReader.readModifiers());
                    } else {
                        log.warn("method reader not found for {} {}", (Object)((VirtualTable)tables.get(i)).getClassName(), (Object)methodDescriptor);
                    }
                    methodInfoDataValue.setInt(6, methodAccessLevelInt);
                    methodInfoDataValue.setInt(7, methodModifiers);
                    continue;
                }
                methodInfoDataValue.setInt(0, 0);
                methodInfoDataValue.setAddress(1, 0L);
                methodInfoDataValue.setInt(2, 0);
                methodInfoDataValue.setInt(3, 0);
                methodInfoDataValue.setInt(4, 0);
                methodInfoDataValue.setAddress(5, 0L);
                methodInfoDataValue.setInt(6, 0);
                methodInfoDataValue.setInt(7, 0);
            }
        }
    }

    public Collection<ValueType> getRegisteredClasses() {
        return this.binaryDataMap.keySet();
    }

    public int getClassPointer(ValueType type) {
        this.addClass(type);
        ClassBinaryData data = this.binaryDataMap.get(type);
        return data.start;
    }

    public int getFieldOffset(FieldReference field) {
        ValueType.Object type = ValueType.object(field.getClassName());
        this.addClass(type);
        ClassBinaryData data = this.binaryDataMap.get(type);
        if (!data.fieldLayout.containsKey(field.getFieldName())) {
            throw new RuntimeException("getFieldOffset of not exist field " + field);
        }
        return data.fieldLayout.get(field.getFieldName());
    }

    public int getClassSize(String className) {
        ValueType.Object type = ValueType.object(className);
        this.addClass(type);
        ClassBinaryData data = this.binaryDataMap.get(type);
        return data.size;
    }

    public int getClassAlignment(String className) {
        ValueType.Object type = ValueType.object(className);
        this.addClass(type);
        ClassBinaryData data = this.binaryDataMap.get(type);
        return data.alignment;
    }

    public boolean isStructure(String className) {
        ValueType.Object type = ValueType.object(className);
        this.addClass(type);
        ClassBinaryData data = this.binaryDataMap.get(type);
        return data.start < 0;
    }

    public boolean isFunctionClass(String className) {
        ValueType.Object type = ValueType.object(className);
        this.addClass(type);
        return this.binaryDataMap.get((Object)type).function;
    }

    private void calculateLayout(ClassReader cls, ClassBinaryData data) {
        if (this.classLayoutCalculatedDone.containsKey(cls.getName())) {
            return;
        }
        if (cls.getName().equals(Structure.class.getName()) || cls.getName().equals(Address.class.getName())) {
            data.size = 0;
            data.start = -1;
            this.classLayoutCalculatedDone.put(cls.getName(), true);
            return;
        }
        if (cls.getName().equals(Function.class.getName())) {
            data.size = 0;
            data.start = -1;
            data.function = true;
            this.classLayoutCalculatedDone.put(cls.getName(), true);
            return;
        }
        if (cls.getParent() != null) {
            ValueType.Object parentClassType = ValueType.object(cls.getParent());
            this.addClass(parentClassType);
            if (this.binaryDataMap.get(parentClassType) != null) {
                this.calculateLayout(this.classSource.get(cls.getParent()), this.binaryDataMap.get(parentClassType));
            }
            ClassBinaryData parentData = this.binaryDataMap.get(ValueType.object(cls.getParent()));
            data.size = parentData.size;
            data.alignment = parentData.alignment;
            if (parentData.start == -1) {
                data.start = -1;
            }
            if (parentData.function) {
                data.function = true;
                return;
            }
            ClassReader classReader = this.classSource.get(cls.getParent());
            if (classReader != null && classReader.hasModifier(ElementModifier.ABSTRACT) && parentData.size == 0) {
                data.size = 4;
                data.alignment = 4;
            }
            if (parentData.size == 0 && !new HashSet<String>(Arrays.asList(Structure.class.getName(), Address.class.getName(), Function.class.getName())).contains(cls.getParent())) {
                throw new RuntimeException("parent class " + cls.getParent() + " of class " + cls.getName() + " has 0 size when calculateLayout");
            }
        } else {
            data.size = 4;
            data.alignment = 4;
        }
        data.isInferface = cls.hasModifier(ElementModifier.INTERFACE);
        data.cls = cls;
        int binaryWriterAddressBeforeAnalyzeClassMeta = this.binaryWriter.getAddress();
        for (FieldReader fieldReader : cls.getFields()) {
            int desiredAlignment = WasmClassGenerator.getTypeSize(fieldReader.getType());
            if (fieldReader.hasModifier(ElementModifier.STATIC)) {
                DataType type = WasmClassGenerator.asDataType(fieldReader.getType());
                DataValue value = type.createValue();
                if (fieldReader.getInitialValue() != null) {
                    this.setInitialValue(fieldReader.getType(), value, fieldReader.getInitialValue());
                }
                data.fieldLayout.put(fieldReader.getName(), this.binaryWriter.append(value));
            } else {
                int offset = WasmClassGenerator.align(data.size, desiredAlignment);
                data.fieldLayout.put(fieldReader.getName(), offset);
                data.size = offset + desiredAlignment;
            }
            if (data.alignment != 0) continue;
            data.alignment = desiredAlignment;
        }
        if (this.requireClassMetadata(cls)) {
            if (cls.getGenericParameters() != null) {
                for (GenericTypeParameter typeParameter : cls.getGenericParameters()) {
                    data.typeVariableNamesLayout.put(typeParameter.getName(), this.stringPool.getStringPointer(typeParameter.getName()));
                }
            }
            for (MethodReader methodReader : cls.getMethods()) {
                if (methodReader.getTypeParameters() == null) continue;
                for (GenericTypeParameter typeParameter : methodReader.getTypeParameters()) {
                    data.typeVariableNamesLayout.put(typeParameter.getName(), this.stringPool.getStringPointer(typeParameter.getName()));
                }
            }
            for (MethodReader methodReader : cls.getConstructors()) {
                if (methodReader.getTypeParameters() == null) continue;
                for (GenericTypeParameter typeParameter : methodReader.getTypeParameters()) {
                    data.typeVariableNamesLayout.put(typeParameter.getName(), this.stringPool.getStringPointer(typeParameter.getName()));
                }
            }
            for (FieldReader fieldReader : cls.getFields()) {
                GenericValueType.Object fieldGenericType;
                data.fieldNamesLayout.put(fieldReader.getName(), this.stringPool.getStringPointer(fieldReader.getName()));
                this.addClass(fieldReader.getType());
                if (fieldReader.getGenericType() instanceof GenericValueType.Object && (fieldGenericType = (GenericValueType.Object)fieldReader.getGenericType()).getArguments().length > 0) {
                    for (GenericValueType.Argument item : fieldGenericType.getArguments()) {
                        GenericValueType.Object itemObj;
                        if (item.getValue() == null || !(item.getValue() instanceof GenericValueType.Object) || this.classSource.get((itemObj = (GenericValueType.Object)item.getValue()).getClassName()) == null) continue;
                        this.addClass(ValueType.object(itemObj.getClassName()));
                    }
                }
                if (!this.requireAnnotationMetadata(cls)) continue;
                int layout = this.createAnnotationsLayout(fieldReader.getAnnotations(), cls);
                data.fieldAnnotationsLayouts.put(fieldReader.getName(), layout);
            }
            for (MethodReader methodReader : cls.getMethods()) {
                data.methodNamesLayout.put(methodReader.getName(), this.stringPool.getStringPointer(methodReader.getName()));
                if (this.requireMethodMetadata(cls, methodReader)) {
                    this.addClass(methodReader.getResultType());
                }
                if (this.requireAnnotationMetadata(cls)) {
                    int layout = this.createAnnotationsLayout(methodReader.getAnnotations(), cls);
                    data.methodsAnnotationLayouts.put(methodReader.getDescriptor(), layout);
                }
                if (!this.requireMethodMetadata(cls, methodReader)) continue;
                int typeVariablesLayout = this.createTypeVariablesLayout(methodReader.getTypeParameters(), cls, data);
                data.methodsTypeParametersLayouts.put(methodReader.getDescriptor(), typeVariablesLayout);
            }
            for (String string : cls.getInterfaces()) {
                this.addClass(ValueType.object(string));
            }
            for (MethodReader methodReader : cls.getConstructors()) {
                if (this.requireAnnotationMetadata(cls)) {
                    int layout = this.createAnnotationsLayout(methodReader.getAnnotations(), cls);
                    data.constructorsAnnotationLayouts.put(methodReader.getDescriptor(), layout);
                }
                if (!this.requireMethodMetadata(cls, methodReader)) continue;
                int typeVariablesLayout = this.createTypeVariablesLayout(methodReader.getTypeParameters(), cls, data);
                data.methodsTypeParametersLayouts.put(methodReader.getDescriptor(), typeVariablesLayout);
            }
        }
        this.classBinarySizeCalculator.addSize(cls.getName(), this.binaryWriter.getAddress() - binaryWriterAddressBeforeAnalyzeClassMeta);
        this.classLayoutCalculatedDone.put(cls.getName(), true);
    }

    private void setInitialValue(ValueType type, DataValue data, Object value) {
        if (value instanceof Number) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BYTE: {
                    data.setByte(0, ((Number)value).byteValue());
                    break;
                }
                case SHORT: {
                    data.setShort(0, ((Number)value).shortValue());
                    break;
                }
                case CHARACTER: {
                    data.setShort(0, ((Number)value).shortValue());
                    break;
                }
                case INTEGER: {
                    data.setInt(0, ((Number)value).intValue());
                    break;
                }
                case LONG: {
                    data.setLong(0, ((Number)value).longValue());
                    break;
                }
                case FLOAT: {
                    data.setFloat(0, ((Number)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    data.setDouble(0, ((Number)value).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    data.setByte(0, ((Number)value).byteValue());
                }
            }
        } else if (value instanceof Boolean) {
            data.setByte(0, (Boolean)value != false ? (byte)1 : 0);
        } else if (value instanceof String) {
            data.setAddress(0, this.stringPool.getStringPointer((String)value));
        }
    }

    private static DataType asDataType(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    return DataPrimitives.BYTE;
                }
                case SHORT: 
                case CHARACTER: {
                    return DataPrimitives.SHORT;
                }
                case INTEGER: {
                    return DataPrimitives.INT;
                }
                case LONG: {
                    return DataPrimitives.LONG;
                }
                case FLOAT: {
                    return DataPrimitives.FLOAT;
                }
                case DOUBLE: {
                    return DataPrimitives.DOUBLE;
                }
            }
        }
        return DataPrimitives.ADDRESS;
    }

    public static int align(int base, int alignment) {
        if (base == 0) {
            return 0;
        }
        return ((base - 1) / alignment + 1) * alignment;
    }

    public static int getTypeSize(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    return 1;
                }
                case SHORT: 
                case CHARACTER: {
                    return 2;
                }
                case INTEGER: 
                case FLOAT: {
                    return 4;
                }
                case LONG: 
                case DOUBLE: {
                    return 8;
                }
            }
        }
        return 4;
    }

    public void updateClassConstructorsToClasses() {
        for (ClassReader cls : this.toUpdateConstructorsClassHeaders.keySet()) {
            DataValue header = this.toUpdateConstructorsClassHeaders.get(cls);
            Collection<? extends MethodReader> constructors = cls.getConstructors();
            ArrayList<ClassConstructorAddressInfo> constructorFuncIndexList = new ArrayList<ClassConstructorAddressInfo>();
            for (MethodReader methodReader : constructors) {
                int constructorFuncIndex = this.functions.computeIfAbsent(methodReader.getReference(), implementor -> {
                    int result = this.functionTable.size();
                    this.functionTable.add(this.names.forMethod(constructor.getReference()));
                    return result;
                });
                if (constructorFuncIndex < 0) continue;
                constructorFuncIndexList.add(new ClassConstructorAddressInfo(constructorFuncIndex, methodReader.parameterCount(), methodReader.getParameterTypes(), methodReader));
            }
            if (constructorFuncIndexList.isEmpty()) continue;
            int constructorsFuncIndexesCount = constructorFuncIndexList.size();
            int[] nArray = new int[constructorsFuncIndexesCount];
            for (int i = 0; i < constructorsFuncIndexesCount; ++i) {
                int paramsDataValueAddress;
                ClassConstructorAddressInfo classConstructorAddressInfo = (ClassConstructorAddressInfo)constructorFuncIndexList.get(i);
                DataArray paramsDataType = new DataArray(DataPrimitives.INT, classConstructorAddressInfo.funcParamsCount);
                DataValue paramsDataValue = ((DataType)paramsDataType).createValue();
                for (int j = 0; j < classConstructorAddressInfo.funcParamsCount; ++j) {
                    String paramTypeName = classConstructorAddressInfo.funcParamTypes[j].toString();
                    int paramTypeNameStringAddress = this.stringPool.getStringPointer(paramTypeName);
                    paramsDataValue.setInt(j, paramTypeNameStringAddress);
                }
                nArray[i] = paramsDataValueAddress = this.binaryWriter.append(paramsDataValue);
            }
            DataStructure constructorItemDataType = new DataStructure(0, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.INT, DataPrimitives.INT);
            int[] constructorItemDataAddressArray = new int[constructorsFuncIndexesCount];
            for (int i = 0; i < constructorsFuncIndexesCount; ++i) {
                DataValue item = ((DataType)constructorItemDataType).createValue();
                item.setInt(0, ((ClassConstructorAddressInfo)constructorFuncIndexList.get((int)i)).funcIndex);
                item.setInt(1, ((ClassConstructorAddressInfo)constructorFuncIndexList.get((int)i)).funcParamsCount);
                item.setInt(2, nArray[i]);
                int annotationsLayout = 0;
                ClassBinaryData classBinaryData = this.binaryDataMap.get(ValueType.object(cls.getName()));
                if (classBinaryData != null) {
                    annotationsLayout = classBinaryData.constructorsAnnotationLayouts.getOrDefault(((ClassConstructorAddressInfo)constructorFuncIndexList.get((int)i)).constructorMethod.getDescriptor(), 0);
                }
                item.setInt(3, annotationsLayout);
                if (classBinaryData != null) {
                    item.setAddress(4, classBinaryData.methodsTypeParametersLayouts.getOrDefault(((ClassConstructorAddressInfo)constructorFuncIndexList.get((int)i)).constructorMethod.getDescriptor(), 0));
                }
                AccessLevel constructorAccessLevel = ((ClassConstructorAddressInfo)constructorFuncIndexList.get((int)i)).constructorMethod.getLevel();
                int constructorAccessLevelInt = constructorAccessLevel.ordinal();
                int constructorModifiers = ElementModifier.pack(((ClassConstructorAddressInfo)constructorFuncIndexList.get((int)i)).constructorMethod.readModifiers());
                item.setInt(5, constructorAccessLevelInt);
                item.setInt(6, constructorModifiers);
                constructorItemDataAddressArray[i] = this.binaryWriter.append(item);
            }
            DataArray constructorsDataType = new DataArray(DataPrimitives.INT, 1 + constructorsFuncIndexesCount);
            DataValue constructorsDataValue = ((DataType)constructorsDataType).createValue();
            constructorsDataValue.setInt(0, constructorsFuncIndexesCount);
            for (int i = 0; i < constructorsFuncIndexesCount; ++i) {
                constructorsDataValue.setInt(1 + i, constructorItemDataAddressArray[i]);
            }
            int constructorsArrayOffset = this.binaryWriter.append(constructorsDataValue);
            header.setAddress(16, constructorsArrayOffset);
        }
    }

    private long createParameterizedTypeLayout(GenericValueType.Object genericType) {
        if (genericType == null) {
            return 0L;
        }
        ValueType.Object genericValueType = ValueType.object(genericType.getClassName());
        ClassBinaryData binaryData = this.binaryDataMap.get(genericValueType);
        if (binaryData == null) {
            return 0L;
        }
        for (int i = 0; i < genericType.getArguments().length; ++i) {
            GenericValueType.Argument arg = genericType.getArguments()[i];
            if (arg.getValue() != null) continue;
            return 0L;
        }
        DataStructure parameterizedDataType = new DataStructure(0, DataPrimitives.ADDRESS, DataPrimitives.INT, DataPrimitives.ADDRESS);
        DataValue parameterizedDataValue = ((DataType)parameterizedDataType).createValue();
        parameterizedDataValue.setAddress(0, binaryData.start);
        parameterizedDataValue.setInt(1, genericType.getArguments().length);
        DataArray actualTypeArgumentsDataArrayType = new DataArray(DataPrimitives.ADDRESS, genericType.getArguments().length);
        DataValue actualTypeArgumentsDataArray = actualTypeArgumentsDataArrayType.createValue();
        for (int i = 0; i < genericType.getArguments().length; ++i) {
            GenericValueType.Argument argument = genericType.getArguments()[i];
            if (argument.getValue() == null) {
                actualTypeArgumentsDataArray.setInt(i, 0);
                continue;
            }
            String argumentClassName = argument.getValue().toString();
            try {
                ValueType argumentType = ValueType.parse(argumentClassName);
                if (this.binaryDataMap.containsKey(argumentType)) {
                    actualTypeArgumentsDataArray.setAddress(i, this.binaryDataMap.get((Object)argumentType).start);
                    continue;
                }
                actualTypeArgumentsDataArray.setInt(i, 0);
                continue;
            }
            catch (Exception e) {
                actualTypeArgumentsDataArray.setAddress(i, 0L);
            }
        }
        parameterizedDataValue.setAddress(2, this.binaryWriter.append(actualTypeArgumentsDataArray));
        return this.binaryWriter.append(parameterizedDataValue);
    }

    private void fixPlaceholders() {
        for (ClassAddressPlaceholder classAddressPlaceholder : this.classAddressPlaceholders) {
            if (classAddressPlaceholder.classBinaryData == null) continue;
            classAddressPlaceholder.dataValue.setAddress(0, classAddressPlaceholder.classBinaryData.start);
        }
        for (ClassArrayTypePlaceholder classArrayTypePlaceholder : this.classArrayTypePlaceholders) {
            if (classArrayTypePlaceholder.arrayTypeBinaryData == null || classArrayTypePlaceholder.itemTypeBinaryData == null || classArrayTypePlaceholder.itemTypeBinaryData.data == null) continue;
            classArrayTypePlaceholder.itemTypeBinaryData.data.setAddress(9, classArrayTypePlaceholder.arrayTypeBinaryData.start);
        }
        HashMap<GenericValueType.Object, Long> genericLayoutMapCache = new HashMap<GenericValueType.Object, Long>();
        for (ClassParameterizedTypePlaceholder classParameterizedTypePlaceholder : this.classParameterizedTypePlaceholders) {
            GenericValueType.Object genericParent;
            ClassReader cls = ((ClassParameterizedTypePlaceholder)classParameterizedTypePlaceholder).classBinaryData.cls;
            if (cls.getGenericParent() != null && !(genericParent = cls.getGenericParent()).getClassName().equals(Object.class.getName())) {
                ((ClassParameterizedTypePlaceholder)classParameterizedTypePlaceholder).classBinaryData.data.setAddress(15, genericLayoutMapCache.computeIfAbsent(genericParent, this::createParameterizedTypeLayout));
            }
            if (cls.getGenericInterfaces() == null || cls.getGenericInterfaces().size() <= 0) continue;
            ArrayList<Long> notNullGenericAddresses = new ArrayList<Long>();
            for (GenericValueType.Object genericInterface : cls.getGenericInterfaces()) {
                long layout = genericLayoutMapCache.computeIfAbsent(genericInterface, this::createParameterizedTypeLayout);
                if (layout == 0L) continue;
                notNullGenericAddresses.add(layout);
            }
            ((ClassParameterizedTypePlaceholder)classParameterizedTypePlaceholder).classBinaryData.data.setInt(17, notNullGenericAddresses.size());
            DataArray genericInterfacesArrayType = new DataArray(DataPrimitives.ADDRESS, notNullGenericAddresses.size());
            DataValue genericInterfacesArray = ((DataType)genericInterfacesArrayType).createValue();
            for (int i = 0; i < notNullGenericAddresses.size(); ++i) {
                genericInterfacesArray.setAddress(i, (Long)notNullGenericAddresses.get(i));
            }
            ((ClassParameterizedTypePlaceholder)classParameterizedTypePlaceholder).classBinaryData.data.setAddress(18, this.binaryWriter.append(genericInterfacesArray));
        }
        for (ParameterizedTypePlaceholder parameterizedTypePlaceholder : this.parameterizedTypesPlaceholders) {
            parameterizedTypePlaceholder.layoutAddressValue.setAddress(0, genericLayoutMapCache.computeIfAbsent(parameterizedTypePlaceholder.genericType, this::createParameterizedTypeLayout));
        }
    }

    public void postProcess() {
        ClassBinaryData classClassData = this.binaryDataMap.get(ValueType.object("java.lang.Class"));
        if (classClassData != null) {
            int tag = classClassData.start >> 3 | Integer.MIN_VALUE;
            for (ClassBinaryData classData : this.binaryDataMap.values()) {
                if (classData.data == null) continue;
                classData.data.getValue(0).setInt(0, tag);
            }
        }
        this.fixPlaceholders();
        this.writeStaticGcRoots();
        this.writeClasses();
    }

    public int getStaticGcRootsAddress() {
        return this.staticGcRootsAddress;
    }

    public int getClassesAddress() {
        return this.classesAddress;
    }

    public int getClassCount() {
        return this.classCount;
    }

    private void writeStaticGcRoots() {
        DataValue sizeValue = DataPrimitives.INT.createValue();
        sizeValue.setInt(0, this.staticGcRoots.size());
        this.staticGcRootsAddress = this.binaryWriter.append(sizeValue);
        for (int gcRoot : this.staticGcRoots.getAll()) {
            DataValue value = DataPrimitives.ADDRESS.createValue();
            value.setAddress(0, gcRoot);
            this.binaryWriter.append(value);
        }
    }

    private void writeClasses() {
        for (ClassBinaryData cls : this.binaryDataMap.values()) {
            if (cls.start < 0) continue;
            DataValue value = DataPrimitives.ADDRESS.createValue();
            value.setAddress(0, cls.start);
            int address = this.binaryWriter.append(value);
            if (this.classesAddress == 0) {
                this.classesAddress = address;
            }
            ++this.classCount;
        }
    }

    public boolean hasClinit(String className) {
        if (this.isStructure(className) || className.equals(Address.class.getName())) {
            return false;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return false;
        }
        return cls.getMethod(new MethodDescriptor("<clinit>", ValueType.VOID)) != null;
    }

    public boolean isAnnotationClass(ValueType valueType) {
        if (!(valueType instanceof ValueType.Object)) {
            return false;
        }
        ClassReader cls = this.classSource.get(((ValueType.Object)valueType).getClassName());
        if (cls == null) {
            return false;
        }
        return cls.getInterfaces().contains(Annotation.class.getName());
    }

    public void logClassesBinarySizes() {
        this.classBinarySizeCalculator.logClassesBinarySizes();
    }

    public ClassBinarySizeCalculator getClassBinarySizeCalculator() {
        return this.classBinarySizeCalculator;
    }

    static class ClassBinaryData {
        ValueType type;
        int size;
        int alignment;
        int start;
        boolean isInferface;
        ObjectIntMap<String> fieldLayout = new ObjectIntHashMap<String>();
        ObjectIntMap<String> fieldNamesLayout = new ObjectIntHashMap<String>();
        ObjectIntMap<String> methodNamesLayout = new ObjectIntHashMap<String>();
        ObjectIntMap<String> interfacesLayout = new ObjectIntHashMap<String>();
        ObjectIntMap<MethodDescriptor> methodsAnnotationLayouts = new ObjectIntHashMap<MethodDescriptor>();
        ObjectIntMap<String> fieldAnnotationsLayouts = new ObjectIntHashMap<String>();
        ObjectIntMap<MethodDescriptor> constructorsAnnotationLayouts = new ObjectIntHashMap<MethodDescriptor>();
        ObjectIntMap<String> typeVariableNamesLayout = new ObjectIntHashMap<String>();
        ObjectIntMap<MethodDescriptor> methodsTypeParametersLayouts = new ObjectIntHashMap<MethodDescriptor>();
        DataValue data;
        ClassReader cls;
        boolean function;

        ClassBinaryData() {
        }
    }

    private static class ClassConstructorAddressInfo {
        public final int funcIndex;
        public final int funcParamsCount;
        public final ValueType[] funcParamTypes;
        public final MethodReader constructorMethod;

        public ClassConstructorAddressInfo(int funcIndex, int funcParamsCount, ValueType[] funcParamTypes, MethodReader constructorMethod) {
            this.funcIndex = funcIndex;
            this.funcParamsCount = funcParamsCount;
            this.funcParamTypes = funcParamTypes;
            this.constructorMethod = constructorMethod;
        }
    }

    private static class ToUpdateMethodInfoValue {
        public DataValue methodParamTypeNamesArrayInClass;
        public DataValue methodParamTypeNamesArray;

        public ToUpdateMethodInfoValue(DataValue methodParamTypeNamesArrayInClass, DataValue methodParamTypeNamesArray) {
            this.methodParamTypeNamesArrayInClass = methodParamTypeNamesArrayInClass;
            this.methodParamTypeNamesArray = methodParamTypeNamesArray;
        }
    }

    private static class AnnotationInfoToGenerateWasm {
        public String annotationClassName;
        public List<String> fieldNames = new ArrayList<String>();
        public List<AnnotationValue> fieldValues = new ArrayList<AnnotationValue>();

        public AnnotationInfoToGenerateWasm(String annotationClassName, List<String> fieldNames, List<AnnotationValue> fieldValues) {
            this.annotationClassName = annotationClassName;
            this.fieldNames = fieldNames;
            this.fieldValues = fieldValues;
        }
    }

    private static class ParameterizedTypePlaceholder {
        public GenericValueType.Object genericType;
        public DataValue layoutAddressValue;

        public ParameterizedTypePlaceholder(GenericValueType.Object genericType, DataValue layoutAddressValue) {
            this.genericType = genericType;
            this.layoutAddressValue = layoutAddressValue;
        }
    }

    private static class ClassArrayTypePlaceholder {
        public ClassBinaryData arrayTypeBinaryData;
        public ClassBinaryData itemTypeBinaryData;

        public ClassArrayTypePlaceholder(ClassBinaryData arrayTypeBinaryData, ClassBinaryData itemTypeBinaryData) {
            this.arrayTypeBinaryData = arrayTypeBinaryData;
            this.itemTypeBinaryData = itemTypeBinaryData;
        }
    }

    private static class ClassParameterizedTypePlaceholder {
        private ClassBinaryData classBinaryData;

        public ClassParameterizedTypePlaceholder(ClassBinaryData classBinaryData) {
            this.classBinaryData = classBinaryData;
        }
    }

    private static class ClassAddressPlaceholder {
        public ClassBinaryData classBinaryData;
        public DataValue dataValue;

        public ClassAddressPlaceholder(ClassBinaryData classBinaryData, DataValue dataValue) {
            this.classBinaryData = classBinaryData;
            this.dataValue = dataValue;
        }
    }
}

