/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.ast.optimization;

import com.antgroup.antchain.myjava.ast.RecursiveVisitor;
import com.antgroup.antchain.myjava.ast.TryCatchStatement;
import com.antgroup.antchain.myjava.ast.VariableExpr;
import com.antgroup.antchain.myjava.ast.VariableNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class UnusedVariableEliminator
extends RecursiveVisitor {
    private final VariableNode[] variableNodes;
    private final int[] variables;
    private final int[] indexes;
    private List<VariableNode> reorderedVariables = new ArrayList<VariableNode>();
    int lastIndex;

    UnusedVariableEliminator(int parameterCount, List<VariableNode> variables) {
        int i;
        this.variableNodes = new VariableNode[variables.size()];
        this.variables = new int[variables.size()];
        int variableCount = 0;
        for (i = 0; i < variables.size(); ++i) {
            int var;
            this.variableNodes[i] = variables.get(i);
            this.variables[i] = var = variables.get(i).getIndex();
            variableCount = Math.max(variableCount, var + 1);
        }
        this.indexes = new int[variableCount];
        Arrays.fill(this.indexes, -1);
        parameterCount = Math.min(parameterCount, this.indexes.length - 1);
        for (i = 0; i <= parameterCount; ++i) {
            ++this.lastIndex;
            this.reorderedVariables.add(this.variableNodes[i]);
        }
    }

    public List<VariableNode> getReorderedVariables() {
        return this.reorderedVariables;
    }

    private int renumber(int var) {
        VariableNode node;
        int index = this.indexes[this.variables[var]];
        if (index == -1) {
            this.indexes[this.variables[var]] = index = this.lastIndex++;
            this.reorderedVariables.add(this.variableNodes[var]);
        }
        if ((node = this.variableNodes[var]).getName() != null) {
            this.reorderedVariables.get(index).setName(node.getName());
        }
        return index;
    }

    @Override
    public void visit(VariableExpr expr) {
        expr.setIndex(this.renumber(expr.getIndex()));
    }

    @Override
    public void visit(TryCatchStatement statement) {
        super.visit(statement);
        if (statement.getExceptionVariable() != null) {
            if (this.variables[statement.getExceptionVariable()] < 0) {
                statement.setExceptionVariable(null);
            } else {
                statement.setExceptionVariable(this.renumber(statement.getExceptionVariable()));
            }
        }
    }
}

