/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.ast.optimization;

import com.antgroup.antchain.myjava.ast.BinaryExpr;
import com.antgroup.antchain.myjava.ast.BinaryOperation;
import com.antgroup.antchain.myjava.ast.ConditionalExpr;
import com.antgroup.antchain.myjava.ast.ConditionalStatement;
import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.ast.NewExpr;
import com.antgroup.antchain.myjava.ast.RecursiveVisitor;
import com.antgroup.antchain.myjava.ast.Statement;
import java.util.List;

public class ExpressionSideEffectDecomposer
extends RecursiveVisitor {
    private List<Statement> target;

    public ExpressionSideEffectDecomposer(List<Statement> target) {
        this.target = target;
    }

    @Override
    public void visit(ConditionalExpr expr) {
        ConditionalStatement statement = new ConditionalStatement();
        statement.setCondition(expr.getCondition());
        expr.getConsequent().acceptVisitor(new ExpressionSideEffectDecomposer(statement.getConsequent()));
        expr.getAlternative().acceptVisitor(new ExpressionSideEffectDecomposer(statement.getAlternative()));
        this.target.add(statement);
    }

    @Override
    public void visit(InvocationExpr expr) {
        this.target.add(Statement.assign(null, expr));
    }

    @Override
    public void visit(NewExpr expr) {
        this.target.add(Statement.assign(null, expr));
    }

    @Override
    public void visit(BinaryExpr expr) {
        if (expr.getOperation() == BinaryOperation.AND || expr.getOperation() == BinaryOperation.OR) {
            this.target.add(Statement.assign(null, expr));
        } else {
            super.visit(expr);
        }
    }
}

