/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.ast.optimization;

import com.antgroup.antchain.myjava.ast.AssignmentStatement;
import com.antgroup.antchain.myjava.ast.BlockStatement;
import com.antgroup.antchain.myjava.ast.BreakStatement;
import com.antgroup.antchain.myjava.ast.ConditionalStatement;
import com.antgroup.antchain.myjava.ast.ContinueStatement;
import com.antgroup.antchain.myjava.ast.GotoPartStatement;
import com.antgroup.antchain.myjava.ast.IdentifiedStatement;
import com.antgroup.antchain.myjava.ast.InitClassStatement;
import com.antgroup.antchain.myjava.ast.MonitorEnterStatement;
import com.antgroup.antchain.myjava.ast.MonitorExitStatement;
import com.antgroup.antchain.myjava.ast.ReturnStatement;
import com.antgroup.antchain.myjava.ast.SequentialStatement;
import com.antgroup.antchain.myjava.ast.Statement;
import com.antgroup.antchain.myjava.ast.StatementVisitor;
import com.antgroup.antchain.myjava.ast.SwitchClause;
import com.antgroup.antchain.myjava.ast.SwitchStatement;
import com.antgroup.antchain.myjava.ast.ThrowStatement;
import com.antgroup.antchain.myjava.ast.TryCatchStatement;
import com.antgroup.antchain.myjava.ast.WhileStatement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AllBlocksCountVisitor
implements StatementVisitor {
    private Map<IdentifiedStatement, Integer> blocksCount = new HashMap<IdentifiedStatement, Integer>();
    private IdentifiedStatement currentBlock;
    private boolean last = true;

    AllBlocksCountVisitor() {
    }

    public void visit(List<Statement> statements) {
        if (statements == null) {
            return;
        }
        if (statements.isEmpty()) {
            this.incrementCurrentBlock();
            return;
        }
        boolean oldLast = this.last;
        for (int i = 0; i < statements.size() - 1; ++i) {
            this.last = false;
            statements.get(i).acceptVisitor(this);
        }
        this.last = true;
        statements.get(statements.size() - 1).acceptVisitor(this);
        this.last = oldLast;
    }

    public int getCount(IdentifiedStatement statement) {
        Integer result = this.blocksCount.get(statement);
        return result != null ? result : 0;
    }

    @Override
    public void visit(AssignmentStatement statement) {
        if (this.last) {
            this.incrementCurrentBlock();
        }
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.visit(statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        this.visit(statement.getConsequent());
        this.visit(statement.getAlternative());
    }

    @Override
    public void visit(SwitchStatement statement) {
        IdentifiedStatement oldCurrentBlock = this.currentBlock;
        this.currentBlock = statement;
        for (SwitchClause clause : statement.getClauses()) {
            this.visit(clause.getBody());
        }
        this.visit(statement.getDefaultClause());
        this.currentBlock = oldCurrentBlock;
        if (this.last && this.blocksCount.containsKey(statement)) {
            this.incrementCurrentBlock();
        }
    }

    @Override
    public void visit(WhileStatement statement) {
        IdentifiedStatement oldCurrentBlock = this.currentBlock;
        this.currentBlock = statement;
        this.visit(statement.getBody());
        this.currentBlock = oldCurrentBlock;
        if (this.last && (statement.getCondition() != null || this.blocksCount.containsKey(statement))) {
            this.incrementCurrentBlock();
        }
    }

    @Override
    public void visit(BlockStatement statement) {
        IdentifiedStatement oldCurrentBlock = this.currentBlock;
        this.currentBlock = statement;
        this.visit(statement.getBody());
        this.currentBlock = oldCurrentBlock;
        if (this.last && this.blocksCount.containsKey(statement)) {
            this.incrementCurrentBlock();
        }
    }

    @Override
    public void visit(BreakStatement statement) {
        IdentifiedStatement target = statement.getTarget();
        if (target == null) {
            target = this.currentBlock;
        }
        this.incrementBlock(target);
    }

    @Override
    public void visit(ContinueStatement statement) {
        IdentifiedStatement target = statement.getTarget();
        if (target == null) {
            target = this.currentBlock;
        }
        this.incrementBlock(target);
    }

    private void incrementBlock(IdentifiedStatement statement) {
        this.blocksCount.put(statement, this.getCount(statement) + 1);
    }

    private void incrementCurrentBlock() {
        if (this.currentBlock != null) {
            this.incrementBlock(this.currentBlock);
        }
    }

    @Override
    public void visit(ReturnStatement statement) {
    }

    @Override
    public void visit(ThrowStatement statement) {
    }

    @Override
    public void visit(InitClassStatement statement) {
    }

    @Override
    public void visit(TryCatchStatement statement) {
        this.visit(statement.getProtectedBody());
        this.visit(statement.getHandler());
    }

    @Override
    public void visit(GotoPartStatement statement) {
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        if (this.last) {
            this.incrementCurrentBlock();
        }
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        if (this.last) {
            this.incrementCurrentBlock();
        }
    }
}

