/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.ast;

import com.antgroup.antchain.myjava.ast.ArrayType;
import com.antgroup.antchain.myjava.ast.BinaryExpr;
import com.antgroup.antchain.myjava.ast.BinaryOperation;
import com.antgroup.antchain.myjava.ast.ConstantExpr;
import com.antgroup.antchain.myjava.ast.ExprVisitor;
import com.antgroup.antchain.myjava.ast.InstanceOfExpr;
import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.ast.InvocationType;
import com.antgroup.antchain.myjava.ast.NewArrayExpr;
import com.antgroup.antchain.myjava.ast.NewExpr;
import com.antgroup.antchain.myjava.ast.NewMultiArrayExpr;
import com.antgroup.antchain.myjava.ast.OperationType;
import com.antgroup.antchain.myjava.ast.QualificationExpr;
import com.antgroup.antchain.myjava.ast.SubscriptExpr;
import com.antgroup.antchain.myjava.ast.UnaryExpr;
import com.antgroup.antchain.myjava.ast.UnaryOperation;
import com.antgroup.antchain.myjava.ast.VariableExpr;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.TextLocation;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class Expr
implements Cloneable {
    private TextLocation location;

    public abstract void acceptVisitor(ExprVisitor var1);

    public Expr clone() {
        return this.clone(new HashMap<Expr, Expr>());
    }

    protected abstract Expr clone(Map<Expr, Expr> var1);

    public static Expr constant(Object value) {
        ConstantExpr expr = new ConstantExpr();
        expr.setValue(value);
        return expr;
    }

    public static Expr var(int index) {
        VariableExpr expr = new VariableExpr();
        expr.setIndex(index);
        return expr;
    }

    public static Expr binary(BinaryOperation op, OperationType type, Expr first, Expr second) {
        BinaryExpr expr = new BinaryExpr();
        expr.setFirstOperand(first);
        expr.setSecondOperand(second);
        expr.setOperation(op);
        expr.setType(type);
        return expr;
    }

    public static Expr binary(BinaryOperation op, OperationType type, Expr first, Expr second, TextLocation loc) {
        Expr expr = Expr.binary(op, type, first, second);
        expr.setLocation(loc);
        return expr;
    }

    public static Expr unary(UnaryOperation op, OperationType type, Expr arg) {
        UnaryExpr expr = new UnaryExpr();
        expr.setOperand(arg);
        expr.setOperation(op);
        expr.setType(type);
        return expr;
    }

    public static Expr invert(Expr expr) {
        UnaryExpr result = new UnaryExpr();
        result.setOperand(expr);
        result.setOperation(UnaryOperation.NOT);
        result.setLocation(expr.getLocation());
        return result;
    }

    public static Expr subscript(Expr array, Expr index, ArrayType type) {
        SubscriptExpr expr = new SubscriptExpr();
        expr.setArray(array);
        expr.setIndex(index);
        expr.setType(type);
        return expr;
    }

    public static Expr createArray(ValueType type, Expr length) {
        NewArrayExpr expr = new NewArrayExpr();
        expr.setType(type);
        expr.setLength(length);
        return expr;
    }

    public static Expr createArray(ValueType type, Expr ... dimensions) {
        NewMultiArrayExpr expr = new NewMultiArrayExpr();
        expr.setType(type);
        expr.getDimensions().addAll(Arrays.asList(dimensions));
        return expr;
    }

    public static Expr createObject(String type) {
        NewExpr expr = new NewExpr();
        expr.setConstructedClass(type);
        return expr;
    }

    public static InvocationExpr constructObject(MethodReference method, Expr[] arguments) {
        InvocationExpr expr = new InvocationExpr();
        expr.setMethod(method);
        expr.setType(InvocationType.CONSTRUCTOR);
        expr.getArguments().addAll(Arrays.asList(arguments));
        return expr;
    }

    public static Expr qualify(Expr target, FieldReference field) {
        QualificationExpr expr = new QualificationExpr();
        expr.setQualified(target);
        expr.setField(field);
        return expr;
    }

    public static InvocationExpr invoke(MethodReference method, Expr target, Expr[] arguments) {
        InvocationExpr expr = new InvocationExpr();
        expr.setMethod(method);
        expr.setType(InvocationType.DYNAMIC);
        expr.getArguments().add(target);
        expr.getArguments().addAll(Arrays.asList(arguments));
        return expr;
    }

    public static InvocationExpr invokeSpecial(MethodReference method, Expr target, Expr[] arguments) {
        InvocationExpr expr = new InvocationExpr();
        expr.setMethod(method);
        expr.setType(InvocationType.SPECIAL);
        expr.getArguments().add(target);
        expr.getArguments().addAll(Arrays.asList(arguments));
        return expr;
    }

    public static InvocationExpr invokeStatic(MethodReference method, Expr[] arguments) {
        InvocationExpr expr = new InvocationExpr();
        expr.setMethod(method);
        expr.setType(InvocationType.STATIC);
        expr.getArguments().addAll(Arrays.asList(arguments));
        return expr;
    }

    public static Expr instanceOf(Expr target, ValueType className) {
        InstanceOfExpr expr = new InstanceOfExpr();
        expr.setExpr(target);
        expr.setType(className);
        return expr;
    }

    public TextLocation getLocation() {
        return this.location;
    }

    public void setLocation(TextLocation location) {
        this.location = location;
    }
}

