/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TtlCopier;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransmittableThreadLocal<T>
extends InheritableThreadLocal<T>
implements TtlCopier<T> {
    private static final Logger logger = Logger.getLogger(TransmittableThreadLocal.class.getName());
    private static InheritableThreadLocal<WeakHashMap<TransmittableThreadLocal<Object>, ?>> holder = new InheritableThreadLocal<WeakHashMap<TransmittableThreadLocal<Object>, ?>>(){

        @Override
        protected WeakHashMap<TransmittableThreadLocal<Object>, ?> initialValue() {
            return new WeakHashMap();
        }

        @Override
        protected WeakHashMap<TransmittableThreadLocal<Object>, ?> childValue(WeakHashMap<TransmittableThreadLocal<Object>, ?> parentValue) {
            return new WeakHashMap(parentValue);
        }
    };

    @Override
    public T copy(T parentValue) {
        return parentValue;
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    @Override
    public final T get() {
        Object value = super.get();
        if (null != value) {
            this.addValue();
        }
        return value;
    }

    @Override
    public final void set(T value) {
        super.set(value);
        if (null == value) {
            this.removeValue();
        } else {
            this.addValue();
        }
    }

    @Override
    public final void remove() {
        this.removeValue();
        super.remove();
    }

    private void superRemove() {
        super.remove();
    }

    private T copyValue() {
        return this.copy(this.get());
    }

    private void addValue() {
        if (!((WeakHashMap)holder.get()).containsKey(this)) {
            ((WeakHashMap)holder.get()).put(this, null);
        }
    }

    private void removeValue() {
        ((WeakHashMap)holder.get()).remove(this);
    }

    private static void doExecuteCallback(boolean isBefore) {
        for (TransmittableThreadLocal threadLocal : ((WeakHashMap)holder.get()).keySet()) {
            try {
                if (isBefore) {
                    threadLocal.beforeExecute();
                    continue;
                }
                threadLocal.afterExecute();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "TTL exception when " + (isBefore ? "beforeExecute" : "afterExecute") + ", cause: " + t.toString(), t);
            }
        }
    }

    static void dump(@Nullable String title) {
        if (title != null && title.length() > 0) {
            System.out.printf("Start TransmittableThreadLocal[%s] Dump...%n", title);
        } else {
            System.out.println("Start TransmittableThreadLocal Dump...");
        }
        for (TransmittableThreadLocal threadLocal : ((WeakHashMap)holder.get()).keySet()) {
            System.out.println(threadLocal.get());
        }
        System.out.println("TransmittableThreadLocal Dump end!");
    }

    static void dump() {
        TransmittableThreadLocal.dump(null);
    }

    public static class Transmitter {
        private static volatile WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>> threadLocalHolder = new WeakHashMap();
        private static final Object threadLocalHolderUpdateLock = new Object();
        private static final Object threadLocalClearMark = new Object();
        private static final TtlCopier<Object> shadowCopier = new TtlCopier<Object>(){

            @Override
            public Object copy(Object parentValue) {
                return parentValue;
            }
        };

        @NonNull
        public static Object capture() {
            return new Snapshot(Transmitter.captureTtlValues(), Transmitter.captureThreadLocalValues());
        }

        private static WeakHashMap<TransmittableThreadLocal<Object>, Object> captureTtlValues() {
            WeakHashMap<TransmittableThreadLocal<Object>, Object> ttl2Value = new WeakHashMap<TransmittableThreadLocal<Object>, Object>();
            for (TransmittableThreadLocal threadLocal : ((WeakHashMap)holder.get()).keySet()) {
                ttl2Value.put(threadLocal, threadLocal.copyValue());
            }
            return ttl2Value;
        }

        private static WeakHashMap<ThreadLocal<Object>, Object> captureThreadLocalValues() {
            WeakHashMap<ThreadLocal<Object>, Object> threadLocal2Value = new WeakHashMap<ThreadLocal<Object>, Object>();
            for (Map.Entry<ThreadLocal<Object>, TtlCopier<Object>> entry : threadLocalHolder.entrySet()) {
                ThreadLocal<Object> threadLocal = entry.getKey();
                TtlCopier<Object> copier = entry.getValue();
                threadLocal2Value.put(threadLocal, copier.copy(threadLocal.get()));
            }
            return threadLocal2Value;
        }

        @NonNull
        public static Object replay(@NonNull Object captured) {
            Snapshot capturedSnapshot = (Snapshot)captured;
            return new Snapshot(Transmitter.replayTtlValues(capturedSnapshot.ttl2Value), Transmitter.replayThreadLocalValues(capturedSnapshot.threadLocal2Value));
        }

        @NonNull
        private static WeakHashMap<TransmittableThreadLocal<Object>, Object> replayTtlValues(@NonNull WeakHashMap<TransmittableThreadLocal<Object>, Object> captured) {
            WeakHashMap<TransmittableThreadLocal<Object>, Object> backup = new WeakHashMap<TransmittableThreadLocal<Object>, Object>();
            Iterator iterator = ((WeakHashMap)holder.get()).keySet().iterator();
            while (iterator.hasNext()) {
                TransmittableThreadLocal threadLocal = (TransmittableThreadLocal)iterator.next();
                backup.put(threadLocal, threadLocal.get());
                if (captured.containsKey(threadLocal)) continue;
                iterator.remove();
                threadLocal.superRemove();
            }
            Transmitter.setTtlValuesTo(captured);
            TransmittableThreadLocal.doExecuteCallback(true);
            return backup;
        }

        private static WeakHashMap<ThreadLocal<Object>, Object> replayThreadLocalValues(@NonNull WeakHashMap<ThreadLocal<Object>, Object> captured) {
            WeakHashMap<ThreadLocal<Object>, Object> backup = new WeakHashMap<ThreadLocal<Object>, Object>();
            for (Map.Entry<ThreadLocal<Object>, Object> entry : captured.entrySet()) {
                ThreadLocal<Object> threadLocal = entry.getKey();
                backup.put(threadLocal, threadLocal.get());
                Object value = entry.getValue();
                if (value == threadLocalClearMark) {
                    threadLocal.remove();
                    continue;
                }
                threadLocal.set(value);
            }
            return backup;
        }

        @NonNull
        public static Object clear() {
            WeakHashMap ttl2Value = new WeakHashMap();
            WeakHashMap<ThreadLocal<Object>, Object> threadLocal2Value = new WeakHashMap<ThreadLocal<Object>, Object>();
            for (Map.Entry<ThreadLocal<Object>, TtlCopier<Object>> entry : threadLocalHolder.entrySet()) {
                ThreadLocal<Object> threadLocal = entry.getKey();
                threadLocal2Value.put(threadLocal, threadLocalClearMark);
            }
            return Transmitter.replay(new Snapshot(ttl2Value, threadLocal2Value));
        }

        public static void restore(@NonNull Object backup) {
            Snapshot backupSnapshot = (Snapshot)backup;
            Transmitter.restoreTtlValues(backupSnapshot.ttl2Value);
            Transmitter.restoreThreadLocalValues(backupSnapshot.threadLocal2Value);
        }

        private static void restoreTtlValues(@NonNull WeakHashMap<TransmittableThreadLocal<Object>, Object> backup) {
            TransmittableThreadLocal.doExecuteCallback(false);
            Iterator iterator = ((WeakHashMap)holder.get()).keySet().iterator();
            while (iterator.hasNext()) {
                TransmittableThreadLocal threadLocal = (TransmittableThreadLocal)iterator.next();
                if (backup.containsKey(threadLocal)) continue;
                iterator.remove();
                threadLocal.superRemove();
            }
            Transmitter.setTtlValuesTo(backup);
        }

        private static void setTtlValuesTo(@NonNull WeakHashMap<TransmittableThreadLocal<Object>, Object> ttlValues) {
            for (Map.Entry<TransmittableThreadLocal<Object>, Object> entry : ttlValues.entrySet()) {
                TransmittableThreadLocal<Object> threadLocal = entry.getKey();
                threadLocal.set(entry.getValue());
            }
        }

        private static void restoreThreadLocalValues(@NonNull WeakHashMap<ThreadLocal<Object>, Object> backup) {
            for (Map.Entry<ThreadLocal<Object>, Object> entry : backup.entrySet()) {
                ThreadLocal<Object> threadLocal = entry.getKey();
                threadLocal.set(entry.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <R> R runSupplierWithCaptured(@NonNull Object captured, @NonNull Supplier<R> bizLogic) {
            Object backup = Transmitter.replay(captured);
            try {
                R r = bizLogic.get();
                return r;
            }
            finally {
                Transmitter.restore(backup);
            }
        }

        public static <R> R runSupplierWithClear(@NonNull Supplier<R> bizLogic) {
            Object backup = Transmitter.clear();
            try {
                R r = bizLogic.get();
                return r;
            }
            finally {
                Transmitter.restore(backup);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <R> R runCallableWithCaptured(@NonNull Object captured, @NonNull Callable<R> bizLogic) throws Exception {
            Object backup = Transmitter.replay(captured);
            try {
                R r = bizLogic.call();
                return r;
            }
            finally {
                Transmitter.restore(backup);
            }
        }

        public static <R> R runCallableWithClear(@NonNull Callable<R> bizLogic) throws Exception {
            Object backup = Transmitter.clear();
            try {
                R r = bizLogic.call();
                return r;
            }
            finally {
                Transmitter.restore(backup);
            }
        }

        public static <T> boolean registerThreadLocal(ThreadLocal<T> threadLocal, TtlCopier<T> copier) {
            return Transmitter.registerThreadLocal(threadLocal, copier, false);
        }

        public static <T> boolean registerThreadLocalWithShadowCopier(ThreadLocal<T> threadLocal) {
            return Transmitter.registerThreadLocal(threadLocal, shadowCopier, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> boolean registerThreadLocal(ThreadLocal<T> threadLocal, TtlCopier<T> copier, boolean force) {
            if (threadLocal instanceof TransmittableThreadLocal) {
                logger.warning("register a TransmittableThreadLocal instance, this is unnecessary!");
                return true;
            }
            Object object = threadLocalHolderUpdateLock;
            synchronized (object) {
                if (!force && threadLocalHolder.containsKey(threadLocal)) {
                    return false;
                }
                WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>> newHolder = new WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>>(threadLocalHolder);
                newHolder.put(threadLocal, copier);
                threadLocalHolder = newHolder;
                return true;
            }
        }

        public static <T> boolean registerThreadLocalWithShadowCopier(ThreadLocal<T> threadLocal, boolean force) {
            return Transmitter.registerThreadLocal(threadLocal, shadowCopier, force);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> boolean unregisterThreadLocal(ThreadLocal<T> threadLocal) {
            if (threadLocal instanceof TransmittableThreadLocal) {
                logger.warning("unregister a TransmittableThreadLocal instance, this is unnecessary!");
                return true;
            }
            Object object = threadLocalHolderUpdateLock;
            synchronized (object) {
                if (!threadLocalHolder.containsKey(threadLocal)) {
                    return false;
                }
                WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>> newHolder = new WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>>(threadLocalHolder);
                newHolder.remove(threadLocal);
                threadLocalHolder = newHolder;
                return true;
            }
        }

        private Transmitter() {
            throw new InstantiationError("Must not instantiate this class");
        }

        private static class Snapshot {
            final WeakHashMap<TransmittableThreadLocal<Object>, Object> ttl2Value;
            final WeakHashMap<ThreadLocal<Object>, Object> threadLocal2Value;

            private Snapshot(WeakHashMap<TransmittableThreadLocal<Object>, Object> ttl2Value, WeakHashMap<ThreadLocal<Object>, Object> threadLocal2Value) {
                this.ttl2Value = ttl2Value;
                this.threadLocal2Value = threadLocal2Value;
            }
        }
    }
}

