/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.transformlet.impl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.TtlEnhanced;
import com.alibaba.ttl.internal.javassist.CannotCompileException;
import com.alibaba.ttl.internal.javassist.ClassPool;
import com.alibaba.ttl.internal.javassist.CtBehavior;
import com.alibaba.ttl.internal.javassist.CtClass;
import com.alibaba.ttl.internal.javassist.CtMethod;
import com.alibaba.ttl.internal.javassist.CtNewMethod;
import com.alibaba.ttl.internal.javassist.LoaderClassPath;
import com.alibaba.ttl.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class);

    static String signatureOfMethod(CtBehavior method) throws NotFoundException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Modifier.toString(method.getModifiers()));
        if (method instanceof CtMethod) {
            String returnType = ((CtMethod)method).getReturnType().getSimpleName();
            stringBuilder.append(" ").append(returnType);
        }
        stringBuilder.append(" ").append(method.getName()).append("(");
        CtClass[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            CtClass parameterType = parameterTypes[i];
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(parameterType.getSimpleName());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    static CtClass getCtClass(byte[] classFileBuffer, ClassLoader classLoader) throws IOException {
        ClassPool classPool = new ClassPool(true);
        if (classLoader == null) {
            classPool.appendClassPath(new LoaderClassPath(ClassLoader.getSystemClassLoader()));
        } else {
            classPool.appendClassPath(new LoaderClassPath(classLoader));
        }
        CtClass clazz = classPool.makeClass(new ByteArrayInputStream(classFileBuffer), false);
        clazz.defrost();
        return clazz;
    }

    static String renamedMethodNameByTtl(CtMethod method) {
        return "original$" + method.getName() + "$method$renamed$by$ttl";
    }

    static void doTryFinallyForMethod(CtMethod method, String beforeCode, String finallyCode) throws CannotCompileException, NotFoundException {
        Utils.doTryFinallyForMethod(method, Utils.renamedMethodNameByTtl(method), beforeCode, finallyCode);
    }

    static void doTryFinallyForMethod(CtMethod method, String renamedMethodName, String beforeCode, String finallyCode) throws CannotCompileException, NotFoundException {
        CtClass clazz = method.getDeclaringClass();
        CtMethod new_method = CtNewMethod.copy(method, clazz, null);
        method.setName(renamedMethodName);
        method.setModifiers(method.getModifiers() & 0xFFFFFFFE & 0xFFFFFFFB | 2);
        String code = "{\n" + beforeCode + "\ntry {\n    return " + renamedMethodName + "($$);\n} finally {\n    " + finallyCode + "\n} }";
        new_method.setBody(code);
        clazz.addMethod(new_method);
        logger.info("insert code around method " + Utils.signatureOfMethod(method) + " of class " + clazz.getName() + ": " + code);
    }

    public static Object doCaptureWhenNotTtlEnhanced(Object obj) {
        if (obj instanceof TtlEnhanced) {
            return null;
        }
        return TransmittableThreadLocal.Transmitter.capture();
    }
}

