/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TtlTransformer
implements ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(TtlTransformer.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final List<JavassistTransformlet> transformletList = new ArrayList<JavassistTransformlet>();

    TtlTransformer(List<? extends JavassistTransformlet> transformletList) {
        for (JavassistTransformlet javassistTransformlet : transformletList) {
            this.transformletList.add(javassistTransformlet);
            logger.info("[TtlTransformer] add Transformlet " + javassistTransformlet.getClass() + " success");
        }
    }

    @Override
    public final byte[] transform(@Nonnull ClassLoader loader, @Nullable String classFile, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        try {
            if (classFile == null) {
                return EMPTY_BYTE_ARRAY;
            }
            String className = TtlTransformer.toClassName(classFile);
            for (JavassistTransformlet transformlet : this.transformletList) {
                byte[] bytes = transformlet.doTransform(className, classFileBuffer, loader);
                if (bytes == null) continue;
                return bytes;
            }
        }
        catch (Throwable t) {
            String msg = "Fail to transform class " + classFile + ", cause: " + t.toString();
            logger.log(Level.SEVERE, msg, t);
            throw new IllegalStateException(msg, t);
        }
        return EMPTY_BYTE_ARRAY;
    }

    private static String toClassName(String classFile) {
        return classFile.replace('/', '.');
    }
}

