/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import com.alibaba.ttl.threadpool.agent.TtlTransformer;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlExecutorTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlForkJoinTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlTimerTaskTransformlet;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TtlAgent {
    private static volatile Map<String, String> kvs;
    private static volatile boolean ttlAgentLoaded;
    private static final String TTL_AGENT_ENABLE_TIMER_TASK_KEY = "ttl.agent.enable.timer.task";
    private static final String TTL_AGENT_DISABLE_INHERITABLE_FOR_THREAD_POOL = "ttl.agent.disable.inheritable.for.thread.pool";

    public static void premain(String agentArgs, @Nonnull Instrumentation inst) {
        kvs = TtlAgent.splitCommaColonStringToKV(agentArgs);
        Logger.setLoggerImplType(TtlAgent.getLogImplTypeFromAgentArgs(kvs));
        Logger logger = Logger.getLogger(TtlAgent.class);
        try {
            logger.info("[TtlAgent.premain] begin, agentArgs: " + agentArgs + ", Instrumentation: " + inst);
            boolean disableInheritable = TtlAgent.isDisableInheritableForThreadPool();
            ArrayList<JavassistTransformlet> transformletList = new ArrayList<JavassistTransformlet>();
            transformletList.add(new TtlExecutorTransformlet(disableInheritable));
            transformletList.add(new TtlForkJoinTransformlet(disableInheritable));
            if (TtlAgent.isEnableTimerTask()) {
                transformletList.add(new TtlTimerTaskTransformlet());
            }
            TtlTransformer transformer = new TtlTransformer(transformletList);
            inst.addTransformer(transformer, true);
            logger.info("[TtlAgent.premain] addTransformer " + transformer.getClass() + " success");
            logger.info("[TtlAgent.premain] end");
            ttlAgentLoaded = true;
        }
        catch (Exception e) {
            String msg = "Fail to load TtlAgent , cause: " + e.toString();
            logger.log(Level.SEVERE, msg, e);
            throw new IllegalStateException(msg, e);
        }
    }

    private static String getLogImplTypeFromAgentArgs(@Nonnull Map<String, String> kvs) {
        return kvs.get("ttl.agent.logger");
    }

    public static boolean isTtlAgentLoaded() {
        return ttlAgentLoaded;
    }

    public static boolean isDisableInheritableForThreadPool() {
        return TtlAgent.isOptionSet(kvs, TTL_AGENT_DISABLE_INHERITABLE_FOR_THREAD_POOL);
    }

    public static boolean isEnableTimerTask() {
        return TtlAgent.isOptionSet(kvs, TTL_AGENT_ENABLE_TIMER_TASK_KEY);
    }

    private static boolean isOptionSet(@Nullable Map<String, String> kvs, @Nonnull String key) {
        if (null == kvs) {
            return false;
        }
        boolean hasEnableKey = kvs.containsKey(key);
        if (!hasEnableKey) {
            return false;
        }
        return !"false".equalsIgnoreCase(kvs.get(key));
    }

    @Nonnull
    static Map<String, String> splitCommaColonStringToKV(@Nullable String commaColonString) {
        String[] splitKvArray;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (commaColonString == null || commaColonString.trim().length() == 0) {
            return ret;
        }
        for (String kvString : splitKvArray = commaColonString.trim().split("\\s*,\\s*")) {
            String[] kv = kvString.trim().split("\\s*:\\s*");
            if (kv.length == 0) continue;
            if (kv.length == 1) {
                ret.put(kv[0], "");
                continue;
            }
            ret.put(kv[0], kv[1]);
        }
        return ret;
    }

    private TtlAgent() {
        throw new InstantiationError("Must not instantiate this class");
    }

    static {
        ttlAgentLoaded = false;
    }
}

