/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.TtlEnhanced;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public final class TtlTimerTask
extends TimerTask
implements TtlEnhanced {
    private final AtomicReference<Object> capturedRef = new AtomicReference<Object>(TransmittableThreadLocal.Transmitter.capture());
    private final TimerTask timerTask;
    private final boolean releaseTtlValueReferenceAfterRun;

    private TtlTimerTask(@Nonnull TimerTask timerTask, boolean releaseTtlValueReferenceAfterRun) {
        this.timerTask = timerTask;
        this.releaseTtlValueReferenceAfterRun = releaseTtlValueReferenceAfterRun;
    }

    @Override
    public void run() {
        Object captured = this.capturedRef.get();
        if (captured == null || this.releaseTtlValueReferenceAfterRun && !this.capturedRef.compareAndSet(captured, null)) {
            throw new IllegalStateException("TTL value reference is released after run!");
        }
        Object backup = TransmittableThreadLocal.Transmitter.replay(captured);
        try {
            this.timerTask.run();
        }
        finally {
            TransmittableThreadLocal.Transmitter.restore(backup);
        }
    }

    @Override
    public boolean cancel() {
        this.timerTask.cancel();
        return super.cancel();
    }

    @Nonnull
    public TimerTask getTimerTask() {
        return this.timerTask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TtlTimerTask that = (TtlTimerTask)o;
        return this.timerTask != null ? this.timerTask.equals(that.timerTask) : that.timerTask == null;
    }

    public int hashCode() {
        return this.timerTask != null ? this.timerTask.hashCode() : 0;
    }

    @Nullable
    public static TtlTimerTask get(@Nullable TimerTask timerTask) {
        return TtlTimerTask.get(timerTask, false, false);
    }

    @Nullable
    public static TtlTimerTask get(@Nullable TimerTask timerTask, boolean releaseTtlValueReferenceAfterRun) {
        return TtlTimerTask.get(timerTask, releaseTtlValueReferenceAfterRun, false);
    }

    @Nullable
    public static TtlTimerTask get(@Nullable TimerTask timerTask, boolean releaseTtlValueReferenceAfterRun, boolean idempotent) {
        if (null == timerTask) {
            return null;
        }
        if (timerTask instanceof TtlEnhanced) {
            if (idempotent) {
                return (TtlTimerTask)timerTask;
            }
            throw new IllegalStateException("Already TtlTimerTask!");
        }
        return new TtlTimerTask(timerTask, releaseTtlValueReferenceAfterRun);
    }

    @Nullable
    public static TimerTask unwrap(@Nullable TimerTask timerTask) {
        if (!(timerTask instanceof TtlTimerTask)) {
            return timerTask;
        }
        return ((TtlTimerTask)timerTask).getTimerTask();
    }

    @Nonnull
    public static List<TimerTask> unwraps(@Nullable Collection<? extends TimerTask> tasks) {
        if (null == tasks) {
            return Collections.emptyList();
        }
        ArrayList<TimerTask> copy = new ArrayList<TimerTask>();
        for (TimerTask timerTask : tasks) {
            if (!(timerTask instanceof TtlTimerTask)) {
                copy.add(timerTask);
                continue;
            }
            copy.add(((TtlTimerTask)timerTask).getTimerTask());
        }
        return copy;
    }
}

