/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.TtlEnhanced;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TtlRunnable
implements Runnable,
TtlEnhanced {
    private final AtomicReference<Object> capturedRef = new AtomicReference<Object>(TransmittableThreadLocal.Transmitter.capture());
    private final Runnable runnable;
    private final boolean releaseTtlValueReferenceAfterRun;

    private TtlRunnable(@Nonnull Runnable runnable, boolean releaseTtlValueReferenceAfterRun) {
        this.runnable = runnable;
        this.releaseTtlValueReferenceAfterRun = releaseTtlValueReferenceAfterRun;
    }

    @Override
    public void run() {
        Object captured = this.capturedRef.get();
        if (captured == null || this.releaseTtlValueReferenceAfterRun && !this.capturedRef.compareAndSet(captured, null)) {
            throw new IllegalStateException("TTL value reference is released after run!");
        }
        Object backup = TransmittableThreadLocal.Transmitter.replay(captured);
        try {
            this.runnable.run();
        }
        finally {
            TransmittableThreadLocal.Transmitter.restore(backup);
        }
    }

    @Nonnull
    public Runnable getRunnable() {
        return this.runnable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TtlRunnable that = (TtlRunnable)o;
        return this.runnable.equals(that.runnable);
    }

    public int hashCode() {
        return this.runnable.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + " - " + this.runnable.toString();
    }

    @Nullable
    public static TtlRunnable get(@Nullable Runnable runnable) {
        return TtlRunnable.get(runnable, false, false);
    }

    @Nullable
    public static TtlRunnable get(@Nullable Runnable runnable, boolean releaseTtlValueReferenceAfterRun) {
        return TtlRunnable.get(runnable, releaseTtlValueReferenceAfterRun, false);
    }

    @Nullable
    public static TtlRunnable get(@Nullable Runnable runnable, boolean releaseTtlValueReferenceAfterRun, boolean idempotent) {
        if (null == runnable) {
            return null;
        }
        if (runnable instanceof TtlEnhanced) {
            if (idempotent) {
                return (TtlRunnable)runnable;
            }
            throw new IllegalStateException("Already TtlRunnable!");
        }
        return new TtlRunnable(runnable, releaseTtlValueReferenceAfterRun);
    }

    @Nonnull
    public static List<TtlRunnable> gets(@Nullable Collection<? extends Runnable> tasks) {
        return TtlRunnable.gets(tasks, false, false);
    }

    @Nonnull
    public static List<TtlRunnable> gets(@Nullable Collection<? extends Runnable> tasks, boolean releaseTtlValueReferenceAfterRun) {
        return TtlRunnable.gets(tasks, releaseTtlValueReferenceAfterRun, false);
    }

    @Nonnull
    public static List<TtlRunnable> gets(@Nullable Collection<? extends Runnable> tasks, boolean releaseTtlValueReferenceAfterRun, boolean idempotent) {
        if (null == tasks) {
            return Collections.emptyList();
        }
        ArrayList<TtlRunnable> copy = new ArrayList<TtlRunnable>();
        for (Runnable runnable : tasks) {
            copy.add(TtlRunnable.get(runnable, releaseTtlValueReferenceAfterRun, idempotent));
        }
        return copy;
    }

    @Nullable
    public static Runnable unwrap(@Nullable Runnable runnable) {
        if (!(runnable instanceof TtlRunnable)) {
            return runnable;
        }
        return ((TtlRunnable)runnable).getRunnable();
    }

    @Nonnull
    public static List<Runnable> unwraps(@Nullable Collection<? extends Runnable> tasks) {
        if (null == tasks) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> copy = new ArrayList<Runnable>();
        for (Runnable runnable : tasks) {
            if (!(runnable instanceof TtlRunnable)) {
                copy.add(runnable);
                continue;
            }
            copy.add(((TtlRunnable)runnable).getRunnable());
        }
        return copy;
    }
}

