/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.kryo.serializer;

import com.alibaba.kryo.serializer.CachedKryoClassNotFoundException;
import com.alibaba.kryo.serializer.ReadWriteSessionData;
import com.alibaba.kryo.serializer.SessionKryo;
import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.Registration;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.util.DefaultClassResolver;
import com.esotericsoftware.kryo.kryo5.util.Util;

class CachedClassResolver
extends DefaultClassResolver {
    SessionKryo sessionKryo;

    public CachedClassResolver(SessionKryo sessionKryo) {
        this.sessionKryo = sessionKryo;
    }

    protected void writeName(Output output, Class type, Registration registration) {
        ReadWriteSessionData sessionData = this.sessionKryo.sessionData;
        output.writeByte(1);
        int nameId = sessionData.writeClassToNameId.get((Object)type, -1);
        if (nameId != -1) {
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Write class name reference " + nameId + ": " + Util.className((Class)type) + Util.pos((int)output.position())));
            }
            output.writeVarInt(nameId, true);
            return;
        }
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Write class name: " + Util.className((Class)type) + Util.pos((int)output.position())));
        }
        nameId = sessionData.writeNextNameId++;
        sessionData.writeClassToNameId.put((Object)type, nameId);
        sessionData.toWrittenFieldClassSet.add(type);
        output.writeVarInt(nameId, true);
        if (registration.isTypeNameAscii()) {
            output.writeAscii(type.getName());
        } else {
            output.writeString(type.getName());
        }
    }

    protected Registration readName(Input input) {
        ReadWriteSessionData sessionData = this.sessionKryo.sessionData;
        int nameId = input.readVarInt(true);
        Class<?> typeClass = (Class<?>)sessionData.readNameIdToClass.get(nameId);
        if (typeClass == null) {
            String className = input.readString();
            try {
                typeClass = Class.forName(className, false, this.kryo.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                try {
                    typeClass = Class.forName(className, false, Kryo.class.getClassLoader());
                }
                catch (ClassNotFoundException ex2) {
                    throw new CachedKryoClassNotFoundException("Unable to find class: " + className, ex, className);
                }
            }
            sessionData.readNameIdToClass.put(nameId, typeClass);
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Read class name: " + className + Util.pos((int)input.position())));
            }
        } else if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Read class name reference " + nameId + ": " + Util.className(typeClass) + Util.pos((int)input.position())));
        }
        return this.kryo.getRegistration((Class)typeClass);
    }
}

