/*
 * Copyright 1999-2021 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.kryo.serializer;

public class CachedKryoClassNotFoundException extends RuntimeException{
    private String className;

    public CachedKryoClassNotFoundException(String className) {
        this.className = className;
    }

    public CachedKryoClassNotFoundException(String message, String className) {
        super(message);
        this.className = className;
    }

    public CachedKryoClassNotFoundException(String message, Throwable cause, String className) {
        super(message, cause);
        this.className = className;
    }

    public CachedKryoClassNotFoundException(Throwable cause, String className) {
        super(cause);
        this.className = className;
    }

    public CachedKryoClassNotFoundException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, String className) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.className = className;
    }
}
