/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class OtterMigrateMap {
    public static <K, V> ConcurrentMap<K, V> makeComputingMap(MapMaker maker, Function<? super K, ? extends V> computingFunction) {
        return maker.makeComputingMap(computingFunction);
    }

    public static <K, V> ConcurrentMap<K, V> makeComputingMap(Function<? super K, ? extends V> computingFunction) {
        return new MapMaker().makeComputingMap(computingFunction);
    }

    public static <K, V> ConcurrentMap<K, V> makeSoftValueComputingMap(MapMaker maker, Function<? super K, ? extends V> computingFunction) {
        return maker.softValues().makeComputingMap(computingFunction);
    }

    public static <K, V> ConcurrentMap<K, V> makeSoftValueComputingMap(Function<? super K, ? extends V> computingFunction) {
        return new MapMaker().softValues().makeComputingMap(computingFunction);
    }

    public static <K, V> ConcurrentMap<K, V> makeSoftValueComputingMapWithTimeout(MapMaker maker, Function<? super K, ? extends V> computingFunction, long timeout, TimeUnit timeUnit) {
        return maker.expireAfterWrite(timeout, timeUnit).softValues().makeComputingMap(computingFunction);
    }

    public static <K, V> ConcurrentMap<K, V> makeSoftValueComputingMapWithTimeout(Function<? super K, ? extends V> computingFunction, long timeout, TimeUnit timeUnit) {
        return new MapMaker().expireAfterWrite(timeout, timeUnit).softValues().makeComputingMap(computingFunction);
    }

    public static <K, V> ConcurrentMap<K, V> makeSoftValueMapWithTimeout(MapMaker maker, long timeout, TimeUnit timeUnit) {
        return maker.expireAfterWrite(timeout, timeUnit).softValues().makeMap();
    }

    public static <K, V> ConcurrentMap<K, V> makeSoftValueMapWithTimeout(long timeout, TimeUnit timeUnit) {
        return new MapMaker().expireAfterWrite(timeout, timeUnit).softValues().makeMap();
    }

    public static <K, V> ConcurrentMap<K, V> makeSoftValueComputingMapWithRemoveListenr(MapMaker maker, Function<? super K, ? extends V> computingFunction, final OtterRemovalListener listener) {
        return maker.softValues().removalListener(new MapMaker.RemovalListener<K, V>(){

            public void onRemoval(MapMaker.RemovalNotification<K, V> notification) {
                if (notification == null) {
                    return;
                }
                listener.onRemoval(notification.getKey(), notification.getValue());
            }
        }).makeComputingMap(computingFunction);
    }

    public static <K, V> ConcurrentMap<K, V> makeSoftValueComputingMapWithRemoveListenr(Function<? super K, ? extends V> computingFunction, final OtterRemovalListener<K, V> listener) {
        return new MapMaker().softValues().removalListener(new MapMaker.RemovalListener<K, V>(){

            public void onRemoval(MapMaker.RemovalNotification<K, V> notification) {
                if (notification == null) {
                    return;
                }
                listener.onRemoval(notification.getKey(), notification.getValue());
            }
        }).makeComputingMap(computingFunction);
    }

    public static interface OtterRemovalListener<K, V> {
        public void onRemoval(K var1, V var2);
    }
}

