/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.zookeeper;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.exception.ZkException;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ConnectStringParser;
import org.apache.zookeeper.client.HostProvider;
import org.apache.zookeeper.client.StaticHostProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ZooKeeperx
extends ZkConnection {
    private static final String SERVER_COMMA = ";";
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperx.class);
    private static final Field clientCnxnField = ReflectionUtils.findField(ZooKeeper.class, (String)"cnxn");
    private static final Field hostProviderField = ReflectionUtils.findField(ClientCnxn.class, (String)"hostProvider");
    private static final Field serverAddressesField = ReflectionUtils.findField(StaticHostProvider.class, (String)"serverAddresses");
    private static final Field zookeeperLockField = ReflectionUtils.findField(ZkConnection.class, (String)"_zookeeperLock");
    private static final Field zookeeperFiled = ReflectionUtils.findField(ZkConnection.class, (String)"_zk");
    private static final int DEFAULT_SESSION_TIMEOUT = 90000;
    private final List<String> _serversList = Arrays.asList(StringUtils.split((String)this.getServers(), (String)";"));
    private final int _sessionTimeOut;

    public ZooKeeperx(String zkServers) {
        this(zkServers, 90000);
    }

    public ZooKeeperx(String zkServers, int sessionTimeOut) {
        super(zkServers, sessionTimeOut);
        this._sessionTimeOut = sessionTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Watcher watcher) {
        ReflectionUtils.makeAccessible((Field)zookeeperLockField);
        ReflectionUtils.makeAccessible((Field)zookeeperFiled);
        ReentrantLock _zookeeperLock = (ReentrantLock)ReflectionUtils.getField((Field)zookeeperLockField, (Object)((Object)this));
        ZooKeeper _zk = (ZooKeeper)ReflectionUtils.getField((Field)zookeeperFiled, (Object)((Object)this));
        _zookeeperLock.lock();
        try {
            if (_zk != null) {
                throw new IllegalStateException("zk client has already been started");
            }
            String zkServers = this._serversList.get(0);
            try {
                logger.debug("Creating new ZookKeeper instance to connect to " + zkServers + ".");
                _zk = new ZooKeeper(zkServers, this._sessionTimeOut, watcher);
                this.configMutliCluster(_zk);
                ReflectionUtils.setField((Field)zookeeperFiled, (Object)((Object)this), (Object)_zk);
            }
            catch (IOException e) {
                throw new ZkException("Unable to connect to " + zkServers, (Throwable)e);
            }
        }
        finally {
            _zookeeperLock.unlock();
        }
    }

    public void configMutliCluster(ZooKeeper zk) {
        if (this._serversList.size() == 1) {
            return;
        }
        String cluster1 = this._serversList.get(0);
        try {
            if (this._serversList.size() > 1) {
                ReflectionUtils.makeAccessible((Field)clientCnxnField);
                ReflectionUtils.makeAccessible((Field)hostProviderField);
                ReflectionUtils.makeAccessible((Field)serverAddressesField);
                for (int i = 1; i < this._serversList.size(); ++i) {
                    String cluster = this._serversList.get(i);
                    ClientCnxn cnxn = (ClientCnxn)ReflectionUtils.getField((Field)clientCnxnField, (Object)zk);
                    HostProvider hostProvider = (HostProvider)ReflectionUtils.getField((Field)hostProviderField, (Object)cnxn);
                    List serverAddrs = (List)ReflectionUtils.getField((Field)serverAddressesField, (Object)hostProvider);
                    serverAddrs.addAll(new ConnectStringParser(cluster).getServerAddresses());
                }
            }
        }
        catch (Exception e) {
            try {
                if (zk != null) {
                    zk.close();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new ZkException("zookeeper_create_error, serveraddrs=" + cluster1, (Throwable)e);
        }
    }
}

