/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.zookeeper;

import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkEventThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ZkEventThread.class);
    private static AtomicInteger _eventId = new AtomicInteger(0);
    private static final int DEFAULT_POOL_SIZE = 30;
    private static final int DEFAULT_ACCEPT_COUNT = 60;
    private static ExecutorService executor = new ThreadPoolExecutor(30, 30, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(60), new NamedThreadFactory("Arbitrate-Async-Watcher"), new ThreadPoolExecutor.CallerRunsPolicy());
    private BlockingQueue<ZkEvent> _events = new LinkedBlockingQueue<ZkEvent>();

    ZkEventThread(String name) {
        this.setDaemon(true);
        this.setName("ZkClient-EventThread-" + this.getId() + "-" + name);
    }

    @Override
    public void run() {
        LOG.info("Starting ZkClient event thread.");
        try {
            while (!this.isInterrupted()) {
                final ZkEvent zkEvent = this._events.take();
                int eventId = _eventId.incrementAndGet();
                LOG.debug("Delivering event #" + eventId + " " + zkEvent);
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            zkEvent.run();
                        }
                        catch (InterruptedException e) {
                            ZkEventThread.this.interrupt();
                        }
                        catch (ZkInterruptedException e) {
                            ZkEventThread.this.interrupt();
                        }
                        catch (Throwable e) {
                            LOG.error("Error handling event " + zkEvent, e);
                        }
                    }
                });
                LOG.debug("Delivering event #" + eventId + " done");
            }
        }
        catch (InterruptedException e) {
            LOG.info("Terminate ZkClient event thread.");
        }
    }

    public void send(ZkEvent event) {
        if (!this.isInterrupted()) {
            LOG.debug("New event: " + event);
            this._events.add(event);
        }
    }

    public static abstract class ZkEvent {
        private String _description;

        public ZkEvent(String description) {
            this._description = description;
        }

        public abstract void run() throws Exception;

        public String toString() {
            return "ZkEvent[" + this._description + "]";
        }
    }
}

