/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.thread;

import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ExecutorTemplate
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorTemplate.class);
    private String name = "ExecutorTemplate";
    private static final int DEFAULT_POOL_SIZE = 5;
    private int poolSize = 5;
    private ExecutorService executor;
    private volatile ExecutorCompletionService completionService = null;
    private volatile List<Future> futures = null;

    public void start() {
        this.completionService = new ExecutorCompletionService(this.executor);
        this.futures = Collections.synchronizedList(new ArrayList());
    }

    public void submit(Callable<Exception> task) {
        Future<Exception> future = this.completionService.submit(task);
        this.futures.add(future);
        this.check(future);
    }

    public void submit(Runnable task) {
        Future<Object> future = this.completionService.submit(task, null);
        this.futures.add(future);
        this.check(future);
    }

    private void check(Future future) {
        if (future.isDone()) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                this.cancel();
                throw new RuntimeException(e);
            }
            catch (Throwable e) {
                this.cancel();
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized List<?> waitForResult() {
        int index;
        ArrayList result = new ArrayList();
        RuntimeException exception = null;
        for (index = 0; index < this.futures.size(); ++index) {
            try {
                Future future = this.completionService.take();
                result.add(future.get());
                continue;
            }
            catch (InterruptedException e) {
                exception = new RuntimeException(e);
                break;
            }
            catch (Throwable e) {
                exception = new RuntimeException(e);
                break;
            }
        }
        if (index < this.futures.size()) {
            this.cancel();
            throw exception;
        }
        return result;
    }

    public void cancel() {
        logger.info("canal Futures[{}]", (Object)this.futures.size());
        for (int i = 0; i < this.futures.size(); ++i) {
            Future future = this.futures.get(i);
            if (future.isDone() || future.isCancelled()) continue;
            future.cancel(true);
        }
    }

    public void adjustPoolSize(int newPoolSize) {
        if (newPoolSize != this.poolSize) {
            this.poolSize = newPoolSize;
            if (this.executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor pool = (ThreadPoolExecutor)this.executor;
                pool.setCorePoolSize(newPoolSize);
                pool.setMaximumPoolSize(newPoolSize);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.executor = new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.poolSize * 4), new NamedThreadFactory(this.name), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void destroy() throws Exception {
        if (this.futures != null) {
            this.futures.clear();
        }
        this.executor.shutdownNow();
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setName(String name) {
        this.name = name;
    }
}

