/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.thread;

import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ExecutorServiceFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private ThreadPoolExecutor executor;
    private static final int DEFAULT_POOL_SIZE = 50;
    private static final int DEFAULT_ACCEPT_COUNT = 100;
    private int poolSize = 50;
    private int acceptCount = 100;
    private String name = "Otter-Async-Executor";

    public Object getObject() throws Exception {
        return this.executor;
    }

    public Class getObjectType() {
        return ThreadPoolExecutor.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(this.poolSize, this.poolSize, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.acceptCount), new NamedThreadFactory(this.name), new ThreadPoolExecutor.CallerRunsPolicy());
        }
    }

    public void destroy() throws Exception {
        this.executor.shutdown();
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setAcceptCount(int acceptCount) {
        this.acceptCount = acceptCount;
    }

    public void setName(String name) {
        this.name = name;
    }
}

